/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.html;

import java.util.Vector;

public class Tag {
    protected String tag;
    protected String result;
    private boolean startDone;
    private boolean endDone;
    private String startLine;
    private String endLine;
    private String style;
    private Vector children;
    private Tag parent;

    public Tag(String tag) {
        this(null, tag, "", "");
    }

    public Tag(String tag, String startLine, String endLine) {
        this(null, tag, startLine, endLine);
    }

    protected Tag(Tag parent, String tag) {
        this(parent, tag, "", "");
    }

    protected Tag(Tag parent, String tag, String startLine, String endLine) {
        this.tag = tag;
        this.startLine = startLine;
        this.endLine = endLine;
        this.parent = parent;
        this.result = startLine + "<" + tag;
        this.startDone = false;
        this.endDone = false;
    }

    public Tag addAttribute(String name, String value) {
        if (!this.startDone) {
            this.result = this.result + " " + name + "=\"" + value + "\"";
        }
        return this;
    }

    public Tag addStyle(String name, String value) {
        if (!this.startDone) {
            this.style = this.style == null ? "" : this.style + ";";
            this.style = this.style + name + ":" + value;
        }
        return this;
    }

    public Tag addText(String value) {
        this.checkStart();
        this.result = this.result + value;
        return this;
    }

    public String text(String value) {
        this.checkStart();
        this.result = this.result + this.startLine + value + this.endLine;
        return this.end();
    }

    public String end() {
        this.checkStart();
        if (this.startDone && !this.endDone) {
            if (this.children != null) {
                while (this.children.size() > 0) {
                    ((Tag)this.children.get(0)).end();
                }
            }
            this.result = this.result + this.startLine + "</" + this.tag + ">" + this.endLine;
            this.endDone = true;
        }
        if (this.parent != null && this.endDone) {
            this.parent.addText(this.result);
            this.parent.removeChildTag(this);
            this.parent = null;
        }
        return this.result;
    }

    public Tag addChildTag(String tag) {
        return this.addChildTag(tag, "", "");
    }

    public Tag addChildTag(String tag, String startLine, String endLine) {
        if (this.children == null) {
            this.children = new Vector();
        }
        Tag newTag = new Tag(this, tag, startLine, endLine);
        this.children.add(newTag);
        return newTag;
    }

    private void removeChildTag(Tag tag) {
        if (this.children != null) {
            this.children.removeElement(tag);
        }
    }

    private void checkStart() {
        if (!this.startDone) {
            if (this.style != null && this.style.length() != 0) {
                this.addAttribute("style", this.style);
                this.style = "";
            }
            this.result = this.result + ">" + this.endLine;
            this.startDone = true;
        }
    }
}

