/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.jar;

import java.util.StringTokenizer;

public class VersionTracker {
    public VersionStripper version;

    public VersionTracker(String version) {
        this.version = new VersionStripper(version);
    }

    public int compareTo(String value) {
        VersionStripper temp = new VersionStripper(value);
        return this.version.compareTo(temp);
    }

    public class VersionStripper {
        public int[] stripped = new int[4];

        public VersionStripper(String version) {
            StringTokenizer st = new StringTokenizer(version, ".");
            int i = 0;
            while (st.hasMoreTokens()) {
                this.stripped[i++] = Integer.parseInt(st.nextToken());
            }
        }

        public int getMajorVersion() {
            return this.stripped[0];
        }

        public int getMinorVersion() {
            return this.stripped[1];
        }

        public int getRevision() {
            return this.stripped[2];
        }

        public int getBuild() {
            return this.stripped[3];
        }

        public int compareTo(VersionStripper value) {
            int i = 0;
            while (i < 4) {
                if (this.stripped[i] < value.stripped[i]) {
                    return -1;
                }
                if (this.stripped[i] > value.stripped[i]) {
                    return 1;
                }
                ++i;
            }
            return 0;
        }
    }
}

