/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.parser;

import org.amic.util.parser.ParserException;
import org.amic.util.string.StringEx;

public class DelimiterParser {
    private int pos;
    private int len;
    private String value;
    private String token;
    private String[] delimiters;

    public DelimiterParser(String value, String[] delimiters) {
        this.value = value;
        this.delimiters = delimiters;
        this.len = value.length();
        this.pos = 0;
    }

    private String getNextToken() throws ParserException {
        String token = "";
        if (this.pos >= this.len) {
            return token;
        }
        StringEx se = new StringEx(this.value);
        int end = se.indexOfSQ(this.delimiters, this.pos, true);
        token = end > this.pos ? this.value.substring(this.pos, end) : this.value.substring(this.pos);
        this.pos += token.length();
        return token;
    }

    public boolean hasMoreElements() throws ParserException {
        this.token = this.getNextToken();
        return this.token.length() > 0;
    }

    public String nextToken() {
        return this.token;
    }
}

