/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.servlet.cookies;

import java.util.Hashtable;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class CookieTable {
    private Hashtable cookieTable;

    public CookieTable(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        this.cookieTable = new Hashtable();
        if (cookies != null) {
            int i = 0;
            while (i < cookies.length) {
                this.cookieTable.put(cookies[i].getName(), cookies[i]);
                ++i;
            }
        }
    }

    public Cookie getCookie(String name) {
        return (Cookie)this.cookieTable.get(name);
    }

    public String getCookieValue(String name) {
        Cookie c = (Cookie)this.cookieTable.get(name);
        if (c != null) {
            return c.getValue();
        }
        return "";
    }

    public static String getValue(HttpServletRequest request, String name) {
        CookieTable ct = new CookieTable(request);
        return ct.getCookieValue(name);
    }
}

