/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.string;

import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ClassFormatter {
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    private ClassFormatter() {
    }

    public static String format(Object value) {
        return ClassFormatter.format(value, null);
    }

    public static String format(Object value, String pattern) {
        if (pattern == null) {
            pattern = ClassFormatter.getPatternByValue(value);
        }
        if (value instanceof Date) {
            return new SimpleDateFormat(pattern).format(value);
        }
        if (value instanceof Number) {
            return new DecimalFormat(pattern).format(value);
        }
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return ClassFormatter.getTrueFormat(pattern);
            }
            return ClassFormatter.getFalseFormat(pattern);
        }
        return value.toString();
    }

    public static String format(String value, Class jClass, String pattern) {
        block6: {
            if (pattern == null) break block6;
            try {
                Object obj = ClassFormatter.parse(value, jClass, pattern);
                if (ClassFormatter.representsClass(jClass, class$java$util$Date == null ? (class$java$util$Date = ClassFormatter.class$("java.util.Date")) : class$java$util$Date)) {
                    return new SimpleDateFormat(pattern).format(obj);
                }
                if (ClassFormatter.representsClass(jClass, class$java$lang$Number == null ? (class$java$lang$Number = ClassFormatter.class$("java.lang.Number")) : class$java$lang$Number)) {
                    return new DecimalFormat(pattern).format(obj);
                }
                if (ClassFormatter.representsClass(jClass, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassFormatter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    if (value.equalsIgnoreCase(ClassFormatter.getTrueFormat(pattern))) {
                        return ClassFormatter.getTrueFormat(pattern);
                    }
                    return ClassFormatter.getFalseFormat(pattern);
                }
            }
            catch (ParseException ex) {}
        }
        return value.toString();
    }

    public static String format(String value, Class jClass) {
        String pattern = ClassFormatter.getPatternByClass(jClass);
        return ClassFormatter.format(value, jClass, pattern);
    }

    public static String formatNative(String text, Class jClass) {
        String pattern = ClassFormatter.getPatternByClass(jClass);
        return ClassFormatter.formatNative(text, jClass, pattern);
    }

    public static String formatNative(String text, Class jClass, String pattern) {
        Object obj = ClassFormatter.parseNative(text, jClass);
        return ClassFormatter.format(obj, pattern);
    }

    public static Object parseNative(String text, Class jClass) {
        if (text == null) {
            return null;
        }
        try {
            if (ClassFormatter.representsClass(jClass, class$java$util$Date == null ? (class$java$util$Date = ClassFormatter.class$("java.util.Date")) : class$java$util$Date)) {
                return new org.amic.util.date.Date(text);
            }
            Class<?> cls = Class.forName(jClass.getName());
            Constructor<?> cons = cls.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ClassFormatter.class$("java.lang.String")) : class$java$lang$String);
            return cons.newInstance(text);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return text;
        }
    }

    public static Object parse(String text, Class jClass, Object defaultValue) {
        try {
            return ClassFormatter.parse(text, jClass);
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public static Object parse(String text, Class jClass) throws ParseException {
        return ClassFormatter.parse(text, jClass, ClassFormatter.getPatternByClass(jClass));
    }

    public static Object parse(String text, Class jClass, String pattern) throws ParseException {
        if (ClassFormatter.representsClass(jClass, class$java$util$Date == null ? (class$java$util$Date = ClassFormatter.class$("java.util.Date")) : class$java$util$Date) && pattern != null) {
            return new SimpleDateFormat(pattern).parse(text);
        }
        if (ClassFormatter.representsClass(jClass, class$java$util$Date == null ? (class$java$util$Date = ClassFormatter.class$("java.util.Date")) : class$java$util$Date)) {
            return new SimpleDateFormat().parse(text);
        }
        if (ClassFormatter.representsClass(jClass, class$java$lang$Number == null ? (class$java$lang$Number = ClassFormatter.class$("java.lang.Number")) : class$java$lang$Number)) {
            try {
                if (pattern == null) {
                    pattern = ClassFormatter.getPatternByClass(jClass);
                }
                Class<?> cls = Class.forName(jClass.getName());
                Constructor<?> cons = cls.getConstructor(class$java$lang$String == null ? (class$java$lang$String = ClassFormatter.class$("java.lang.String")) : class$java$lang$String);
                return cons.newInstance(new DecimalFormat(pattern).parse(text).toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return text;
            }
        }
        if (ClassFormatter.representsClass(jClass, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassFormatter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            if (pattern != null) {
                return new Boolean(ClassFormatter.getTrueFormat(pattern).equalsIgnoreCase(text));
            }
            return new Boolean(text);
        }
        return text;
    }

    public static boolean representsClass(Class jClass, Class expectedSuper) {
        Class temp = jClass;
        while (temp != null) {
            if (temp.getName().equals(expectedSuper.getName())) {
                return true;
            }
            temp = temp.getSuperclass();
        }
        return false;
    }

    private static String getFalseFormat(String format) {
        if (format == null) {
            return Boolean.TRUE.toString();
        }
        int p = format.indexOf(59);
        return format.substring(0, p);
    }

    private static String getTrueFormat(String format) {
        if (format == null) {
            return Boolean.TRUE.toString();
        }
        int p = format.indexOf(59);
        return format.substring(p + 1);
    }

    private static String getPatternByValue(Object value) {
        if (value instanceof Date) {
            return "dd/MM/yy";
        }
        if (value instanceof Boolean) {
            return "false;true";
        }
        if (value instanceof Number) {
            return "#,###.####";
        }
        return null;
    }

    private static String getPatternByClass(Class jClass) {
        if (ClassFormatter.representsClass(jClass, class$java$util$Date == null ? (class$java$util$Date = ClassFormatter.class$("java.util.Date")) : class$java$util$Date)) {
            return "dd/MM/yy";
        }
        if (ClassFormatter.representsClass(jClass, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassFormatter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            return "false;true";
        }
        if (ClassFormatter.representsClass(jClass, class$java$lang$Number == null ? (class$java$lang$Number = ClassFormatter.class$("java.lang.Number")) : class$java$lang$Number)) {
            return "#,###.####";
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

