/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.amic.util.db.Converter;
import org.amic.util.xml.RecordPacked;
import org.amic.util.xml.TablePacked;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DBImport {
    Document doc;
    InputStream is;
    static /* synthetic */ Class class$java$lang$String;

    public DBImport(InputStream is) {
        this.is = is;
    }

    public Document getDocument() throws SAXException, ParserConfigurationException, IOException {
        this.startDocument();
        return this.doc;
    }

    public void setTableData(TablePacked table) throws SAXException, ParserConfigurationException, IOException {
        this.setTableData(table, false);
    }

    public void setTableData(TablePacked table, boolean restoreTypes) throws SAXException, ParserConfigurationException, IOException {
        this.startDocument();
        Element root = this.doc.getDocumentElement();
        NamedNodeMap nnm = root.getAttributes();
        int idy = 0;
        while (idy < nnm.getLength()) {
            String attribute = nnm.item(idy).getNodeName();
            if (attribute.equalsIgnoreCase("can-insert")) {
                table.setCanInsert(Boolean.valueOf(nnm.item(idy).getNodeValue()));
            } else if (attribute.equalsIgnoreCase("can-delete")) {
                table.setCanDelete(Boolean.valueOf(nnm.item(idy).getNodeValue()));
            } else if (attribute.equalsIgnoreCase("can-update")) {
                table.setCanUpdate(Boolean.valueOf(nnm.item(idy).getNodeValue()));
            }
            ++idy;
        }
        table.setIdentifier(root.getNodeName());
        NodeList list = root.getChildNodes();
        int idx = 0;
        while (idx < list.getLength()) {
            Node node = list.item(idx);
            if (node.getNodeName().equalsIgnoreCase("properties")) {
                this.processProperties(node, table);
            } else if (node.getNodeName().equalsIgnoreCase("metadata")) {
                this.processMetadata(node, table);
                if (restoreTypes) {
                    int rt = 0;
                    while (rt < table.getFieldCount()) {
                        if (table.getFieldTypeName(rt).startsWith("**")) {
                            table.setFieldType(rt, Integer.parseInt(table.getFieldTypeName(rt).substring(2)));
                        }
                        ++rt;
                    }
                }
            } else if (node.getNodeName().equalsIgnoreCase("data")) {
                this.processData(node, table);
            }
            ++idx;
        }
    }

    private void processProperties(Node node, TablePacked table) throws SAXException {
        try {
            NodeList list = node.getChildNodes();
            int idx = 0;
            while (idx < list.getLength()) {
                node = list.item(idx);
                String name = node.getNodeName();
                Node classNode = node.getAttributes().getNamedItem("class");
                String className = classNode != null ? classNode.getNodeValue() : null;
                Node child = node.getFirstChild();
                if (child != null && name != null) {
                    if (className != null && className.trim().length() > 0) {
                        Class<?> cls = Class.forName(className);
                        Constructor<?> cons = cls.getConstructor(class$java$lang$String == null ? DBImport.class$("java.lang.String") : class$java$lang$String);
                        table.putProperty(name, cons.newInstance(child.getNodeValue()));
                    } else {
                        table.putProperty(name, child.getNodeValue());
                    }
                }
                ++idx;
            }
        }
        catch (Exception ex) {
            throw new SAXException(ex.getMessage());
        }
    }

    private void processMetadata(Node node, TablePacked table) {
        NodeList list = node.getChildNodes();
        Vector<String> valids = new Vector<String>();
        int idx = 0;
        while (idx < list.getLength()) {
            String defaultValue = null;
            String label = null;
            String typeName = null;
            int type = 0;
            int displaySize = 0;
            int precision = 0;
            int scale = 0;
            boolean isCurrency = false;
            boolean isEditable = true;
            String format = "";
            valids = new Vector();
            node = list.item(idx);
            String name = node.getNodeName();
            NamedNodeMap nnm = node.getAttributes();
            int idy = 0;
            while (idy < nnm.getLength()) {
                String attribute = nnm.item(idy).getNodeName();
                if (attribute.equalsIgnoreCase("label")) {
                    label = nnm.item(idy).getNodeValue();
                } else if (attribute.equalsIgnoreCase("type")) {
                    type = Integer.parseInt(nnm.item(idy).getNodeValue());
                } else if (attribute.equalsIgnoreCase("type-name")) {
                    typeName = nnm.item(idy).getNodeValue();
                } else if (attribute.equalsIgnoreCase("display-size")) {
                    displaySize = Integer.parseInt(nnm.item(idy).getNodeValue());
                } else if (attribute.equalsIgnoreCase("precision")) {
                    precision = Integer.parseInt(nnm.item(idy).getNodeValue());
                } else if (attribute.equalsIgnoreCase("scale")) {
                    scale = Integer.parseInt(nnm.item(idy).getNodeValue());
                } else if (attribute.equalsIgnoreCase("is-currency")) {
                    isCurrency = Boolean.valueOf(nnm.item(idy).getNodeValue());
                } else if (attribute.equalsIgnoreCase("is-editable")) {
                    isEditable = Boolean.valueOf(nnm.item(idy).getNodeValue());
                } else if (attribute.equalsIgnoreCase("default")) {
                    defaultValue = nnm.item(idy).getNodeValue();
                } else if (attribute.startsWith("format")) {
                    format = nnm.item(idy).getNodeValue();
                } else if (attribute.startsWith("valid-")) {
                    valids.add(nnm.item(idy).getNodeValue());
                }
                ++idy;
            }
            if (name != null) {
                if (name.equals("visible")) {
                    table.setVisibleFieldCount(Integer.parseInt(node.getFirstChild().getNodeValue()));
                } else {
                    table.addField(name, label, typeName, type, displaySize, precision, scale, isCurrency, isEditable);
                    table.setFieldDefaultValue(table.getFieldCount() - 1, new Converter().setString(defaultValue, type).getValue());
                    table.setFieldFormat(table.getFieldCount() - 1, format);
                    table.setFieldValids(table.getFieldCount() - 1, valids.toArray());
                }
            }
            ++idx;
        }
    }

    private void processData(Node node, TablePacked table) {
        int number = 0;
        NodeList list = node.getChildNodes();
        int idx = 0;
        while (idx < list.getLength()) {
            node = list.item(idx);
            if (node.getNodeName().equalsIgnoreCase("record")) {
                boolean inserted = false;
                boolean updated = false;
                boolean deleted = false;
                NamedNodeMap nnm = node.getAttributes();
                int idy = 0;
                while (idy < nnm.getLength()) {
                    String attribute = nnm.item(idy).getNodeName();
                    if (attribute.equalsIgnoreCase("number")) {
                        number = Integer.parseInt(nnm.item(idy).getNodeValue());
                    } else if (attribute.equalsIgnoreCase("inserted")) {
                        inserted = Boolean.valueOf(nnm.item(idy).getNodeValue());
                    } else if (attribute.equalsIgnoreCase("updated")) {
                        updated = Boolean.valueOf(nnm.item(idy).getNodeValue());
                    } else if (attribute.equalsIgnoreCase("deleted")) {
                        deleted = Boolean.valueOf(nnm.item(idy).getNodeValue());
                    }
                    ++idy;
                }
                RecordPacked record = table.insertRecord(number - 1);
                record.setInserted(inserted);
                record.setUpdated(updated);
                record.setDeleted(deleted);
                this.processFields(node, record);
            }
            ++idx;
        }
    }

    private void processFields(Node node, RecordPacked record) {
        NodeList list = node.getChildNodes();
        int idx = 0;
        while (idx < list.getLength()) {
            node = list.item(idx);
            NamedNodeMap nnm = node.getAttributes();
            int idy = 0;
            while (idy < nnm.getLength()) {
                String attribute = nnm.item(idy).getNodeName();
                if (attribute.equalsIgnoreCase("old-value")) {
                    record.setOldValue(idx, new Converter().setString(nnm.item(idy).getNodeValue(), record.getTable().getFieldType(idx)).getValue());
                }
                ++idy;
            }
            Node child = node.getFirstChild();
            if (child == null) {
                record.setValue(idx, null);
            } else {
                record.setValue(idx, new Converter().setString(child.getNodeValue(), record.getTable().getFieldType(idx)).getValue());
            }
            ++idx;
        }
    }

    private void startDocument() throws SAXException, ParserConfigurationException, IOException {
        if (this.doc == null) {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            InputSource ise = new InputSource(this.is);
            ise.setEncoding("ISO-8859-1");
            this.doc = db.parse(ise);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

