/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.xml;

import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Vector;
import org.amic.util.db.Converter;
import org.amic.util.xml.DBTable;
import org.amic.util.xml.RecordPacked;
import org.amic.util.xml.TablePacked;

public class DBRecord
implements RecordPacked {
    private boolean inserted;
    private boolean updated;
    private boolean deleted;
    private Vector values;
    private Vector oldValues;
    private DBTable table;

    public DBRecord(DBTable table) {
        this.table = table;
        int columns = table.getFieldCount();
        this.values = new Vector(columns);
        this.oldValues = new Vector(columns);
        int idx = 0;
        while (idx < columns) {
            this.values.add(table.getFieldDefaultValue(idx));
            this.oldValues.add(null);
            ++idx;
        }
    }

    private DBRecord() {
    }

    public String toString() {
        return this.getString(0);
    }

    public boolean isInserted() {
        return this.inserted;
    }

    public boolean isUpdated() {
        return this.updated;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public boolean isModified() {
        return this.inserted || this.updated || this.deleted;
    }

    public void setInserted(boolean value) {
        this.inserted = value;
    }

    public void setUpdated(boolean value) {
        this.updated = value;
    }

    public void setDeleted(boolean value) {
        this.deleted = value;
    }

    public boolean isNull(int field) {
        return this.values.get(field) == null;
    }

    public Object getValue(int field) {
        return this.values.get(field);
    }

    public Object getOldValue(int field) {
        return this.oldValues.get(field);
    }

    public int getIndex() {
        return this.table.getIndexRecord(this);
    }

    public void setValue(int field, Object value) {
        if (this.oldValues.get(field) == null) {
            this.oldValues.set(field, value);
        }
        if (value != null) {
            Converter cnv = new Converter();
            cnv.setType(this.table.getFieldType(field));
            try {
                String format = (String)this.table.getFieldFormat(field);
                if (format != null && cnv.getValue() instanceof Date) {
                    cnv.setString(value.toString(), format);
                } else {
                    cnv.setString(value.toString());
                }
                value = cnv.getValue();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.values.set(field, value);
    }

    public void setOldValue(int field, Object value) {
        this.oldValues.set(field, value);
    }

    public TablePacked getTable() {
        return this.table;
    }

    public void setTable(TablePacked table) {
        this.table = (DBTable)table;
    }

    public int getInt(int field) {
        return new Converter(this.values.get(field)).getInt();
    }

    public long getLong(int field) {
        return new Converter(this.values.get(field)).getLong();
    }

    public double getDouble(int field) {
        return new Converter(this.values.get(field)).getDouble();
    }

    public String getString(int field) {
        return new Converter(this.values.get(field)).getString();
    }

    public boolean getBoolean(int field) {
        return new Converter(this.values.get(field)).getBoolean();
    }

    public Date getDate(int field) {
        return new Converter(this.values.get(field)).getDate();
    }

    public java.sql.Date getSqlDate(int field) {
        return new Converter(this.values.get(field)).getSqlDate();
    }

    public Time getSqlTime(int field) {
        return new Converter(this.values.get(field)).getSqlTime();
    }

    public Timestamp getSqlTimestamp(int field) {
        return new Converter(this.values.get(field)).getSqlTimestamp();
    }

    public int getOldInt(int field) {
        return new Converter(this.oldValues.get(field)).getInt();
    }

    public long getOldLong(int field) {
        return new Converter(this.oldValues.get(field)).getLong();
    }

    public double getOldDouble(int field) {
        return new Converter(this.oldValues.get(field)).getDouble();
    }

    public String getOldString(int field) {
        return new Converter(this.oldValues.get(field)).getString();
    }

    public boolean getOldBoolean(int field) {
        return new Converter(this.oldValues.get(field)).getBoolean();
    }

    public Date getOldDate(int field) {
        return new Converter(this.oldValues.get(field)).getDate();
    }

    public java.sql.Date getOldSqlDate(int field) {
        return new Converter(this.oldValues.get(field)).getSqlDate();
    }

    public Time getOldSqlTime(int field) {
        return new Converter(this.oldValues.get(field)).getSqlTime();
    }

    public Timestamp getOldSqlTimestamp(int field) {
        return new Converter(this.oldValues.get(field)).getSqlTimestamp();
    }

    public void setInt(int field, int value) {
        this.setValue(field, new Integer(value));
    }

    public void setLong(int field, long value) {
        this.setValue(field, new Integer((int)value));
    }

    public void setDouble(int field, double value) {
        this.setValue(field, new Double(value));
    }

    public void setString(int field, String value) {
        this.setValue(field, new Converter(this.values.get(field)).setString(value).getValue());
    }

    public void setBoolean(int field, boolean value) {
        this.setValue(field, new Boolean(value));
    }

    public void setDate(int field, Date value) {
        this.setValue(field, value);
    }

    public void setSqlDate(int field, java.sql.Date value) {
        this.setValue(field, new Converter().setSqlDate(value).getDate());
    }

    public void setSqlTime(int field, Time value) {
        this.setValue(field, new Converter().setSqlTime(value).getDate());
    }

    public void setSqlTimestamp(int field, Timestamp value) {
        this.setValue(field, new Converter().setSqlTimestamp(value).getDate());
    }

    public void undoFieldChanges(int field) {
        this.setValue(field, this.getOldValue(field));
    }

    public void undoRecordChanges() {
        int idx = 0;
        while (idx < this.getTable().getVisibleFieldCount()) {
            this.undoFieldChanges(idx);
            ++idx;
        }
    }
}

