/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.xml;

import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import org.amic.util.db.Converter;
import org.amic.util.table.FormatterEditor;
import org.amic.util.table.FormatterRenderer;
import org.amic.util.xml.ModelDBTable;

public class JDBTable
extends JTable {
    protected DBTableKeyListener keyListener = new DBTableKeyListener();
    private PopupMenu popup;
    private boolean insertRowVisible = false;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;

    public JDBTable() {
        this((ModelDBTable)null);
    }

    public JDBTable(ModelDBTable table) {
        this.addKeyListener(this.keyListener);
        if (table != null) {
            this.setModel(table);
        }
        this.createResources();
    }

    public void setModel(ModelDBTable table) {
        super.setModel(table);
        TableColumnModel tcm = this.getColumnModel();
        this.setDefaultEditor(class$java$util$Date == null ? (class$java$util$Date = JDBTable.class$("java.util.Date")) : class$java$util$Date, new FormatterEditor("dd/MM/yy HH:mm", class$java$util$Date == null ? (class$java$util$Date = JDBTable.class$("java.util.Date")) : class$java$util$Date));
        this.setDefaultEditor(class$java$lang$Double == null ? (class$java$lang$Double = JDBTable.class$("java.lang.Double")) : class$java$lang$Double, new FormatterEditor("#,###.##", class$java$lang$Double == null ? (class$java$lang$Double = JDBTable.class$("java.lang.Double")) : class$java$lang$Double));
        this.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = JDBTable.class$("java.lang.String")) : class$java$lang$String, new FormatterEditor("", class$java$lang$String == null ? (class$java$lang$String = JDBTable.class$("java.lang.String")) : class$java$lang$String));
        int i = 0;
        while (i < table.getColumnCount() - 1) {
            tcm.getColumn(i).setPreferredWidth(table.getTable().getFieldDisplaySize(i) * 10);
            String format = (String)table.getTable().getFieldFormat(i);
            if (table.getTable().getFieldValids(i).length > 0) {
                JComboBox<Object> cb = new JComboBox<Object>(table.getTable().getFieldValids(i));
                cb.setEditable(table.getTable().isFieldEditable(i));
                tcm.getColumn(i).setCellEditor(new DefaultCellEditor(cb));
            } else if (format != null && format.length() > 0) {
                tcm.getColumn(i).setCellRenderer(new FormatterRenderer((String)table.getTable().getFieldFormat(i), table.getTable().getFieldType(i)));
                tcm.getColumn(i).setCellEditor(new FormatterEditor((String)table.getTable().getFieldFormat(i), new Converter().setType(table.getTable().getFieldType(i)).getValueClass()));
            }
            ++i;
        }
        tcm.getColumn(i).setPreferredWidth(12);
        tcm.getColumn(i).setMaxWidth(12);
        tcm.getColumn(i).setMinWidth(12);
        tcm.getColumn(i).setCellRenderer(new FormatterRenderer("", -1000));
    }

    public void deleteRow() {
        if (this.isEditing()) {
            return;
        }
        ModelDBTable mt = (ModelDBTable)this.getModel();
        if (mt.getTable().canDelete()) {
            int row = this.getSelectedRow();
            mt.deleteRow(row);
            if (row > mt.getRowCount() - 1) {
                row = mt.getRowCount() - 1;
            }
            this.setRowSelectionInterval(row, row);
        }
    }

    public void insertRow() {
        if (this.isEditing() || this.insertRowVisible) {
            return;
        }
        ModelDBTable mt = (ModelDBTable)this.getModel();
        if (mt.getTable().canInsert()) {
            int row = this.getSelectedRow();
            mt.insertRow(row);
            this.setRowSelectionInterval(row, row);
            this.insertRowVisible = true;
        }
    }

    public void appendRow(ModelDBTable mt) {
        if (!this.insertRowVisible) {
            mt.appendRow();
            this.insertRowVisible = true;
        }
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.popup.show(e.getComponent(), e.getX(), e.getY());
        }
        super.processMouseEvent(e);
    }

    private void createResources() {
        ResourceBundle rb = ResourceBundle.getBundle("org/amic/util/xml/JDBTable");
        this.popup = new PopupMenu();
        MenuItem mi = new MenuItem(rb.getString("field.text.cut"));
        mi.setActionCommand("field.text.cut");
        this.popup.add(mi);
        mi = new MenuItem(rb.getString("field.text.copy"));
        mi.setActionCommand("field.text.copy");
        this.popup.add(mi);
        mi = new MenuItem(rb.getString("field.text.paste"));
        mi.setActionCommand("field.text.paste");
        this.popup.add(mi);
        mi = new MenuItem(rb.getString("field.text.delete"));
        mi.setActionCommand("field.text.delete");
        this.popup.add(mi);
        this.popup.addSeparator();
        mi = new MenuItem(rb.getString("field.undo"));
        mi.setActionCommand("field.undo");
        this.popup.add(mi);
        mi = new MenuItem(rb.getString("record.undo"));
        mi.setActionCommand("record.undo");
        this.popup.add(mi);
        this.popup.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String command = e.getActionCommand();
                ModelDBTable mt = (ModelDBTable)JDBTable.this.getModel();
                if (JDBTable.this.getSelectedRow() > -1 && JDBTable.this.getSelectedColumn() > -1) {
                    Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
                    if (command.equalsIgnoreCase("record.undo")) {
                        mt.getTable().getRecord(JDBTable.this.getSelectedRow()).undoRecordChanges();
                        mt.fireRowHasChanged(JDBTable.this.getSelectedRow(), false);
                    } else if (command.equalsIgnoreCase("field.undo")) {
                        mt.getTable().getRecord(JDBTable.this.getSelectedRow()).undoFieldChanges(JDBTable.this.getSelectedColumn());
                        mt.fireRowHasChanged(JDBTable.this.getSelectedRow());
                    } else if (command.equalsIgnoreCase("field.text.cut")) {
                        cb.setContents(new StringSelection(mt.getTable().getRecord(JDBTable.this.getSelectedRow()).getString(JDBTable.this.getSelectedColumn())), null);
                        mt.getTable().getRecord(JDBTable.this.getSelectedRow()).setString(JDBTable.this.getSelectedColumn(), "");
                        mt.fireRowHasChanged(JDBTable.this.getSelectedRow(), true);
                    } else if (command.equalsIgnoreCase("field.text.copy")) {
                        cb.setContents(new StringSelection(mt.getTable().getRecord(JDBTable.this.getSelectedRow()).getString(JDBTable.this.getSelectedColumn())), null);
                    } else if (command.equalsIgnoreCase("field.text.paste")) {
                        Transferable content = cb.getContents(this);
                        try {
                            String s = (String)content.getTransferData(DataFlavor.stringFlavor);
                            mt.getTable().getRecord(JDBTable.this.getSelectedRow()).setString(JDBTable.this.getSelectedColumn(), s);
                        }
                        catch (Throwable exc) {
                            // empty catch block
                        }
                        mt.fireRowHasChanged(JDBTable.this.getSelectedRow(), true);
                    } else if (command.equalsIgnoreCase("field.text.delete")) {
                        mt.getTable().getRecord(JDBTable.this.getSelectedRow()).setString(JDBTable.this.getSelectedColumn(), "");
                        mt.fireRowHasChanged(JDBTable.this.getSelectedRow(), true);
                    }
                }
            }
        });
        this.add(this.popup);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class DBTableKeyListener
    extends KeyAdapter {
        public void keyPressed(KeyEvent evt) {
            if (evt.getKeyCode() == 127 && evt.getModifiers() == 2) {
                JDBTable.this.deleteRow();
                evt.consume();
            } else if (evt.getKeyCode() == 155 && evt.getModifiers() != 2) {
                JDBTable.this.insertRow();
                evt.consume();
            } else if (evt.getKeyCode() == 40) {
                ModelDBTable mt = (ModelDBTable)JDBTable.this.getModel();
                if (mt.getTable().canInsert() && JDBTable.this.getSelectedRow() == mt.getRowCount() - 1) {
                    JDBTable.this.appendRow(mt);
                }
            } else if (evt.getKeyCode() == 10 && evt.getModifiers() != 2) {
                evt.setKeyCode(9);
                ModelDBTable mt = (ModelDBTable)JDBTable.this.getModel();
                if (mt.getTable().canInsert()) {
                    int nextCol = JDBTable.this.getSelectedColumn() + 1;
                    int nextRow = JDBTable.this.getSelectedRow();
                    int maxCol = JDBTable.this.getColumnCount() - 1;
                    int maxRow = JDBTable.this.getRowCount() - 1;
                    if (nextCol >= maxCol) {
                        nextCol = 0;
                        if (++nextRow > maxRow) {
                            if (JDBTable.this.insertRowVisible) {
                                --nextRow;
                            } else {
                                JDBTable.this.appendRow(mt);
                            }
                        }
                    }
                    while (!JDBTable.this.isCellEditable(nextRow, nextCol)) {
                        if (++nextCol < maxCol) continue;
                        nextCol = 0;
                        if (++nextRow <= maxRow) continue;
                        if (JDBTable.this.insertRowVisible) {
                            --nextRow;
                            continue;
                        }
                        JDBTable.this.appendRow(mt);
                    }
                    if (JDBTable.this.isEditing()) {
                        JDBTable.this.cellEditor.stopCellEditing();
                    }
                    JDBTable.this.changeSelection(nextRow, nextCol, false, false);
                    evt.consume();
                }
            } else {
                JDBTable.this.insertRowVisible = false;
            }
        }
    }
}

