/*
 * Decompiled with CFR 0.152.
 */
package org.amic.util.xml;

import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.amic.util.url.UrlCompose;
import org.amic.util.xml.RecordPacked;
import org.amic.util.xml.TablePacked;

public class NodeRenderer
extends DefaultTreeCellRenderer {
    private Hashtable icons = new Hashtable();
    private URL base;
    private TablePacked table;
    private int index;

    public NodeRenderer(URL base, TablePacked table) {
        this.base = base;
        this.table = table;
        this.loadIcons();
    }

    private void loadIcons() {
        this.index = this.table.getIndex("RImage");
        if (this.index == -1) {
            return;
        }
        try {
            int rec = 0;
            while (rec < this.table.getRowCount()) {
                String image = this.table.getRecord(rec).getString(this.index);
                if (image != null && image.length() > 0 && !this.icons.containsKey(image)) {
                    this.icons.put(image, new ImageIcon(new URL(UrlCompose.subsFile(this.base, image))));
                }
                ++rec;
            }
        }
        catch (MalformedURLException ex) {
            // empty catch block
        }
        this.icons.put("root", new ImageIcon(this.getClass().getResource("root.gif")));
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        ImageIcon icon = null;
        if (node.getUserObject() instanceof RecordPacked) {
            if (this.index > -1) {
                RecordPacked record = (RecordPacked)node.getUserObject();
                String image = record.getString(this.index);
                if (image != null && image.length() > 0) {
                    icon = (ImageIcon)this.icons.get(image);
                }
                if (icon != null) {
                    this.setIcon(icon);
                }
            }
        } else {
            icon = (ImageIcon)this.icons.get("root");
            if (icon != null) {
                this.setIcon(icon);
            }
        }
        return this;
    }
}

