/*
 * Decompiled with CFR 0.152.
 */
package org.amic.xml;

import java.util.Comparator;
import java.util.Vector;
import org.amic.util.string.ClassFormatter;
import org.amic.xml.XmlReader;

public class NodeComparator
implements Comparator {
    private Vector orderSequence = null;
    public final String TAG_NAME = "#gN";
    public final String TAG_VALUE = "#gV";

    public void addOrderTip(String name, Class jClass, String format, boolean descendent) {
        this.addOrderTip(new OrderTip(name, jClass, format, descendent));
    }

    public void addOrderTip(OrderTip tip) {
        if (this.orderSequence == null) {
            this.orderSequence = new Vector();
        }
        this.orderSequence.addElement(tip);
    }

    public int compare(Object obj1, Object obj2) {
        if (this.orderSequence == null || this.orderSequence.size() == 0) {
            return 0;
        }
        XmlReader r1 = (XmlReader)obj1;
        XmlReader r2 = (XmlReader)obj2;
        int result = 0;
        int i = 0;
        while (i < this.orderSequence.size()) {
            OrderTip tip = (OrderTip)this.orderSequence.elementAt(i);
            try {
                Object c2;
                Object c1;
                if (tip.name.equals("#gN")) {
                    c1 = r1.getName();
                    c2 = r2.getName();
                } else if (tip.name.equals("#gV")) {
                    c1 = (Comparable)ClassFormatter.parse(r1.getValue(), tip.jClass, tip.format);
                    c2 = (Comparable)ClassFormatter.parse(r2.getValue(), tip.jClass, tip.format);
                } else {
                    c1 = (Comparable)ClassFormatter.parse(r1.getAttribute(tip.name), tip.jClass, tip.format);
                    c2 = (Comparable)ClassFormatter.parse(r2.getAttribute(tip.name), tip.jClass, tip.format);
                }
                result = tip.descendent ? (c2 == null ? -1 : (c1 == null ? 1 : c2.compareTo(c1))) : (c1 == null ? -1 : (c2 == null ? 1 : c1.compareTo(c2)));
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (result != 0) break;
            ++i;
        }
        return result;
    }

    public class OrderTip {
        public String name;
        public String format;
        public Class jClass;
        public boolean descendent;

        public OrderTip(String name, Class jClass, String format, boolean descendent) {
            this.name = name;
            this.jClass = jClass;
            this.format = format;
            this.descendent = descendent;
        }
    }
}

