/*
 * Decompiled with CFR 0.152.
 */
package org.amic.xml;

import java.util.Vector;
import org.amic.util.parser.DelimiterParser;
import org.amic.util.parser.ParserException;
import org.amic.util.string.FindReplace;
import org.amic.xml.NodeSet;
import org.amic.xml.XmlMapper;
import org.amic.xml.XmlReader;

public class XmlFinder {
    private XmlReader reader;
    private XmlMapper mapper;
    private Vector vTokens;
    private NodeSet set;

    public XmlFinder(XmlReader reader) {
        this(reader, new NodeSet());
    }

    public XmlFinder(XmlReader reader, NodeSet set) {
        this(reader, set, null);
    }

    public XmlFinder(XmlReader reader, XmlMapper mapper) {
        this(reader, new NodeSet(), mapper);
    }

    public XmlFinder(XmlReader reader, NodeSet set, XmlMapper mapper) {
        this.reader = reader;
        this.set = set;
        this.mapper = mapper;
    }

    public XmlReader findNode(String expression) {
        NodeSet ns = this.findNodes(expression);
        if (ns.hasNextNode()) {
            return ns.nextNode();
        }
        return null;
    }

    public NodeSet findNodes(String expression) {
        this.vTokens = new Vector();
        XmlReader node = this.reader;
        DelimiterParser parser = new DelimiterParser(expression, new String[]{"/"});
        try {
            while (parser.hasMoreElements()) {
                this.vTokens.add(parser.nextToken());
            }
            if (this.vTokens.size() > 0) {
                if (((String)this.vTokens.elementAt(0)).startsWith("/")) {
                    node = this.reader.getRoot();
                }
                this.fillNode(node, 0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.set;
    }

    public void removeNodes(String expression) {
        XmlFinder xf = new XmlFinder(this.reader);
        NodeSet nodes = xf.findNodes(expression);
        while (nodes.hasNextNode()) {
            nodes.nextNode();
            nodes.removeNode();
        }
    }

    private void fillNode(XmlReader node, int level) throws ParserException {
        if (level >= this.vTokens.size()) {
            return;
        }
        String currToken = (String)this.vTokens.elementAt(level);
        boolean leafNode = this.vTokens.size() == level + 1;
        boolean fits = false;
        boolean nameRE = false;
        boolean valueRE = false;
        int plusLevel = 1;
        DelimiterParser tmpPar = new DelimiterParser(currToken, new String[]{"@"});
        while (tmpPar.hasMoreElements()) {
            FindReplace fr;
            String expression;
            String pValue;
            String pName;
            int p;
            nameRE = false;
            valueRE = false;
            String part = tmpPar.nextToken();
            if (part.startsWith("/")) {
                part = part.substring(1);
            }
            if (part.length() == 0) continue;
            if (part.startsWith("&")) {
                plusLevel = 0;
                part = part.substring(1);
            }
            if ((p = part.indexOf(61)) > -1) {
                pName = p == 0 ? null : part.substring(0, p);
                pValue = part.substring(p + 1);
            } else {
                pName = part;
                pValue = null;
            }
            if (pValue != null && pValue.startsWith("#")) {
                valueRE = true;
                pValue = pValue.substring(1);
            }
            if (pName != null && pName.startsWith("#")) {
                nameRE = true;
                pName = pName.substring(1);
            }
            if (pName.startsWith("@")) {
                pName = pName.substring(1);
                fits = false;
                if (pValue != null) {
                    expression = node.getAttribute(pName);
                    fits = false;
                    if (expression != null) {
                        if (valueRE) {
                            fr = new FindReplace(expression);
                            fits = fr.match(pValue);
                        } else {
                            fits = pValue.equals(expression);
                        }
                    }
                }
            } else if (pValue == null) {
                fits = false;
                expression = node.getName();
                if (expression != null) {
                    if (nameRE) {
                        fr = new FindReplace(expression);
                        fits = fr.match(pName);
                    } else {
                        fits = pName.equals(expression);
                    }
                }
            } else {
                fits = false;
                expression = node.getValue();
                if (expression != null) {
                    if (valueRE) {
                        fr = new FindReplace(expression);
                        fits = fr.match(pValue);
                    } else {
                        fits = pValue.equals(expression);
                    }
                }
            }
            if (!fits) break;
        }
        if (fits) {
            if (leafNode) {
                if (this.mapper != null) {
                    node.setMapper(this.mapper);
                }
                this.set.addNode(node);
            }
            if (!leafNode || plusLevel == 0) {
                NodeSet nodes = node.getNodeSet();
                while (nodes.hasNextNode()) {
                    this.fillNode(nodes.nextNode(), level + plusLevel);
                }
            }
        } else if (plusLevel == 0) {
            this.fillNode(node, level + 1);
        }
    }
}

