/*
 * Decompiled with CFR 0.152.
 */
package org.amic.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.amic.util.string.ClassFormatter;
import org.amic.xml.NodeSet;
import org.amic.xml.NodeSortedSet;
import org.amic.xml.XmlMapper;
import org.amic.xml.XmlWriter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlReader {
    private static Map globalProp = new HashMap();
    private Node node;
    private XmlMapper mapper = null;
    private boolean validating = false;
    private InputStream dtd = null;
    private ErrorHandler handler = null;
    private Map properties = null;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$Boolean;

    public static XmlReader createDocFromString(String value) {
        try {
            return new XmlReader(new ByteArrayInputStream(value.getBytes()));
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static XmlReader createDocFromGZippedContent(byte[] content) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            GZIPInputStream gis = new GZIPInputStream(bis);
            ObjectInputStream ois = new ObjectInputStream(gis);
            return XmlReader.createDocFromString((String)ois.readObject());
        }
        catch (Exception ex) {
            return null;
        }
    }

    public XmlReader(String file) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this(new File(file));
    }

    public XmlReader(File file) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        FileInputStream fis = new FileInputStream(file);
        this.parseXML(fis);
        fis.close();
    }

    public XmlReader(InputStream is) throws IOException, ParserConfigurationException, SAXException {
        this.parseXML(is);
    }

    public XmlReader(InputStream dtd, InputStream is) throws IOException, ParserConfigurationException, SAXException {
        this(dtd, is, null);
    }

    public XmlReader(InputStream dtd, InputStream is, ErrorHandler handler) throws IOException, ParserConfigurationException, SAXException {
        this.validating = true;
        this.dtd = dtd;
        this.handler = handler;
        this.parseXML(is);
    }

    public XmlReader(Node node) {
        this.node = node;
    }

    public XmlReader(Document doc) {
        this.node = doc.getDocumentElement();
    }

    public boolean equals(Object obj) {
        if (obj != null && this.node != null) {
            if (obj instanceof XmlReader) {
                return ((XmlReader)obj).getInternalNode() == this.node;
            }
            if (obj instanceof Node) {
                return obj == this.node;
            }
        }
        return false;
    }

    public void removeProperties() {
        this.iterateNodes(this);
    }

    private void iterateNodes(XmlReader xr) {
        globalProp.remove(xr.getInternalNode());
        NodeSet ns = xr.getNodeSet();
        while (ns.hasNextNode()) {
            this.iterateNodes(ns.nextNode());
        }
    }

    public void setProperty(Object key, Object value) {
        if (this.properties == null) {
            this.properties = (Map)globalProp.get(this.node);
            if (this.properties == null) {
                this.properties = new HashMap();
                globalProp.put(this.node, this.properties);
            }
        }
        this.properties.put(key, value);
    }

    public void setProperties(Map prop) {
        if (this.properties == null) {
            this.properties = (Map)globalProp.get(this.node);
            if (this.properties == null) {
                this.properties = new HashMap();
                globalProp.put(this.node, this.properties);
            }
        }
        this.properties.putAll(prop);
    }

    public Object getProperty(Object key) {
        if (this.properties == null) {
            this.properties = (Map)globalProp.get(this.node);
            if (this.properties == null) {
                return null;
            }
        }
        return this.properties.get(key);
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = (Map)globalProp.get(this.node);
        }
        return this.properties;
    }

    public XmlReader getParent() {
        if (this.isRoot()) {
            return null;
        }
        XmlReader temp = new XmlReader(this.node.getParentNode());
        temp.setMapper(this.mapper);
        return temp;
    }

    public XmlReader getParent(String name) {
        XmlReader temp = this;
        while ((temp = temp.getParent()) != null) {
            if (!temp.getName().equals(name)) continue;
            temp.setMapper(this.mapper);
            return temp;
        }
        return null;
    }

    public XmlReader getChild(String name) {
        NodeSet ns = this.getNodeSet();
        while (ns.hasNextNode()) {
            XmlReader temp = ns.nextNode();
            if (!temp.getName().equals(name)) continue;
            return temp;
        }
        return null;
    }

    public XmlReader getLastChild(String name) {
        NodeSet ns = this.getNodeSet();
        XmlReader result = null;
        while (ns.hasNextNode()) {
            XmlReader temp = ns.nextNode();
            if (!temp.getName().equals(name)) continue;
            result = temp;
        }
        return result;
    }

    public XmlReader getFirstLeafNode() {
        NodeSet ns = this.getNodeSet();
        if (ns.hasNextNode()) {
            return ns.nextNode().getFirstLeafNode();
        }
        return this;
    }

    public XmlReader getSelfOrParent(String name) {
        if (this.getName().equals(name)) {
            return this;
        }
        return this.getParent(name);
    }

    public XmlReader getRoot() {
        XmlReader temp = new XmlReader(this.node.getOwnerDocument().getDocumentElement());
        temp.setMapper(this.mapper);
        return temp;
    }

    public XmlWriter getWriter() {
        XmlWriter xw = new XmlWriter(this.node);
        if (this.mapper != null) {
            xw.setMapper(this.mapper);
        }
        return xw;
    }

    public Document getDocument() {
        return this.node.getOwnerDocument();
    }

    public XmlReader getNewDocumentFromNode() throws ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document newDoc = db.newDocument();
        Node newNode = this.node.cloneNode(true);
        newDoc.appendChild(newNode);
        return new XmlReader(newNode);
    }

    public int getNodeCount() {
        int result = 0;
        NodeList list = this.node.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            if (list.item(i).getNodeType() == 1) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public XmlReader[] getNodes() {
        return this.getNodeSet().toArrayNode();
    }

    public NodeSet getNodeSet() {
        NodeSet set = new NodeSet();
        this.getChildren(set);
        return set;
    }

    public NodeSortedSet getNodeSortedSet() {
        NodeSortedSet set = new NodeSortedSet();
        this.getChildren(set);
        return set;
    }

    public XmlReader getNodeByName(String name) {
        NodeSet set = this.getNodesByName(name, 1);
        if (set.hasNextNode()) {
            return set.nextNode();
        }
        return null;
    }

    public NodeSet getNodesByName(String name) {
        return this.getNodesByName(name, 0);
    }

    public NodeSet getNodesByName(String name, int count) {
        NodeSet set = new NodeSet();
        NodeList list = ((Element)this.node).getElementsByTagName(name);
        int length = list.getLength();
        if (count < 1 || count >= length) {
            count = length;
        }
        int i = 0;
        while (i < count) {
            if (list.item(i).getNodeType() == 1) {
                XmlReader single = new XmlReader(list.item(i));
                single.setMapper(this.mapper);
                set.addNode(single);
            }
            ++i;
        }
        return set;
    }

    public String getValue() {
        String result = null;
        NodeList nl = this.node.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n.getNodeType() == 3 || n.getNodeType() == 4) {
                result = result == null ? n.getNodeValue() : result + n.getNodeValue();
            }
            ++i;
        }
        return result;
    }

    public String getName() {
        return this.node.getNodeName();
    }

    public String getAttribute(String name) {
        Node attr = this.node.getAttributes().getNamedItem(name);
        if (attr != null) {
            return attr.getNodeValue();
        }
        return null;
    }

    public int getIntAttribute(String name, int defaultValue) {
        try {
            return Integer.parseInt(this.getAttribute(name));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public Date getDateAttribute(String name) {
        return this.getDateAttribute(name, "dd/MM/yy");
    }

    public Date getDateAttribute(String name, String format) {
        try {
            return (Date)ClassFormatter.parse(this.getAttribute(name), class$java$util$Date == null ? (class$java$util$Date = XmlReader.class$("java.util.Date")) : class$java$util$Date, format);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public long getLongAttribute(String name, long defaultValue) {
        try {
            return Long.parseLong(this.getAttribute(name));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public double getDoubleAttribute(String name, double defaultValue) {
        try {
            return Double.parseDouble(this.getAttribute(name));
        }
        catch (Exception ex) {
            return defaultValue;
        }
    }

    public String getStrAttribute(String name) {
        String tmp = this.getAttribute(name);
        return tmp == null ? "" : tmp;
    }

    public boolean getBooleanAttribute(String name) {
        return this.getBooleanAttribute(name, null);
    }

    public boolean getBooleanAttribute(String name, String format) {
        String temp = this.getAttribute(name);
        if (temp != null) {
            try {
                return (Boolean)ClassFormatter.parse(temp, class$java$lang$Boolean == null ? (class$java$lang$Boolean = XmlReader.class$("java.lang.Boolean")) : class$java$lang$Boolean, format);
            }
            catch (ParseException ex) {
            }
        }
        return false;
    }

    public NamedNodeMap getAttributes() {
        return this.node.getAttributes();
    }

    public XmlMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(XmlMapper mapper) {
        this.mapper = mapper;
    }

    public String toString() {
        if (this.mapper != null) {
            return this.mapper.applyFormat(this);
        }
        return this.getName();
    }

    public boolean isTextNode() {
        return this.getValue() != null;
    }

    public boolean isRoot() {
        return this.node == this.node.getOwnerDocument().getDocumentElement();
    }

    private void getChildren(NodeSet set) {
        NodeList list = this.node.getChildNodes();
        int length = list.getLength();
        int i = 0;
        while (i < length) {
            if (list.item(i).getNodeType() == 1) {
                XmlReader single = new XmlReader(list.item(i));
                single.setMapper(this.mapper);
                set.addNode(single);
            }
            ++i;
        }
    }

    private void parseXML(InputStream is) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        if (this.validating) {
            dbf.setValidating(true);
        }
        DocumentBuilder db = dbf.newDocumentBuilder();
        if (this.dtd != null) {
            db.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(XmlReader.this.dtd);
                }
            });
        }
        if (this.handler == null) {
            db.setErrorHandler(new ErrorHandler(){

                public void warning(SAXParseException spe) throws SAXException {
                    throw new SAXException("Warning:", spe);
                }

                public void error(SAXParseException spe) throws SAXException {
                    throw new SAXException("Error:", spe);
                }

                public void fatalError(SAXParseException spe) throws SAXException {
                    throw new SAXException("Fatal error:", spe);
                }
            });
        }
        InputSource ise = new InputSource(is);
        ise.setEncoding("ISO-8859-1");
        Document doc = db.parse(ise);
        this.node = doc.getDocumentElement();
    }

    public Node getInternalNode() {
        return this.node;
    }

    public Element getInternalElement() {
        return (Element)this.node;
    }

    public byte[] getGZippedContent() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(bos);
            ObjectOutputStream oos = new ObjectOutputStream(gos);
            oos.writeObject(this.getWriter().getXML());
            oos.close();
            return bos.toByteArray();
        }
        catch (Exception ex) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

