/*
 * Decompiled with CFR 0.152.
 */
package org.amic.xml;

import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.amic.xml.XmlFinder;
import org.amic.xml.XmlReader;

public class XmlTreeSelectionModel
extends DefaultTreeSelectionModel {
    private Vector allowed;
    private Vector nodes;
    private TreePath lastPath;

    public XmlTreeSelectionModel() {
        this(null);
    }

    public XmlTreeSelectionModel(String value) {
        this.addAllowed(value);
        this.setSelectionMode(1);
    }

    public void addAllowed(String value) {
        if (value == null) {
            return;
        }
        if (this.allowed == null) {
            this.allowed = new Vector();
        }
        this.allowed.add(value);
    }

    private boolean checkSelectionPath(TreePath path) {
        return this.checkSelectionNode((TreeNode)path.getLastPathComponent());
    }

    private boolean checkSelectionNode(TreeNode node) {
        XmlReader temp = (XmlReader)((DefaultMutableTreeNode)node).getUserObject();
        boolean done = false;
        boolean negative = false;
        if (this.allowed != null) {
            int i = 0;
            while (i < this.allowed.size()) {
                String path = (String)this.allowed.elementAt(i);
                negative = false;
                if (path.startsWith("!")) {
                    path = path.substring(1);
                    negative = true;
                }
                if (new XmlFinder(temp).findNode(path) != null) {
                    done = !negative;
                    break;
                }
                ++i;
            }
        }
        return done;
    }

    private void trySelectingOne(TreePath currPath) {
        TreePath newPath = null;
        this.fillNodes(currPath);
        int curr = this.getTreeNodePosition(currPath);
        int last = this.getTreeNodePosition(this.lastPath);
        newPath = curr <= last && curr > 0 ? this.selectPrior(currPath) : this.selectNext(currPath);
        if (newPath != null) {
            this.addSelectionPath(newPath);
        }
    }

    private int getTreeNodePosition(TreePath path) {
        if (path == null) {
            return 0;
        }
        return this.nodes.indexOf(path.getLastPathComponent());
    }

    private void iterateNodes(TreeNode root) {
        int i = 0;
        while (i < root.getChildCount()) {
            this.nodes.addElement(root.getChildAt(i));
            this.iterateNodes(root.getChildAt(i));
            ++i;
        }
    }

    private void fillNodes(TreePath path) {
        if (this.nodes == null) {
            this.nodes = new Vector();
            TreeNode root = (TreeNode)path.getPath()[0];
            this.iterateNodes(root);
        }
    }

    private TreePath selectPrior(TreePath path) {
        int i = this.nodes.indexOf(path.getLastPathComponent()) - 1;
        while (i > -1) {
            if (this.checkSelectionNode((TreeNode)this.nodes.elementAt(i))) {
                return this.makePathFromNode((TreeNode)this.nodes.elementAt(i));
            }
            --i;
        }
        return null;
    }

    private TreePath selectNext(TreePath path) {
        int i = this.nodes.indexOf(path.getLastPathComponent()) + 1;
        while (i < this.nodes.size()) {
            if (this.checkSelectionNode((TreeNode)this.nodes.elementAt(i))) {
                return this.makePathFromNode((TreeNode)this.nodes.elementAt(i));
            }
            ++i;
        }
        return null;
    }

    private TreePath makePathFromNode(TreeNode node) {
        Vector<TreeNode> p = new Vector<TreeNode>();
        while (node != null) {
            p.add(0, node);
            node = node.getParent();
        }
        return new TreePath(p.toArray());
    }

    public void resetRowSelection() {
        TreePath currPath = this.getLeadSelectionPath();
        TreePath[] paths = this.getSelectionPaths();
        if (paths == null) {
            return;
        }
        boolean some = false;
        int i = 0;
        while (i < paths.length) {
            if (this.checkSelectionPath(paths[i])) {
                some = true;
            } else {
                this.removeSelectionPath(paths[i]);
            }
            ++i;
        }
        if (!some) {
            this.trySelectingOne(currPath);
        }
        this.lastPath = this.getLeadSelectionPath();
        super.resetRowSelection();
    }
}

