/*
 * Decompiled with CFR 0.152.
 */
package org.amic.xml;

import java.awt.Component;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFileChooser;
import javax.swing.event.EventListenerList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.amic.util.string.ClassFormatter;
import org.amic.xml.NodeSet;
import org.amic.xml.XmlDOMListener;
import org.amic.xml.XmlMapper;
import org.amic.xml.XmlReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlWriter {
    private String encoding = "ISO-8859-1";
    private String dtd = null;
    private String docType = null;
    private boolean indent = false;
    protected static Map DOMdocs = new HashMap();
    private Node node;
    private boolean omitXMLDeclaration = false;
    private XmlMapper mapper = null;
    static /* synthetic */ Class class$org$amic$xml$XmlDOMListener;

    public static XmlWriter createDocFromTag(String tagName) {
        try {
            return new XmlWriter(tagName);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public XmlWriter(String identifier) throws ParserConfigurationException {
        this.startDocument(identifier);
    }

    public XmlWriter(Node node) {
        this(node, 0);
    }

    private XmlWriter(Node node, int fireEvent) {
        this.node = node;
        if (fireEvent == 1) {
            XmlWriter.fireXmlDOMEvent(0, node.getParentNode(), this.getNodeIndex());
        }
    }

    public XmlWriter(Node node, boolean deep) throws ParserConfigurationException {
        this.startDocument(node, deep);
    }

    public XmlWriter(XmlReader reader) {
        this(reader.getInternalNode());
    }

    public XmlWriter(XmlReader reader, boolean deep) throws ParserConfigurationException {
        this(reader.getInternalNode(), deep);
    }

    public XmlWriter(XmlWriter writer) {
        this(writer.getInternalNode());
    }

    public XmlWriter(XmlWriter writer, boolean deep) throws ParserConfigurationException {
        this(writer.getInternalNode(), deep);
    }

    private static Integer getDocHash(Node node) {
        if (node.getOwnerDocument() != null) {
            return new Integer(node.getOwnerDocument().hashCode());
        }
        return new Integer(-1);
    }

    public void addXmlDOMListener(XmlDOMListener l) {
        EventListenerList listenerList = (EventListenerList)DOMdocs.get(XmlWriter.getDocHash(this.node));
        if (listenerList == null) {
            listenerList = new EventListenerList();
            DOMdocs.put(XmlWriter.getDocHash(this.node), listenerList);
        }
        listenerList.add(class$org$amic$xml$XmlDOMListener == null ? (class$org$amic$xml$XmlDOMListener = XmlWriter.class$("org.amic.xml.XmlDOMListener")) : class$org$amic$xml$XmlDOMListener, l);
    }

    public void removeXmlDOMListener(XmlDOMListener l) {
        EventListenerList listenerList = (EventListenerList)DOMdocs.get(XmlWriter.getDocHash(this.node));
        if (listenerList != null) {
            listenerList.remove(class$org$amic$xml$XmlDOMListener == null ? (class$org$amic$xml$XmlDOMListener = XmlWriter.class$("org.amic.xml.XmlDOMListener")) : class$org$amic$xml$XmlDOMListener, l);
        }
    }

    protected static void fireXmlDOMEvent(int operation, Node node, int index) {
        if (node == null) {
            return;
        }
        EventListenerList listenerList = (EventListenerList)DOMdocs.get(XmlWriter.getDocHash(node));
        if (listenerList != null) {
            Object[] listeners = listenerList.getListenerList();
            int i = listeners.length - 2;
            while (i >= 0) {
                if (listeners[i] == (class$org$amic$xml$XmlDOMListener == null ? XmlWriter.class$("org.amic.xml.XmlDOMListener") : class$org$amic$xml$XmlDOMListener)) {
                    ((XmlDOMListener)listeners[i + 1]).nodeChanged(operation, node, index);
                }
                i -= 2;
            }
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setDTD(String docType, String dtd) {
        this.docType = docType;
        this.dtd = dtd;
    }

    public void setIndent(boolean indent) {
        this.indent = indent;
    }

    public void setOmitXMLDeclaration(boolean value) {
        this.omitXMLDeclaration = value;
    }

    public XmlWriter getParent() {
        if (this.node.getParentNode() == null) {
            return null;
        }
        return new XmlWriter(this.node.getParentNode());
    }

    public XmlReader getReader() {
        XmlReader xr = new XmlReader(this.node);
        if (this.mapper != null) {
            xr.setMapper(this.mapper);
        }
        return xr;
    }

    public String getXML() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeXML(out);
            return out.toString();
        }
        catch (TransformerException ex) {
            return null;
        }
    }

    public String getXMLFromNode() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.writeXML((OutputStream)out, true);
            return out.toString();
        }
        catch (TransformerException ex) {
            return null;
        }
    }

    public String getXMLToNode() {
        try {
            XmlWriter newDoc = this.getWriterToNode();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            newDoc.writeXML(out);
            return out.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public XmlWriter getWriterToNode() {
        try {
            return this.fromRoot(null, this);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String getXMLIsolatedTree() {
        try {
            XmlWriter newDoc = this.getWriterIsolatedTree();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            newDoc.writeXML(out);
            return out.toString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public XmlWriter getWriterIsolatedTree() {
        try {
            XmlWriter newDoc = this.fromRoot(null, this.getParent());
            newDoc = newDoc.addNode(this);
            return newDoc;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private XmlWriter fromRoot(XmlWriter writer, XmlWriter iNode) throws Exception {
        if (iNode == null) {
            writer = this;
        }
        if (iNode.getParent() != null) {
            if ((writer = this.fromRoot(writer, iNode.getParent())) == null) {
                return new XmlWriter(iNode, false);
            }
            return writer.addNode(iNode, false);
        }
        return writer;
    }

    public void writeXML(OutputStream out) throws TransformerException {
        this.writeXML(out, false, (StreamSource)null);
    }

    public void writeXML(OutputStream out, boolean partial) throws TransformerException {
        this.writeXML(out, partial, (StreamSource)null);
    }

    public void writeXML(OutputStream out, String stylesheet) throws TransformerException {
        this.writeXML(out, false, stylesheet);
    }

    public void writeXML(OutputStream out, boolean partial, String stylesheet) throws TransformerException {
        this.writeXML(out, partial, new StreamSource(stylesheet));
    }

    public void writeXML(OutputStream out, boolean partial, InputStream stylesheet) throws TransformerException {
        this.writeXML(out, partial, new StreamSource(stylesheet));
    }

    public void writeXML(OutputStream out, boolean partial, Reader stylesheet) throws TransformerException {
        this.writeXML(out, partial, new StreamSource(stylesheet));
    }

    public void writeXML(OutputStream out, boolean partial, StreamSource stylesheet) throws TransformerException {
        Element root = partial ? (Element)this.node : this.node.getOwnerDocument().getDocumentElement();
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = stylesheet != null ? tFactory.newTransformer(stylesheet) : tFactory.newTransformer();
        if (this.omitXMLDeclaration) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        } else {
            transformer.setOutputProperty("omit-xml-declaration", "no");
        }
        if (this.indent) {
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        }
        transformer.setOutputProperty("encoding", this.encoding);
        if (partial) {
            transformer.setOutputProperty("omit-xml-declaration", "yes");
        } else if (this.dtd != null) {
            transformer.setOutputProperty("doctype-" + this.docType, this.dtd);
        }
        DOMSource source = new DOMSource(root);
        StreamResult result = new StreamResult(out);
        transformer.transform(source, result);
    }

    public XmlWriter addNode(String tag) {
        Element temp = this.node.getOwnerDocument().createElement(tag);
        this.node.appendChild(temp);
        return new XmlWriter((Node)temp, 1);
    }

    public XmlWriter addNode(XmlWriter writer) {
        return this.addNode(writer, true);
    }

    public XmlWriter addNode(XmlWriter writer, boolean deep) {
        try {
            writer.writeXML((OutputStream)new ByteArrayOutputStream(), true);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return new XmlWriter(this.node.appendChild(this.node.getOwnerDocument().importNode(writer.getInternalNode(), deep)), 1);
    }

    public XmlWriter addNode(XmlReader reader) {
        return this.addNode(reader, true);
    }

    public XmlWriter addNode(XmlReader reader, boolean deep) {
        try {
            new XmlWriter(reader).writeXML((OutputStream)new ByteArrayOutputStream(), true);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return new XmlWriter(this.node.appendChild(this.node.getOwnerDocument().importNode(reader.getInternalNode(), deep)), 1);
    }

    public void removeNode() {
        int index = this.getNodeIndex();
        Node parent = this.node.getParentNode();
        parent.removeChild(this.node);
        XmlWriter.fireXmlDOMEvent(2, parent, index);
    }

    public int getNodeIndex() {
        if (this.node != null && this.node.getParentNode() != null) {
            NodeList list = this.node.getParentNode().getChildNodes();
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                if (list.item(i) == this.node) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public boolean removeNode(XmlReader reader) {
        if (this.node == reader.getInternalNode()) {
            this.removeNode();
            return true;
        }
        NodeSet ns = this.getReader().getNodeSet();
        while (ns.hasNextNode()) {
            XmlReader xr = ns.nextNode();
            if (!xr.getWriter().removeNode(reader)) continue;
            return true;
        }
        return false;
    }

    public void removeChildren(String name) {
        NodeSet ns = this.getReader().getNodesByName(name);
        while (ns.hasNextNode()) {
            XmlReader xr = ns.nextNode();
            int index = xr.getWriter().getNodeIndex();
            this.node.removeChild(xr.getInternalNode());
            XmlWriter.fireXmlDOMEvent(2, this.node, index);
        }
    }

    public void removeChildren() {
        NodeSet ns = this.getReader().getNodeSet();
        while (ns.hasNextNode()) {
            XmlReader xr = ns.nextNode();
            int index = xr.getWriter().getNodeIndex();
            this.node.removeChild(xr.getInternalNode());
            XmlWriter.fireXmlDOMEvent(2, this.node, index);
        }
    }

    public void removeAttribute(String name) {
        ((Element)this.node).removeAttribute(name);
        XmlWriter.fireXmlDOMEvent(1, this.node.getParentNode(), this.getNodeIndex());
    }

    public XmlWriter insertNode(String tag) {
        Element temp = this.node.getOwnerDocument().createElement(tag);
        this.node.getParentNode().insertBefore(temp, this.node);
        return new XmlWriter((Node)temp, 1);
    }

    public XmlWriter insertNode(XmlWriter writer, boolean deep) {
        try {
            new XmlWriter(writer).writeXML((OutputStream)new ByteArrayOutputStream(), true);
        }
        catch (Exception ex) {
            // empty catch block
        }
        return new XmlWriter(this.node.getParentNode().insertBefore(this.node.getOwnerDocument().importNode(writer.getInternalNode(), deep), this.node), 1);
    }

    public void setAttribute(String name, String value) {
        if (value != null) {
            ((Element)this.node).setAttribute(name, value);
            XmlWriter.fireXmlDOMEvent(1, this.node.getParentNode(), this.getNodeIndex());
        }
    }

    public void setIntAttribute(String name, int value) {
        this.setAttribute(name, "" + value);
    }

    public void setLongAttribute(String name, long value) {
        this.setAttribute(name, "" + value);
    }

    public void setDoubleAttribute(String name, double value) {
        this.setAttribute(name, "" + value);
    }

    public void setDoubleAttribute(String name, double value, int roundTo) {
        double r = Math.pow(10.0, roundTo);
        this.setAttribute(name, "" + (double)Math.round(value * r) / r);
    }

    public void setBooleanAttribute(String name, boolean value) {
        this.setAttribute(name, value ? "true" : "false");
    }

    public void setDateAttribute(String name, Date value) {
        this.setDateAttribute(name, value, "dd/MM/yy");
    }

    public void setDateAttribute(String name, Date value, String format) {
        this.setAttribute(name, ClassFormatter.format(value, format));
    }

    public void setNumberAttribute(String name, Number value) {
        this.setDoubleAttribute(name, value.doubleValue());
    }

    public void setNumberAttribute(String name, Number value, int roundTo) {
        this.setDoubleAttribute(name, value.doubleValue(), roundTo);
    }

    public void setObjectAttribute(String name, Object value) {
        if (value instanceof Number) {
            this.setNumberAttribute(name, (Number)value);
        } else if (value instanceof Date) {
            this.setDateAttribute(name, (Date)value);
        } else if (value instanceof Boolean) {
            this.setBooleanAttribute(name, (Boolean)value);
        } else {
            this.setAttribute(name, value.toString());
        }
    }

    public void cloneAttributesFrom(XmlWriter writer) {
        NamedNodeMap nnm = writer.getInternalNode().getAttributes();
        int i = 0;
        while (i < nnm.getLength()) {
            this.setAttribute(nnm.item(i).getNodeName(), nnm.item(i).getNodeValue());
            ++i;
        }
    }

    public void setText(String text) {
        if (this.node.hasChildNodes()) {
            this.node.removeChild(this.node.getFirstChild());
        }
        if (text.indexOf(60) > -1) {
            this.node.appendChild(this.node.getOwnerDocument().createCDATASection(text));
        } else {
            this.node.appendChild(this.node.getOwnerDocument().createTextNode(text));
        }
        XmlWriter.fireXmlDOMEvent(1, this.node.getParentNode(), this.getNodeIndex());
    }

    public Node getInternalNode() {
        return this.node;
    }

    public void saveToFile(Component owner) {
        this.saveToFile(owner, null, false);
    }

    public void saveToFile(Component owner, String file, boolean direct) {
        boolean doIt = true;
        File f = null;
        if (file != null) {
            f = new File(file);
        }
        try {
            if (!direct) {
                doIt = false;
                JFileChooser fc = new JFileChooser();
                if (f != null) {
                    fc.setSelectedFile(f);
                }
                if (fc.showSaveDialog(owner) == 0) {
                    f = fc.getSelectedFile();
                    doIt = true;
                }
            }
            if (doIt && f != null) {
                FileOutputStream fos = new FileOutputStream(f);
                this.indent = true;
                this.writeXML(fos);
                fos.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void output() {
        try {
            this.setIndent(true);
            this.writeXML(System.out);
        }
        catch (Exception ex) {}
    }

    public void outputNode() {
        try {
            this.setIndent(true);
            this.writeXML((OutputStream)System.out, true);
        }
        catch (Exception ex) {}
    }

    public XmlMapper getMapper() {
        return this.mapper;
    }

    public void setMapper(XmlMapper mapper) {
        this.mapper = mapper;
    }

    private void startDocument(String identifier) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        Element root = doc.createElement(identifier);
        doc.appendChild(root);
        this.node = root;
    }

    private void startDocument(Node element, boolean deep) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.newDocument();
        try {
            new XmlWriter(element).writeXML((OutputStream)new ByteArrayOutputStream(), true);
        }
        catch (Exception ex) {
            // empty catch block
        }
        Element root = (Element)doc.importNode(element, deep);
        doc.appendChild(root);
        this.node = root;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

