/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.lib.buffer.spi.operations;

import org.gvsig.raster.lib.buffer.api.Buffer;
import org.gvsig.raster.lib.buffer.api.exceptions.BufferOperationException;
import org.gvsig.raster.lib.buffer.api.operations.OperationFactory;
import org.gvsig.raster.lib.buffer.spi.exceptions.ProcessingOperationException;
import org.gvsig.raster.lib.buffer.spi.operations.OperationServices;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.task.SimpleTaskStatus;
import org.gvsig.tools.task.TaskStatusManager;

public abstract class AbstractOperation
implements OperationServices {
    public static String COPY_UNPROCESSED_BANDS_PARAM = "copy_unprocessed_bands";
    private Buffer buffer;
    private DynObject parameters;
    private Buffer outputBuffer;
    private final OperationFactory factory;
    private SimpleTaskStatus taskStatus;
    private boolean copyUnprocessedBands;

    protected AbstractOperation(OperationFactory factory) {
        this.factory = factory;
    }

    protected boolean mustCopyUnprocessedBands() {
        return this.copyUnprocessedBands;
    }

    @Override
    public void preProcess() throws BufferOperationException {
        this.copyUnprocessedBands = this.parameters.getDynClass().getDynField(COPY_UNPROCESSED_BANDS_PARAM) != null && this.parameters.hasDynValue(COPY_UNPROCESSED_BANDS_PARAM) ? (Boolean)this.parameters.getDynValue(COPY_UNPROCESSED_BANDS_PARAM) : true;
    }

    @Override
    public SimpleTaskStatus getTaskStatus() {
        if (this.taskStatus == null) {
            TaskStatusManager taskStatusManager = ToolsLocator.getTaskStatusManager();
            this.taskStatus = taskStatusManager.createDefaultSimpleTaskStatus(this.getFactory().getName());
            this.taskStatus.setAutoremove(true);
            this.taskStatus.add();
        }
        return this.taskStatus;
    }

    @Override
    public void process() throws ProcessingOperationException {
    }

    @Override
    public void postProcess() throws BufferOperationException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer execute(SimpleTaskStatus status, Buffer buffer, DynObject parameters) throws BufferOperationException {
        this.buffer = buffer;
        this.parameters = parameters;
        this.taskStatus = status;
        try {
            this.taskStatus.push();
            this.preProcess();
            this.process();
            this.postProcess();
            Buffer buffer2 = this.getOutputBuffer();
            return buffer2;
        }
        finally {
            if (this.taskStatus.isRunning()) {
                this.taskStatus.terminate();
            }
            this.taskStatus.pop();
        }
    }

    public OperationFactory getFactory() {
        return this.factory;
    }

    @Override
    public DynObject getParameters() {
        return this.parameters;
    }

    @Override
    public Object getParameter(String name, Object defaultValue) {
        if (this.parameters.getDynClass().getDynField(name) != null) {
            return this.getParameters().getDynValue(name);
        }
        return defaultValue;
    }

    @Override
    public void setParameter(String name, Object value) {
        this.getParameters().setDynValue(name, value);
    }

    @Override
    public Buffer getInputBuffer() {
        return this.buffer;
    }

    @Override
    public Buffer getOutputBuffer() {
        return this.outputBuffer;
    }

    @Override
    public void setOutputBuffer(Buffer theOutputBuffer) {
        this.outputBuffer = theOutputBuffer;
    }
}

