/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.align;

import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class AlignEdgesEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private static final String ALIGN_MODE = "_align_mode";
    private static final String ALIGN_UP = "_up";
    private static final String ALIGN_DOWN = "_down";
    private static final String ALIGN_LEFT = "_left";
    private static final String ALIGN_RIGHT = "_right";
    private static final String ALIGN_HORIZONTAL_CENTER = "_horizontal_centering";
    private static final String ALIGN_VERTICAL_CENTER = "_vertical_centering";
    private static final String ALIGN_BOTH_CENTER = "_both_centering";
    private static final String SHORT_ALIGN_UP = "_short_up";
    private static final String SHORT_ALIGN_DOWN = "_short_down";
    private static final String SHORT_ALIGN_LEFT = "_short_left";
    private static final String SHORT_ALIGN_RIGHT = "_short_right";
    private static final String SHORT_ALIGN_HORIZONTAL_CENTER = "_short_horizontal_centering";
    private static final String SHORT_ALIGN_VERTICAL_CENTER = "_short_vertical_centering";
    private static final String SHORT_ALIGN_BOTH_CENTER = "_short_both_centering";
    private static final String DO_COPY_QUESTION = "_do_copy_question";
    private static final String DELETE_ORIGINAL_GEOMETRIES = "_delete_original_geometries";
    private static final String DO_COPY = "_do_copy";
    private static final String YES = "_yes";
    private static final String NO = "_no";
    private static final String SHORT_YES = "_short_yes";
    private static final String SHORT_NO = "_short_no";
    private static String savedAlignMode;
    private static Boolean savedDoCopy;
    private final EditingServiceParameter geometryBaseParameter;
    private final EditingServiceParameter alignModeParameter;
    private final EditingServiceParameter doCopyParameter;
    private final EditingServiceParameter featureToAlignParameter;
    private final Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;
    private final MapContext mapContext;
    private List<Feature> selectedFeatures;

    public AlignEdgesEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.mapContext = (MapContext)parameters.getDynValue("mapContext");
        this.geometryBaseParameter = new DefaultEditingServiceParameter("_geometry_base", "_geometry_base", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.featureToAlignParameter = new DefaultEditingServiceParameter("_geometry_to_align", "_geometry_to_align", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        DefaultEditingServiceParameterOptions alignModeOptions = new DefaultEditingServiceParameterOptions().add(i18nManager.getTranslation(ALIGN_UP), (Object)ALIGN_UP, i18nManager.getTranslation(SHORT_ALIGN_UP)).add(i18nManager.getTranslation(ALIGN_DOWN), (Object)ALIGN_DOWN, i18nManager.getTranslation(SHORT_ALIGN_DOWN)).add(i18nManager.getTranslation(ALIGN_LEFT), (Object)ALIGN_LEFT, i18nManager.getTranslation(SHORT_ALIGN_LEFT)).add(i18nManager.getTranslation(ALIGN_RIGHT), (Object)ALIGN_RIGHT, i18nManager.getTranslation(SHORT_ALIGN_RIGHT)).add(i18nManager.getTranslation(ALIGN_HORIZONTAL_CENTER), (Object)ALIGN_HORIZONTAL_CENTER, i18nManager.getTranslation(SHORT_ALIGN_HORIZONTAL_CENTER)).add(i18nManager.getTranslation(ALIGN_VERTICAL_CENTER), (Object)ALIGN_VERTICAL_CENTER, i18nManager.getTranslation(SHORT_ALIGN_VERTICAL_CENTER)).add(i18nManager.getTranslation(ALIGN_BOTH_CENTER), (Object)ALIGN_BOTH_CENTER, i18nManager.getTranslation(SHORT_ALIGN_BOTH_CENTER));
        String alignModeConsoleMsg = ((EditingProviderServices)providerServices).makeConsoleMessage(i18nManager.getTranslation(ALIGN_MODE), (EditingServiceParameterOptions)alignModeOptions);
        this.alignModeParameter = new DefaultEditingServiceParameter(ALIGN_MODE, alignModeConsoleMsg, (EditingServiceParameterOptions)alignModeOptions, (Object)i18nManager.getTranslation(SHORT_ALIGN_BOTH_CENTER), true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION});
        DefaultEditingServiceParameterOptions doCopyOptions = new DefaultEditingServiceParameterOptions().add(DO_COPY, (Object)true, i18nManager.getTranslation(SHORT_YES)).add(DELETE_ORIGINAL_GEOMETRIES, (Object)false, i18nManager.getTranslation(SHORT_NO));
        String consoleMsg = ((EditingProviderServices)providerServices).makeConsoleMessage(DO_COPY_QUESTION, (EditingServiceParameterOptions)doCopyOptions);
        this.doCopyParameter = new DefaultEditingServiceParameter(DO_COPY, consoleMsg, (EditingServiceParameterOptions)doCopyOptions, (Object)i18nManager.getTranslation(SHORT_YES), true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(1);
        this.values = new HashMap<EditingServiceParameter, Object>();
    }

    public String getName() {
        return "modify-align-edges";
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.geometryBaseParameter) == null) {
            return this.geometryBaseParameter;
        }
        if (this.values.get(this.alignModeParameter) == null) {
            return this.alignModeParameter;
        }
        if (this.values.get(this.doCopyParameter) == null) {
            return this.doCopyParameter;
        }
        if (this.values.get(this.featureToAlignParameter) == null) {
            return this.featureToAlignParameter;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus geometries = new DefaultDrawingStatus();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        EditingProviderServices editingProviderServices = this.getProviderServices();
        try {
            int subtype = editingProviderServices.getSubType(this.featureStore);
            if (this.values != null) {
                Geometry geometryBaseValue = (Geometry)this.values.get(this.geometryBaseParameter);
                String alignModeValue = (String)this.values.get(this.alignModeParameter);
                Boolean doCopyValue = (Boolean)this.values.get(this.doCopyParameter);
                if (geometryBaseValue != null) {
                    Feature feature;
                    if (geometryBaseValue.getGeometryType().isTypeOf(1) || geometryBaseValue.getGeometryType().isTypeOf(7)) {
                        geometries.addStatus(geometryBaseValue, auxiliaryPointSymbolEditing, "");
                    } else if (geometryBaseValue.getGeometryType().isTypeOf(2) || geometryBaseValue.getGeometryType().isTypeOf(8)) {
                        geometries.addStatus(geometryBaseValue, auxiliaryLineSymbolEditing, "");
                    } else {
                        geometries.addStatus(geometryBaseValue, polygonSymbolEditing, "");
                    }
                    if (alignModeValue != null && doCopyValue != null && (feature = this.getFeatureToAlign(mousePosition)) != null) {
                        ISymbol previewSymbol = this.getPreviewSymbol(feature);
                        Geometry geom = feature.getDefaultGeometry();
                        if (geom != null) {
                            if (geom.getGeometryType().isTypeOf(1) || geom.getGeometryType().isTypeOf(7)) {
                                geometries.addStatus(geom, auxiliaryPointSymbolEditing, "");
                            } else if (geom.getGeometryType().isTypeOf(2) || geom.getGeometryType().isTypeOf(8)) {
                                geometries.addStatus(geom, auxiliaryLineSymbolEditing, "");
                            } else if (geom.getGeometryType().isTypeOf(3) || geom.getGeometryType().isTypeOf(9)) {
                                geometries.addStatus(geom, polygonSymbolEditing, "");
                            }
                            geometries.addStatus(geom, previewSymbol, "");
                            Geometry alignedGeom = this.align(geometryBaseValue, geom, alignModeValue);
                            if (alignedGeom != null) {
                                Point basePoint = this.getAlignPoint(geometryBaseValue, alignModeValue);
                                Point geomPoint = this.getAlignPoint(alignedGeom, alignModeValue);
                                Line alignLine = GeometryUtils.createLine((Point)basePoint, (Point)geomPoint, (int)subtype);
                                geometries.addStatus((Geometry)alignLine, auxiliaryLineSymbolEditing, "");
                                if (alignedGeom.getGeometryType().isTypeOf(1) || alignedGeom.getGeometryType().isTypeOf(7)) {
                                    geometries.addStatus(alignedGeom, auxiliaryPointSymbolEditing, "");
                                } else if (alignedGeom.getGeometryType().isTypeOf(2) || alignedGeom.getGeometryType().isTypeOf(8)) {
                                    geometries.addStatus(alignedGeom, lineSymbolEditing, "");
                                } else if (alignedGeom.getGeometryType().isTypeOf(3) || alignedGeom.getGeometryType().isTypeOf(9)) {
                                    geometries.addStatus(alignedGeom, polygonSymbolEditing, "");
                                }
                                geometries.addStatus(alignedGeom, previewSymbol, "");
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new DrawServiceException((Throwable)e);
        }
        return geometries;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.geometryBaseParameter);
        parameters.add(this.alignModeParameter);
        parameters.add(this.doCopyParameter);
        parameters.add(this.featureToAlignParameter);
        return parameters;
    }

    public boolean isEnabled(EditingServiceParameter parameter) {
        return true;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        if (param == this.geometryBaseParameter) {
            Point point;
            Geometry geom;
            if (value instanceof Point && (geom = this.getGeometryOfVisibleLayers(point = (Point)value)) != null) {
                this.values.put(param, geom);
                return;
            }
        } else if (param == this.featureToAlignParameter) {
            Point point;
            Feature feat;
            if (value instanceof Point && (feat = this.getFeatureToAlign(point = (Point)value)) != null) {
                this.values.put(param, feat);
                return;
            }
        } else {
            if (param == this.alignModeParameter) {
                savedAlignMode = (String)param.getOptions2().getValue(value, param.getDefaultValue());
                this.values.put(param, savedAlignMode);
                return;
            }
            if (param == this.doCopyParameter) {
                savedDoCopy = (Boolean)param.getOptions2().getValue(value, param.getDefaultValue());
                this.values.put(param, savedDoCopy);
                return;
            }
        }
        throw new InvalidEntryException(null);
    }

    private Geometry getGeometryOfVisibleLayers(Point point) {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Geometry geometry = editingProviderServices.getGeometryOfVisibleLayers(point, this.featureStore, this.mapContext);
        return geometry;
    }

    private Feature getFeatureToAlign(Point point) {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Feature feature = editingProviderServices.getFeature(point, this.featureStore, this.mapContext);
        return feature;
    }

    private Geometry getGeometryToAlign(Point point) {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        return editingProviderServices.getGeometry(point, this.featureStore, this.mapContext);
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        Geometry geometryBaseValue = (Geometry)this.values.get(this.geometryBaseParameter);
        Feature featureValue = (Feature)this.values.get(this.featureToAlignParameter);
        String alignModeValue = (String)this.values.get(this.alignModeParameter);
        Boolean doCopy = (Boolean)this.values.get(this.doCopyParameter);
        EditingProviderServices editingProviderServices = this.getProviderServices();
        try {
            Geometry geom = this.align(geometryBaseValue, featureValue.getDefaultGeometry(), alignModeValue);
            if (doCopy.booleanValue()) {
                EditableFeature editableFeature = editingProviderServices.getFeatureCopyWithoutUniqueIndex(this.featureStore, featureValue);
                editableFeature.setDefaultGeometry(geom);
                editingProviderServices.insertFeatureIntoFeatureStore((Feature)editableFeature, this.featureStore);
            } else {
                EditableFeature editableFeature = featureValue.getEditable();
                editableFeature.setDefaultGeometry(geom);
                this.getProviderServices().updateFeatureInFeatureStore((Feature)editableFeature, this.featureStore);
            }
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    private Geometry align(Geometry geometryBase, Geometry geometry, String alignMode) {
        if (geometryBase != null && geometry != null) {
            geometry = geometry.cloneGeometry();
            AffineTransform at = this.getAffineTransform(geometryBase, geometry, alignMode);
            geometry.transform(at);
        }
        return geometry;
    }

    private Point getAlignPoint(Geometry geometry, String alignMode) {
        Point point = null;
        if (geometry != null) {
            if (geometry instanceof Point) {
                point = (Point)geometry;
            } else {
                Envelope env = geometry.getEnvelope();
                switch (alignMode) {
                    case "_up": {
                        point = GeometryUtils.createPoint((double)env.getCenter(0), (double)env.getMaximum(1));
                        break;
                    }
                    case "_down": {
                        point = GeometryUtils.createPoint((double)env.getCenter(0), (double)env.getMinimum(1));
                        break;
                    }
                    case "_left": {
                        point = GeometryUtils.createPoint((double)env.getMinimum(0), (double)env.getCenter(1));
                        break;
                    }
                    case "_right": {
                        point = GeometryUtils.createPoint((double)env.getMaximum(0), (double)env.getCenter(1));
                        break;
                    }
                    case "_horizontal_centering": {
                        point = GeometryUtils.createPoint((double)env.getCenter(0), (double)env.getCenter(1));
                        break;
                    }
                    case "_vertical_centering": {
                        point = GeometryUtils.createPoint((double)env.getCenter(0), (double)env.getCenter(1));
                        break;
                    }
                    case "_both_centering": {
                        point = GeometryUtils.createPoint((double)env.getCenter(0), (double)env.getCenter(1));
                    }
                }
            }
        }
        return point;
    }

    private AffineTransform getAffineTransform(Geometry geometryBase, Geometry geometry, String alignMode) {
        Point basePoint = this.getAlignPoint(geometryBase, alignMode);
        Point geomPoint = this.getAlignPoint(geometry, alignMode);
        AffineTransform at = null;
        switch (alignMode) {
            case "_up": {
                at = new AffineTransform(1.0, 0.0, 0.0, 1.0, 0.0, basePoint.getY() - geomPoint.getY());
                break;
            }
            case "_down": {
                at = new AffineTransform(1.0, 0.0, 0.0, 1.0, 0.0, basePoint.getY() - geomPoint.getY());
                break;
            }
            case "_left": {
                at = new AffineTransform(1.0, 0.0, 0.0, 1.0, basePoint.getX() - geomPoint.getX(), 0.0);
                break;
            }
            case "_right": {
                at = new AffineTransform(1.0, 0.0, 0.0, 1.0, basePoint.getX() - geomPoint.getX(), 0.0);
                break;
            }
            case "_horizontal_centering": {
                at = new AffineTransform(1.0, 0.0, 0.0, 1.0, 0.0, basePoint.getY() - geomPoint.getY());
                break;
            }
            case "_vertical_centering": {
                at = new AffineTransform(1.0, 0.0, 0.0, 1.0, basePoint.getX() - geomPoint.getX(), 0.0);
                break;
            }
            case "_both_centering": {
                at = new AffineTransform(1.0, 0.0, 0.0, 1.0, basePoint.getX() - geomPoint.getX(), basePoint.getY() - geomPoint.getY());
            }
        }
        return at;
    }

    public void activate() {
        this.values.clear();
        if (savedAlignMode != null) {
            this.values.put(this.alignModeParameter, savedAlignMode);
        }
        if (savedDoCopy != null) {
            this.values.put(this.doCopyParameter, savedDoCopy);
        }
    }

    public void start() throws StartServiceException {
    }

    public void stop() throws StopServiceException {
        this.values.remove(this.featureToAlignParameter);
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }

    private Feature getCurrentFeature() {
        return (Feature)this.getValue(this.featureToAlignParameter);
    }
}

