/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.raster.principalcomponents;

import es.unex.sextante.core.AnalysisExtent;
import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IRasterLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import java.util.HashMap;
import java.util.List;
import org.gvsig.fmap.dal.coverage.RasterLocator;
import org.gvsig.fmap.dal.coverage.datastruct.Extent;
import org.gvsig.fmap.dal.coverage.exception.ProcessInterruptedException;
import org.gvsig.fmap.dal.coverage.store.RasterDataStore;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FLyrRasterIRasterLayer;
import org.gvsig.raster.algorithm.RasterBaseAlgorithmLibrary;
import org.gvsig.raster.algorithm.process.DataProcess;
import org.gvsig.raster.algorithm.process.IProcessActions;
import org.gvsig.raster.algorithm.process.ProcessException;
import org.gvsig.raster.fmap.layers.FLyrRaster;
import org.gvsig.raster.principalcomponents.algorithm.PCStatsDataStructure;
import org.gvsig.raster.principalcomponents.algorithm.PrincipalComponentsProcess;

public class PrincipalComponentsSextanteAlgorithm
extends AbstractSextanteGeoProcess
implements IProcessActions {
    public static final String RESULT = "RESULT";
    public static final String LAYER = PrincipalComponentsProcess.RASTER_STORE;
    public static final String USE_ROI = "USE_ROI";
    private boolean useROI = false;
    private DataProcess taskStats = null;
    private DataProcess taskPC = null;

    public void defineCharacteristics() {
        this.setName(this.getTranslation("principalcomponents"));
        this.setGroup(this.getTranslation("multispectral"));
        try {
            this.m_Parameters.addInputRasterLayer(LAYER, this.getTranslation("Input_layer"), true);
            this.m_Parameters.addBoolean(USE_ROI, this.getTranslation("use_roi"), false);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        this.addOutputRasterLayer(RESULT, this.getTranslation("principalcomponents"));
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        IRasterLayer input = this.m_Parameters.getParameterValueAsRasterLayer(LAYER);
        this.useROI = this.m_Parameters.getParameterValueAsBoolean(USE_ROI);
        FLyrRaster lyrRaster = (FLyrRaster)input.getBaseDataObject();
        IRasterLayer output = null;
        output = this.getNewRORasterLayer(RESULT, Sextante.getText((String)"principalcomponents_description"), input.getDataType(), input.getBandsCount());
        String fileName = ((FLyrRasterIRasterLayer)output).getName();
        try {
            this.setProgressText(this.getTranslation("stadistics"));
            this.taskStats = this.createStatisticsProcess(lyrRaster.getDataStore());
            this.taskStats.execute();
            HashMap params = this.taskStats.getResult();
            PCStatsDataStructure stats = (PCStatsDataStructure)params.get("STATS_RESULT");
            this.setProgressText(this.getTranslation("calc_components"));
            this.taskPC = this.createPCAProcess(lyrRaster.getDataStore(), fileName, stats);
            this.taskPC.execute();
            params = this.taskPC.getResult();
            ((FLyrRasterIRasterLayer)output).setBaseDataObject(fileName);
        }
        catch (ProcessInterruptedException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (ProcessException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return !this.getTaskMonitor().isCanceled();
    }

    private DataProcess createStatisticsProcess(RasterDataStore inputStore) throws ProcessException {
        DataProcess taskStats = RasterBaseAlgorithmLibrary.getManager().createRasterTask("StatsPrincipalComponentsProcess");
        taskStats.setActions((IProcessActions)this);
        List params = taskStats.getRasterTaskInputParameters("StatsPrincipalComponentsProcess");
        for (int i = 0; i < params.size(); ++i) {
            String paramName = (String)params.get(i);
            Class paramType = taskStats.getParameterTypeByProcess("StatsPrincipalComponentsProcess", paramName);
            if (paramType == RasterDataStore.class) {
                taskStats.addParam(paramName, (Object)inputStore);
            }
            if (paramName.equals("BANDS")) {
                boolean[] bands = new boolean[inputStore.getBandCount()];
                for (int j = 0; j < bands.length; ++j) {
                    bands[j] = true;
                }
                taskStats.addParam(paramName, (Object)bands);
            }
            if (paramName.equals("ROI_EPSG") && this.useROI) {
                taskStats.addParam(paramName, (Object)"EPSG:4326");
            }
            if (!paramName.equals("WINDOW")) continue;
            AnalysisExtent ext = this.getAnalysisExtent();
            Extent bbox = RasterLocator.getManager().getDataStructFactory().createExtent(ext.getXMin(), ext.getYMax(), ext.getXMax(), ext.getYMin());
            Extent inputBbox = inputStore.getExtent();
            if (bbox.getULX() == inputBbox.getULX() && bbox.getULY() == inputBbox.getULY() && bbox.getLRX() == inputBbox.getLRX() && bbox.getLRY() == inputBbox.getLRY()) continue;
            taskStats.addParam(paramName, (Object)bbox);
        }
        return taskStats;
    }

    private DataProcess createPCAProcess(RasterDataStore inputStore, String fileName, PCStatsDataStructure stats) throws ProcessException {
        DataProcess taskPC = RasterBaseAlgorithmLibrary.getManager().createRasterTask("PrincipalComponentsProcess");
        taskPC.setActions((IProcessActions)this);
        List params = taskPC.getRasterTaskInputParameters("PrincipalComponentsProcess");
        for (int i = 0; i < params.size(); ++i) {
            String paramName = (String)params.get(i);
            Class paramType = taskPC.getParameterTypeByProcess("PrincipalComponentsProcess", paramName);
            if (paramType == RasterDataStore.class) {
                taskPC.addParam(paramName, (Object)inputStore);
            }
            if (paramType == Boolean[].class) {
                boolean[] bands = new boolean[inputStore.getBandCount()];
                for (int j = 0; j < bands.length; ++j) {
                    bands[j] = true;
                }
                taskPC.addParam(paramName, (Object)bands);
            }
            if (paramType == PCStatsDataStructure.class) {
                taskPC.addParam(paramName, (Object)stats);
            }
            if (paramName.equals("PATH")) {
                taskPC.addParam(paramName, (Object)fileName);
            }
            if (paramName.equals("ROI_EPSG") && this.useROI) {
                taskPC.addParam(paramName, (Object)"EPSG:4326");
            }
            if (!paramName.equals("WINDOW")) continue;
            AnalysisExtent ext = this.getAnalysisExtent();
            Extent bbox = RasterLocator.getManager().getDataStructFactory().createExtent(ext.getXMin(), ext.getYMax(), ext.getXMax(), ext.getYMin());
            Extent inputBbox = inputStore.getExtent();
            if (bbox.getULX() == inputBbox.getULX() && bbox.getULY() == inputBbox.getULY() && bbox.getLRX() == inputBbox.getLRX() && bbox.getLRY() == inputBbox.getLRY()) continue;
            taskPC.addParam(paramName, (Object)bbox);
        }
        return taskPC;
    }

    public void interrupted() {
    }

    public void end(Object param) {
    }

    public void updateProgress(int current, int total) {
        boolean cancelled = this.setProgress(current, total);
        if (!cancelled) {
            if (this.taskStats != null) {
                this.taskStats.actionCanceled(null);
            }
            if (this.taskPC != null) {
                this.taskPC.actionCanceled(null);
            }
        }
    }
}

