/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.chamfer;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.gvsig.euclidean.EuclideanLine2D;
import org.gvsig.euclidean.EuclideanManager;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiLine;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.ISimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.EditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.prov.chamfer.SegmentData;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameterOptions;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChamferByLengthAndAngleEditingProvider
extends AbstractEditingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChamferByLengthAndAngleEditingProvider.class);
    private static final int ERR_OK = 0;
    private static final int ERR_CHAMFER_TOO_LARGE = 1;
    private static final int ERR_SEGMENT_DATA_NOT_FILLED = 2;
    private static final int ERR_FIRST_SEGMENT_DATA_NULL = 3;
    private static final int ERR_SAME_SEGMENT = 4;
    private static final int ERR_CANT_CALCULATE_CHAMFER_POINT = 5;
    private static final int ERR_NON_ADJACENT_SEGMENTS = 6;
    private static final int ERR_DIFFERENT_GEOMETRY_TYPES = 7;
    private static final int ERR_CANT_CONNECT_SEGMENTS = 8;
    private static final int ERR_ONE_OF_THE_TWO_SEGMENTS_ISNT_EXTREME = 9;
    private static final int ERR_INVALID_VALUE = 10;
    private static final int ERR_INVALID_GEOMETRY_TYPE = 11;
    private static final int ERR_CANT_FIND_NEAREST_GEOMETRY = 12;
    private static final int ERR_CANT_CALCULATE_CHAMFER = 13;
    private static String[] stateMessages = new String[]{"_Valid", "_Chamfer_too_large", "_Cant_fill_segment_data", "_First_segment_data_is_null", "_Same_segment", "_Cant_calculate_chamfer_point", "_Non-adjacent_segments", "_Different_geometry_types", "_Cant_connect_segments", "_One_of_the_two_segments_isnt_extreme", "_Invalid_value", "_Invalid_geometry_type", "_Cant_find_nearest_geometry", "_Cant_calculate_chamfer"};
    private static final int INSIDE_THE_SEGMENT = 0;
    private static final int BEYOND_THE_SEGMENT = 1;
    private static final int INVALID_ZONE = -1;
    private static final String CHAMFER_LENGTH = "_Length";
    private static final String DELETE_SECOND_SELECTED_GEOMETRY_QUESTION = "_Delete_second_selected_geometry_question";
    private static final String DELETE_SECOND_SELECTED_GEOMETRY = "_Delete_second_selected_geometry";
    private static final String YES = "_yes";
    private static final String NO = "_no";
    private static final String SHORT_YES = "_short_yes";
    private static final String SHORT_NO = "_short_no";
    private static Boolean deleteSecondFeatureDefaultValue;
    private final EditingServiceParameter lengthParameter;
    private final EditingServiceParameter firstSegmentParameter;
    private final EditingServiceParameter secondSegmentParameter;
    private final EditingServiceParameter angleParameter;
    private final EditingServiceParameter deleteSecondSelectedGeometryParameter;
    private final Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;
    private final MapContext mapContext;
    private SegmentData firstSegmentData;
    private SegmentData secondSegmentData;
    private Point pointToChamfer;
    private static Double savedDistance;
    private ISymbol previewSymbol;

    public ChamferByLengthAndAngleEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.mapContext = (MapContext)parameters.getDynValue("mapContext");
        this.firstSegmentParameter = new DefaultEditingServiceParameter("_First_segment", "_First_segment", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.secondSegmentParameter = new DefaultEditingServiceParameter("_Second_segment", "_Second_segment", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.lengthParameter = new DefaultEditingServiceParameter(CHAMFER_LENGTH, CHAMFER_LENGTH, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE, EditingServiceParameter.TYPE.DISTANCE});
        this.angleParameter = new DefaultEditingServiceParameter("_Angle", "_Angle", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.VALUE});
        DefaultEditingServiceParameterOptions deleteSecondSelectedGeometryParameterOptions = new DefaultEditingServiceParameterOptions().add(YES, (Object)true, i18nManager.getTranslation(SHORT_YES)).add(NO, (Object)false, i18nManager.getTranslation(SHORT_NO));
        String consoleMsg = ((EditingProviderServices)providerServices).makeConsoleMessage(DELETE_SECOND_SELECTED_GEOMETRY_QUESTION, (EditingServiceParameterOptions)deleteSecondSelectedGeometryParameterOptions);
        this.deleteSecondSelectedGeometryParameter = new DefaultEditingServiceParameter(DELETE_SECOND_SELECTED_GEOMETRY, consoleMsg, (EditingServiceParameterOptions)deleteSecondSelectedGeometryParameterOptions, null, false, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.OPTION}).setDataType(1);
        this.values = new HashMap<EditingServiceParameter, Object>();
        this.firstSegmentData = null;
        this.secondSegmentData = null;
    }

    public String getName() {
        return "modify-chamfer-by-length-and-angle";
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.lengthParameter) == null) {
            return this.lengthParameter;
        }
        if (this.values.get(this.firstSegmentParameter) == null) {
            return this.firstSegmentParameter;
        }
        if (this.values.get(this.secondSegmentParameter) == null) {
            return this.secondSegmentParameter;
        }
        if (this.values.get(this.angleParameter) == null) {
            return this.angleParameter;
        }
        if (this.values.get(this.deleteSecondSelectedGeometryParameter) == null && !Objects.equals(this.firstSegmentData.getFeature().getReference(), this.secondSegmentData.getFeature().getReference())) {
            return this.deleteSecondSelectedGeometryParameter;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus geometries;
        block14: {
            geometries = new DefaultDrawingStatus();
            GeometryManager geometryManager = GeometryLocator.getGeometryManager();
            EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
            ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
            ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
            ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
            ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
            ISymbol ruleAxisSymbol = editingProviderManager.getSymbol("rule-axis-symbol");
            auxiliaryPointSymbolEditing.setColor(Color.RED);
            ISimpleTextSymbol textSymbol = this.getTextSymbol();
            EditingProviderServices editingProviderServices = this.getProviderServices();
            Object previewSymbol = null;
            try {
                int subtype = editingProviderServices.getSubType(this.featureStore);
                if (this.values == null) break block14;
                if (this.values.get(this.lengthParameter) == null) {
                    return geometries;
                }
                if (this.firstSegmentData == null) {
                    Feature firstFeature = this.getFeatureNearestPoint(mousePosition);
                    if (firstFeature == null) {
                        return geometries;
                    }
                    Geometry firstGeometry = firstFeature.getDefaultGeometry();
                    if (firstGeometry == null || !this.validateGeometryType(firstGeometry)) {
                        return geometries;
                    }
                    SegmentData segmentData = new SegmentData(firstFeature, mousePosition);
                    geometries.addStatus((Geometry)segmentData.getProjectedPoint(), auxiliaryPointSymbolEditing, "");
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)mousePosition, (Point)segmentData.getProjectedPoint(), (int)subtype), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)segmentData.getLine(), auxiliaryLineSymbolEditing, "");
                    return geometries;
                }
                if (this.secondSegmentData == null) {
                    geometries.addStatus((Geometry)this.firstSegmentData.getLine(), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)this.firstSegmentData.getProjectedPoint(), auxiliaryPointSymbolEditing, "");
                    Feature secondFeature = this.getFeatureNearestPoint(mousePosition);
                    if (secondFeature == null) {
                        return geometries;
                    }
                    Geometry secondGeometry = secondFeature.getDefaultGeometry();
                    if (secondGeometry == null || !this.validateGeometryType(secondGeometry)) {
                        return geometries;
                    }
                    SegmentData segmentData = new SegmentData(secondFeature, mousePosition);
                    Pair<Point, Point> oppositePoints = this.calculateOpositeToChamferVertices(this.firstSegmentData, segmentData);
                    if (this.validateAsSecondSegmentData(segmentData, (Point)oppositePoints.getRight()) == 0) {
                        geometries.addStatus((Geometry)segmentData.getProjectedPoint(), auxiliaryPointSymbolEditing, "");
                        geometries.addStatus((Geometry)GeometryUtils.createLine((Point)mousePosition, (Point)segmentData.getProjectedPoint(), (int)subtype), auxiliaryLineSymbolEditing, "");
                        geometries.addStatus((Geometry)segmentData.getLine(), auxiliaryLineSymbolEditing, "");
                        Point tmpPointToChamfer = this.calculatePointToChamfer(this.firstSegmentData, segmentData);
                        geometries.addStatus((Geometry)tmpPointToChamfer, auxiliaryPointSymbolEditing, "");
                        break block14;
                    }
                    return geometries;
                }
                if (this.values.get(this.angleParameter) == null) {
                    Point tmpPointToFillet = this.calculatePointToChamfer(this.firstSegmentData, this.secondSegmentData);
                    Pair<Point, Point> oppositePoints = this.calculateOpositeToChamferVertices(this.firstSegmentData, this.secondSegmentData);
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)((Point)oppositePoints.getLeft()), (Point)tmpPointToFillet, (int)subtype), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)((Point)oppositePoints.getRight()), (Point)tmpPointToFillet, (int)subtype), auxiliaryLineSymbolEditing, "");
                    Double distance = (Double)this.getValue(this.lengthParameter);
                    double angle = GeometryUtils.calculateAngle((Point)this.pointToChamfer, (Point)mousePosition);
                    geometries.addStatus((Geometry)tmpPointToFillet, auxiliaryPointSymbolEditing, "");
                    ScaffoldingToChamfer scaffolding = this.calculateScaffolding(this.firstSegmentData, this.secondSegmentData, tmpPointToFillet, distance, angle, subtype);
                    if (scaffolding == null) {
                        return geometries;
                    }
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)tmpPointToFillet, (Point)scaffolding.getP1(), (int)subtype), auxiliaryLineSymbolEditing, "");
                    if (scaffolding.isReversed()) {
                        geometries.addStatus((Geometry)GeometryUtils.createLine((Point)scaffolding.getP1(), (Point)GeometryUtils.createPoint((double)scaffolding.getChamferRight().getX(), (double)scaffolding.getChamferRight().getY()), (int)subtype), auxiliaryLineSymbolEditing, "");
                    } else {
                        geometries.addStatus((Geometry)GeometryUtils.createLine((Point)scaffolding.getP1(), (Point)GeometryUtils.createPoint((double)scaffolding.getChamferRight().getX(), (double)scaffolding.getChamferRight().getY()), (int)subtype), auxiliaryLineSymbolEditing, "");
                    }
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)GeometryUtils.createPoint((double)scaffolding.getChamferRight().getX(), (double)scaffolding.getChamferRight().getY()), (Point)GeometryUtils.createPoint((double)scaffolding.getChamferLeft().getX(), (double)scaffolding.getChamferLeft().getY()), (int)subtype), auxiliaryLineSymbolEditing, "");
                    Line ruleAxisBaseLine = geometryManager.createLine(subtype);
                    ruleAxisBaseLine.addVertex(tmpPointToFillet);
                    Point p2 = geometryManager.createPoint(tmpPointToFillet.getX() + tmpPointToFillet.distance((Geometry)mousePosition), tmpPointToFillet.getY(), subtype);
                    ruleAxisBaseLine.addVertex(p2);
                    geometries.addStatus((Geometry)ruleAxisBaseLine, ruleAxisSymbol, "");
                    Line angleLine = geometryManager.createLine(subtype);
                    angleLine.addVertex(tmpPointToFillet);
                    angleLine.addVertex(mousePosition);
                    geometries.addStatus((Geometry)angleLine, ruleAxisSymbol, "");
                    Double ext = Math.PI * 2 - angle;
                    Arc arc = GeometryUtils.createArc((Point)tmpPointToFillet, (double)(tmpPointToFillet.distance((Geometry)mousePosition) / 2.0), (double)0.0, (double)angle, (int)0);
                    geometries.addStatus((Geometry)arc, auxiliaryLineSymbolEditing, "");
                    double textDistance = 3.0 * tmpPointToFillet.distance((Geometry)mousePosition) / 4.0;
                    Point pointText = geometryManager.createPoint(tmpPointToFillet.getX() + textDistance * Math.cos(angle / 2.0), tmpPointToFillet.getY() + textDistance * Math.sin(angle / 2.0), subtype);
                    geometries.addStatus((Geometry)pointText, (ISymbol)textSymbol, GeometryUtils.formatAngle((String)"%5.3D\u00b0", (double)Math.toDegrees(angle)));
                    this.drawResult(geometries, this.firstSegmentData, this.secondSegmentData, distance, angle, subtype);
                    return geometries;
                }
                this.drawResult(geometries, this.firstSegmentData, this.secondSegmentData, (Double)this.getValue(this.lengthParameter), Math.toRadians((Double)this.getValue(this.angleParameter)), subtype);
                return geometries;
            }
            catch (Exception e) {
                throw new DrawServiceException((Throwable)e);
            }
        }
        return geometries;
    }

    private void drawResult(DefaultDrawingStatus geometries, SegmentData firstSegmentData, SegmentData secondSegmentData, Double length, Double angle, int subtype) throws CreateGeometryException, GeometryOperationNotSupportedException, IllegalStateException, GeometryException, GeometryOperationException {
        if (this.previewSymbol == null) {
            return;
        }
        Line chamfer = this.calculateChamfer(firstSegmentData, secondSegmentData, length, angle, subtype);
        if (chamfer == null) {
            return;
        }
        if (Objects.equals(firstSegmentData.getPrimitive(), secondSegmentData.getPrimitive())) {
            geometries.addStatus((Geometry)this.chamferPrimitive(firstSegmentData.getPrimitive(), chamfer), this.previewSymbol, null);
        } else {
            geometries.addStatus((Geometry)this.chamferPrimitives(firstSegmentData.getPrimitive(), secondSegmentData.getPrimitive(), chamfer), this.previewSymbol, null);
        }
    }

    private ISimpleTextSymbol getTextSymbol() {
        SymbologyManager symbologyManager = SymbologyLocator.getSymbologyManager();
        ISimpleTextSymbol textSymbol = symbologyManager.createSimpleTextSymbol();
        textSymbol.setFontSize(10.0);
        return textSymbol;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.lengthParameter);
        parameters.add(this.firstSegmentParameter);
        parameters.add(this.secondSegmentParameter);
        parameters.add(this.angleParameter);
        parameters.add(this.deleteSecondSelectedGeometryParameter);
        return parameters;
    }

    public boolean isEnabled(EditingServiceParameter parameter) {
        return true;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        block28: {
            try {
                EditingProviderServices editingProviderServices = this.getProviderServices();
                int subtype = editingProviderServices.getSubType(this.featureStore);
                I18nManager i18n = ToolsLocator.getI18nManager();
                if (param == this.lengthParameter) {
                    Double distance = null;
                    if (value instanceof Double) {
                        distance = (Double)value;
                    } else if (value == null && (distance = (Double)this.lengthParameter.getDefaultValue()) == null) {
                        throw new InvalidEntryException(this.getName(), 10, i18n.getTranslation(stateMessages[10]));
                    }
                    this.values.put(param, distance);
                    savedDistance = distance;
                    break block28;
                }
                if (param == this.firstSegmentParameter) {
                    if (value instanceof Point) {
                        Point point = (Point)value;
                        Feature firstFeature = this.getFeatureNearestPoint(point);
                        if (firstFeature == null) {
                            throw new InvalidEntryException((Throwable)new IllegalArgumentException("Can't find nearest feature."));
                        }
                        Geometry firstGeometry = firstFeature.getDefaultGeometry();
                        if (!this.validateGeometryType(firstGeometry)) {
                            throw new InvalidEntryException(this.getName(), 11, i18n.getTranslation(stateMessages[11]));
                        }
                        this.firstSegmentData = new SegmentData(firstFeature, point);
                        if (!this.firstSegmentData.isFilled()) {
                            this.firstSegmentData = null;
                            throw new InvalidEntryException(this.getName(), 12, i18n.getTranslation(stateMessages[12]));
                        }
                        if (this.firstSegmentData == null) {
                            throw new InvalidEntryException(this.getName(), 12, i18n.getTranslation(stateMessages[12]));
                        }
                        this.values.put(param, value);
                        this.previewSymbol = this.getPreviewSymbol(this.firstSegmentData.getFeature());
                    }
                    break block28;
                }
                if (param == this.secondSegmentParameter) {
                    if (!(value instanceof Point)) break block28;
                    Point point = (Point)value;
                    Feature secondFeature = this.getFeatureNearestPoint(point);
                    if (secondFeature == null) {
                        throw new InvalidEntryException(this.getName(), 12, i18n.getTranslation(stateMessages[12]));
                    }
                    SegmentData segmentData = new SegmentData(secondFeature, point);
                    Pair<Point, Point> oppositeVertices = this.calculateOpositeToChamferVertices(this.firstSegmentData, segmentData);
                    int errno = this.validateAsSecondSegmentData(segmentData, (Point)oppositeVertices.getRight());
                    if (errno != 0) {
                        this.secondSegmentData = null;
                        this.pointToChamfer = null;
                        throw new InvalidEntryException(this.getName(), errno, i18n.getTranslation(stateMessages[errno]));
                    }
                    try {
                        this.secondSegmentData = segmentData;
                        this.pointToChamfer = this.calculatePointToChamfer(this.firstSegmentData, this.secondSegmentData);
                        this.angleParameter.setDefaultValue((Object)this.calculateDefaultAngle(this.pointToChamfer, oppositeVertices));
                        this.values.put(param, value);
                        break block28;
                    }
                    catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
                        throw new InvalidEntryException(this.getName(), 5, i18n.getTranslation(stateMessages[12]));
                    }
                }
                if (param == this.angleParameter) {
                    Double angle = null;
                    if (value instanceof Double) {
                        angle = Math.toRadians((Double)value);
                    } else if (value instanceof Point) {
                        Point point = (Point)value;
                        angle = GeometryUtils.calculateAngle((Point)this.pointToChamfer, (Point)point);
                    } else if (value == null) {
                        angle = Math.toRadians((Double)param.getDefaultValue());
                    } else {
                        throw new InvalidEntryException(this.getName(), 10, i18n.getTranslation(stateMessages[10]));
                    }
                    Double distance = (Double)this.getValue(this.lengthParameter);
                    Line chamfer = this.calculateChamfer(this.firstSegmentData, this.secondSegmentData, distance, angle, subtype);
                    if (chamfer == null) {
                        throw new InvalidEntryException(this.getName(), 13, i18n.getTranslation(stateMessages[12]));
                    }
                    this.values.put(param, Math.toDegrees(angle));
                } else if (param == this.deleteSecondSelectedGeometryParameter) {
                    Boolean v = (Boolean)param.getOptions2().getValue(value, param.getDefaultValue());
                    this.values.put(param, v);
                    deleteSecondFeatureDefaultValue = v;
                }
            }
            catch (InvalidEntryException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new InvalidEntryException((Throwable)ex);
            }
        }
    }

    private boolean validateGeometryType(Geometry geometry) throws IllegalArgumentException {
        ArrayList<Integer> validGeometryTypes = new ArrayList<Integer>(Arrays.asList(18, 19, 21, 22));
        return validGeometryTypes.contains(geometry.getType());
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        Double distance = (Double)this.getValue(this.lengthParameter);
        Double angle = (Double)this.getValue(this.angleParameter);
        try {
            Geometry modifiedGeometry;
            EditingProviderServices editingProviderServices = this.getProviderServices();
            int subType = editingProviderServices.getSubType(this.featureStore);
            Line chamfer = this.calculateChamfer(this.firstSegmentData, this.secondSegmentData, (Double)this.getValue(this.lengthParameter), Math.toRadians((Double)this.getValue(this.angleParameter)), subType);
            if (chamfer == null) {
                throw new FinishServiceException("Can't calculate chamfer.", null);
            }
            Feature firstFeature = this.firstSegmentData.getFeature();
            Feature secondFeature = this.secondSegmentData.getFeature();
            Boolean doDeleteSecondSelectedGeometry = false;
            if (!Objects.equals(firstFeature.getReference(), secondFeature.getReference())) {
                doDeleteSecondSelectedGeometry = (Boolean)this.values.get(this.deleteSecondSelectedGeometryParameter);
            }
            EditableFeature editableFeature = firstFeature.getEditable();
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            Geometry firstGeometry = this.firstSegmentData.getGeometry();
            Primitive firstPrimitive = this.firstSegmentData.getPrimitive();
            Primitive secondPrimitive = this.secondSegmentData.getPrimitive();
            if (Objects.equals(firstFeature.getReference(), secondFeature.getReference())) {
                if (firstGeometry instanceof MultiPrimitive) {
                    modifiedGeometry = geomManager.create(firstGeometry.getGeometryType());
                    MultiPrimitive firstMultiPrimitive = (MultiPrimitive)firstGeometry;
                    if (Objects.equals(firstPrimitive, secondPrimitive)) {
                        for (Geometry geometry : firstMultiPrimitive) {
                            Primitive primitive = (Primitive)geometry;
                            if (Objects.equals(firstPrimitive, primitive)) {
                                Primitive modifiedPrimitive = this.chamferPrimitive(primitive, chamfer);
                                ((MultiPrimitive)modifiedGeometry).addPrimitive(modifiedPrimitive);
                                continue;
                            }
                            if (Objects.equals(secondPrimitive, primitive)) continue;
                            ((MultiPrimitive)modifiedGeometry).addPrimitive(primitive);
                        }
                    } else {
                        Primitive modifiedPrimitive = this.chamferPrimitives(firstPrimitive, secondPrimitive, chamfer);
                        for (Geometry geometry : firstMultiPrimitive) {
                            Primitive primitive = (Primitive)geometry;
                            if (Objects.equals(firstPrimitive, primitive)) {
                                ((MultiPrimitive)modifiedGeometry).addPrimitive(modifiedPrimitive);
                                continue;
                            }
                            if (Objects.equals(secondPrimitive, primitive)) continue;
                            ((MultiPrimitive)modifiedGeometry).addPrimitive(primitive);
                        }
                    }
                } else {
                    modifiedGeometry = this.chamferPrimitive((Primitive)editableFeature.getDefaultGeometry(), chamfer);
                }
            } else {
                doDeleteSecondSelectedGeometry = (Boolean)this.values.get(this.deleteSecondSelectedGeometryParameter);
                Primitive modifiedPrimitive = this.chamferPrimitives(firstPrimitive, secondPrimitive, chamfer);
                modifiedGeometry = geomManager.create(firstGeometry.getGeometryType());
                if (firstGeometry instanceof MultiPrimitive) {
                    MultiPrimitive firstMultiPrimitive = (MultiPrimitive)firstGeometry;
                    for (Geometry geometry : firstMultiPrimitive) {
                        Primitive primitive = (Primitive)geometry;
                        if (Objects.equals(firstPrimitive, primitive)) {
                            ((MultiPrimitive)modifiedGeometry).addPrimitive(modifiedPrimitive);
                            continue;
                        }
                        ((MultiPrimitive)modifiedGeometry).addPrimitive(primitive);
                    }
                } else {
                    modifiedGeometry = modifiedPrimitive;
                }
                if (doDeleteSecondSelectedGeometry.booleanValue()) {
                    secondFeature.getStore().delete(secondFeature);
                }
            }
            editableFeature.setDefaultGeometry(modifiedGeometry);
            this.getProviderServices().updateFeatureInFeatureStore((Feature)editableFeature, this.featureStore);
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    private Primitive chamferPrimitive(Primitive primitive, Line chamfer) throws IllegalStateException, GeometryException, GeometryOperationException, GeometryOperationNotSupportedException {
        Primitive modifiedPrimitive = (Primitive)primitive.cloneGeometry();
        if (primitive instanceof Line || primitive instanceof Polygon) {
            modifiedPrimitive = (Primitive)primitive.cloneGeometry();
        } else if (primitive instanceof Curve) {
            modifiedPrimitive = (Line)primitive.toLines().getPrimitiveAt(0);
        } else if (primitive instanceof Surface) {
            modifiedPrimitive = (Line)primitive.toPolygons().getPrimitiveAt(0);
        }
        if (Objects.equals(this.firstSegmentData.getIdxVertex(), this.secondSegmentData.getIdxVertex() - 1)) {
            if (modifiedPrimitive instanceof Line) {
                ((Line)modifiedPrimitive).removeVertex(this.firstSegmentData.getIdxVertex() + 1);
                int i = 1;
                for (Point point : chamfer) {
                    ((Line)modifiedPrimitive).insertVertex(this.firstSegmentData.getIdxVertex() + i++, point);
                }
            } else if (modifiedPrimitive instanceof Polygon) {
                ((Polygon)modifiedPrimitive).removeVertex(this.firstSegmentData.getIdxVertex() + 1);
                int i = 1;
                for (Point point : chamfer) {
                    ((Polygon)modifiedPrimitive).insertVertex(this.firstSegmentData.getIdxVertex() + i++, point);
                }
            }
        } else if (Objects.equals(this.firstSegmentData.getIdxVertex(), this.secondSegmentData.getIdxVertex() + 1)) {
            if (modifiedPrimitive instanceof Line) {
                ((Line)modifiedPrimitive).removeVertex(this.secondSegmentData.getIdxVertex() + 1);
                Line flipedChamfer = chamfer.cloneGeometry();
                flipedChamfer.flip();
                int i = 1;
                for (Point point : flipedChamfer) {
                    ((Line)modifiedPrimitive).insertVertex(this.secondSegmentData.getIdxVertex() + i++, point);
                }
            } else if (modifiedPrimitive instanceof Polygon) {
                ((Polygon)modifiedPrimitive).removeVertex(this.secondSegmentData.getIdxVertex() + 1);
                Line flipedChamfer = chamfer.cloneGeometry();
                flipedChamfer.flip();
                int i = 1;
                for (Point point : flipedChamfer) {
                    ((Polygon)modifiedPrimitive).insertVertex(this.secondSegmentData.getIdxVertex() + i++, point);
                }
            }
        } else if (Objects.equals(this.firstSegmentData.getPosition(), 2) && Objects.equals(this.secondSegmentData.getPosition(), 0)) {
            if (modifiedPrimitive instanceof Line) {
                ((Line)modifiedPrimitive).removeVertex(0);
                ((Line)modifiedPrimitive).removeVertex(((Line)modifiedPrimitive).getNumVertices() - 1);
                for (Point point : chamfer) {
                    ((Line)modifiedPrimitive).addVertex(point);
                }
            } else if (modifiedPrimitive instanceof Polygon) {
                ((Polygon)modifiedPrimitive).removeVertex(0);
                ((Polygon)modifiedPrimitive).removeVertex(((Polygon)modifiedPrimitive).getNumVertices() - 1);
                ((Polygon)modifiedPrimitive).insertVertex(0, chamfer.getVertex(chamfer.getNumVertices() - 1));
                for (Point point : chamfer) {
                    ((Polygon)modifiedPrimitive).addVertex(point);
                }
            }
        } else if (Objects.equals(this.firstSegmentData.getPosition(), 0) && Objects.equals(this.secondSegmentData.getPosition(), 2)) {
            Line flipedChamfer = chamfer.cloneGeometry();
            flipedChamfer.flip();
            if (modifiedPrimitive instanceof Line) {
                ((Line)modifiedPrimitive).removeVertex(0);
                ((Line)modifiedPrimitive).removeVertex(((Line)modifiedPrimitive).getNumVertices() - 1);
                boolean i = true;
                for (Point point : flipedChamfer) {
                    ((Line)modifiedPrimitive).addVertex(point);
                }
            } else if (modifiedPrimitive instanceof Polygon) {
                ((Polygon)modifiedPrimitive).removeVertex(0);
                ((Polygon)modifiedPrimitive).removeVertex(((Polygon)modifiedPrimitive).getNumVertices() - 1);
                ((Polygon)modifiedPrimitive).insertVertex(0, flipedChamfer.getVertex(flipedChamfer.getNumVertices() - 1));
                for (Point point : flipedChamfer) {
                    ((Polygon)modifiedPrimitive).addVertex(point);
                }
            }
        } else {
            throw new IllegalStateException("Invalid segments");
        }
        return modifiedPrimitive;
    }

    private Primitive chamferPrimitives(Primitive firstPrimitive, Primitive secondPrimitive, Line chamfer) throws IllegalStateException, GeometryException, GeometryOperationNotSupportedException, GeometryOperationException {
        Line secondLine;
        Line firstLine;
        if (firstPrimitive == null) {
            throw new IllegalArgumentException("firstPrimitive is null");
        }
        if (firstPrimitive instanceof Line) {
            firstLine = (Line)firstPrimitive.cloneGeometry();
        } else {
            MultiLine lines = firstPrimitive.toLines();
            if (lines == null) {
                throw new IllegalArgumentException("Can't find first primitive.");
            }
            firstLine = (Line)lines.getPrimitiveAt(0);
        }
        if (secondPrimitive == null) {
            throw new IllegalArgumentException("secondPrimitive is null");
        }
        if (secondPrimitive instanceof Line) {
            secondLine = (Line)secondPrimitive;
        } else {
            MultiLine lines = secondPrimitive.toLines();
            if (lines == null) {
                throw new IllegalArgumentException("Can't find second primitive.");
            }
            secondLine = (Line)lines.getPrimitiveAt(0);
        }
        Line modifiedPrimitive = firstLine;
        if (Objects.equals(this.firstSegmentData.getPosition(), 2)) {
            modifiedPrimitive.removeVertex(modifiedPrimitive.getNumVertices() - 1);
            for (Point point : chamfer) {
                modifiedPrimitive.addVertex(point);
            }
            if (Objects.equals(this.secondSegmentData.getPosition(), 0)) {
                for (int i = 0; i < secondLine.getNumVertices(); ++i) {
                    if (i == 0) continue;
                    modifiedPrimitive.addVertex(secondLine.getVertex(i));
                }
            } else {
                for (int i = secondLine.getNumVertices() - 1; i >= 0; --i) {
                    if (i == secondLine.getNumVertices() - 1) continue;
                    modifiedPrimitive.addVertex(secondLine.getVertex(i));
                }
            }
        } else {
            modifiedPrimitive.removeVertex(0);
            for (Point point : chamfer) {
                modifiedPrimitive.insertVertex(0, point);
            }
            if (Objects.equals(this.secondSegmentData.getPosition(), 0)) {
                for (int i = 0; i < secondLine.getNumVertices(); ++i) {
                    if (i == 0) continue;
                    modifiedPrimitive.insertVertex(0, secondLine.getVertex(i));
                }
            } else {
                for (int i = secondLine.getNumVertices() - 1; i >= 0; --i) {
                    if (i == secondLine.getNumVertices() - 1) continue;
                    modifiedPrimitive.insertVertex(0, secondLine.getVertex(i));
                }
            }
        }
        return modifiedPrimitive;
    }

    private Pair<Point, Point> calculateOpositeToChamferVertices(SegmentData firstSegmentData, SegmentData secondSegmentData) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Point secondVertex;
        Point firstVertex;
        if (Objects.equals(firstSegmentData.getPrimitive(), secondSegmentData.getPrimitive())) {
            if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() - 1)) {
                firstVertex = firstSegmentData.getLine().getVertex(0);
                secondVertex = secondSegmentData.getLine().getVertex(1);
            } else if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() + 1)) {
                firstVertex = firstSegmentData.getLine().getVertex(1);
                secondVertex = secondSegmentData.getLine().getVertex(0);
            } else {
                firstVertex = Objects.equals(firstSegmentData.getPosition(), 0) ? firstSegmentData.getLine().getVertex(1) : firstSegmentData.getLine().getVertex(0);
                secondVertex = Objects.equals(secondSegmentData.getPosition(), 0) ? secondSegmentData.getLine().getVertex(1) : secondSegmentData.getLine().getVertex(0);
            }
        } else {
            firstVertex = Objects.equals(firstSegmentData.getPosition(), 0) ? firstSegmentData.getLine().getVertex(1) : firstSegmentData.getLine().getVertex(0);
            secondVertex = Objects.equals(secondSegmentData.getPosition(), 0) ? secondSegmentData.getLine().getVertex(1) : secondSegmentData.getLine().getVertex(0);
        }
        return new ImmutablePair((Object)firstVertex, (Object)secondVertex);
    }

    public void start() throws StartServiceException {
        this.values.clear();
        this.firstSegmentData = null;
        this.secondSegmentData = null;
        this.pointToChamfer = null;
        if (savedDistance != null) {
            this.lengthParameter.setDefaultValue((Object)savedDistance);
        }
    }

    public void restart() throws StartServiceException, InvalidEntryException, StopServiceException {
        this.values.clear();
        this.firstSegmentData = null;
        this.secondSegmentData = null;
        this.pointToChamfer = null;
        if (savedDistance != null) {
            this.lengthParameter.setDefaultValue((Object)savedDistance);
        }
    }

    public void initDefaultValues() {
        super.initDefaultValues();
        if (deleteSecondFeatureDefaultValue != null) {
            this.deleteSecondSelectedGeometryParameter.setDefaultValue((Object)deleteSecondFeatureDefaultValue);
        }
    }

    public void stop() throws StopServiceException {
        this.values.clear();
        this.firstSegmentData = null;
        this.secondSegmentData = null;
        this.pointToChamfer = null;
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }

    private Feature getFeatureNearestPoint(Point point) {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Feature feature = editingProviderServices.getFeature(point, this.featureStore, this.mapContext);
        return feature;
    }

    private int validateAsSecondSegmentData(SegmentData segmentData, Point oppositeVertex) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Primitive secondPrimitive;
        if (!segmentData.isFilled()) {
            return 2;
        }
        if (this.firstSegmentData == null) {
            return 3;
        }
        Primitive firstPrimitive = this.firstSegmentData.getPrimitive();
        if (Objects.equals(firstPrimitive, secondPrimitive = segmentData.getPrimitive())) {
            if (Objects.equals(this.firstSegmentData.getIdxVertex(), segmentData.getIdxVertex())) {
                return 4;
            }
            if (Math.abs(this.firstSegmentData.getIdxVertex() - segmentData.getIdxVertex()) <= 1) {
                return this.validateSegmentsAndLength(this.firstSegmentData, segmentData, this.calculatePointToChamfer(this.firstSegmentData, segmentData));
            }
            switch (firstPrimitive.getType()) {
                case 18: {
                    if (((Line)firstPrimitive).isClosed()) {
                        if (this.firstSegmentData.getPosition().equals(0) && segmentData.getPosition().equals(2) || this.firstSegmentData.getPosition().equals(2) && segmentData.getPosition().equals(0)) {
                            return this.validateSegmentsAndLength(this.firstSegmentData, segmentData, this.calculatePointToChamfer(this.firstSegmentData, segmentData));
                        }
                    } else if ((this.firstSegmentData.getPosition().equals(0) || this.firstSegmentData.getPosition().equals(2)) && (segmentData.getPosition().equals(0) || segmentData.getPosition().equals(2))) {
                        Point tmpPointToChamfer = this.calculatePointToChamfer(this.firstSegmentData, segmentData);
                        if (tmpPointToChamfer == null || this.calculateZoneInSegment(tmpPointToChamfer, segmentData) == -1 || this.calculateZoneInSegment(tmpPointToChamfer, this.firstSegmentData) == -1) {
                            return 5;
                        }
                        if (!this.isPointBetweenTwoPoints(segmentData.getProjectedPoint(), oppositeVertex, tmpPointToChamfer)) {
                            return 5;
                        }
                        return this.validateSegmentsAndLength(this.firstSegmentData, segmentData, this.calculatePointToChamfer(this.firstSegmentData, segmentData));
                    }
                    return 6;
                }
                case 19: {
                    if (this.firstSegmentData.getPosition().equals(0) && segmentData.getPosition().equals(2) || this.firstSegmentData.getPosition().equals(2) && segmentData.getPosition().equals(0)) {
                        return this.validateSegmentsAndLength(this.firstSegmentData, segmentData, this.calculatePointToChamfer(this.firstSegmentData, segmentData));
                    }
                    return 6;
                }
            }
            return 6;
        }
        if (firstPrimitive.getType() != 18 || secondPrimitive.getType() != 18) {
            return 7;
        }
        if (this.firstSegmentData.getPosition().equals(1) || segmentData.getPosition().equals(1)) {
            return 9;
        }
        Point tmpPointToChamfer = this.calculatePointToChamfer(this.firstSegmentData, segmentData);
        if (tmpPointToChamfer == null || !this.isPointBetweenTwoPoints(segmentData.getProjectedPoint(), oppositeVertex, tmpPointToChamfer)) {
            return 5;
        }
        return this.validateSegmentsAndLength(this.firstSegmentData, segmentData, tmpPointToChamfer);
    }

    private int validateSegmentsAndLength(SegmentData firstSegmentData, SegmentData secondSegmentData, Point pointToChamfer) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Pair<Point, Point> oppositeVertices = this.calculateOpositeToChamferVertices(firstSegmentData, secondSegmentData);
        Double length = (Double)this.getValue(this.lengthParameter);
        double maxLength = Math.max(((Point)oppositeVertices.getLeft()).distance((Geometry)pointToChamfer), Math.max(((Point)oppositeVertices.getRight()).distance((Geometry)pointToChamfer), ((Point)oppositeVertices.getRight()).distance((Geometry)oppositeVertices.getLeft())));
        if (length > maxLength) {
            return 1;
        }
        return 0;
    }

    private Point calculatePointToChamfer(SegmentData firstSegmentData, SegmentData secondSegmentData) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Primitive secondPrimitive;
        Primitive firstPrimitive = firstSegmentData.getPrimitive();
        if (Objects.equals(firstPrimitive, secondPrimitive = secondSegmentData.getPrimitive())) {
            if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex())) {
                return null;
            }
            switch (firstPrimitive.getType()) {
                case 18: {
                    if (((Line)firstPrimitive).isClosed()) {
                        if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() - 1)) {
                            return firstSegmentData.getLine().getVertex(1);
                        }
                        if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() + 1)) {
                            return firstSegmentData.getLine().getVertex(0);
                        }
                        if (firstSegmentData.getPosition().equals(0) && secondSegmentData.getPosition().equals(2)) {
                            return firstSegmentData.getLine().getVertex(0);
                        }
                        if (firstSegmentData.getPosition().equals(2) && secondSegmentData.getPosition().equals(0)) {
                            return firstSegmentData.getLine().getVertex(1);
                        }
                        return null;
                    }
                    if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() - 1)) {
                        return firstSegmentData.getLine().getVertex(1);
                    }
                    if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() + 1)) {
                        return firstSegmentData.getLine().getVertex(0);
                    }
                    if (firstSegmentData.getPosition().equals(0) && secondSegmentData.getPosition().equals(2) || firstSegmentData.getPosition().equals(2) && secondSegmentData.getPosition().equals(0)) {
                        return this.calculatePointToChamferSeparateSegments(firstSegmentData, secondSegmentData);
                    }
                    return null;
                }
                case 19: {
                    if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() - 1)) {
                        return firstSegmentData.getLine().getVertex(1);
                    }
                    if (Objects.equals(firstSegmentData.getIdxVertex(), secondSegmentData.getIdxVertex() + 1)) {
                        return firstSegmentData.getLine().getVertex(0);
                    }
                    if (firstSegmentData.getPosition().equals(0) && secondSegmentData.getPosition().equals(2)) {
                        return firstSegmentData.getLine().getVertex(0);
                    }
                    if (firstSegmentData.getPosition().equals(2) && secondSegmentData.getPosition().equals(0)) {
                        return firstSegmentData.getLine().getVertex(1);
                    }
                    return null;
                }
            }
            return null;
        }
        if (firstPrimitive.getType() != 18) {
            return null;
        }
        if (secondPrimitive.getType() != 18) {
            return null;
        }
        if ((firstSegmentData.getPosition().equals(0) || firstSegmentData.getPosition().equals(2)) && (secondSegmentData.getPosition().equals(0) || secondSegmentData.getPosition().equals(2))) {
            return this.calculatePointToChamferSeparateSegments(firstSegmentData, secondSegmentData);
        }
        return null;
    }

    private Point calculatePointToChamferSeparateSegments(SegmentData firstSegmentData, SegmentData secondSegmentData) throws GeometryOperationNotSupportedException, GeometryOperationException {
        EuclideanLine2D secondLine;
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        EuclideanLine2D firstLine = euclideanManager.createLine2D(firstSegmentData.getLine().getVertex(0).getX(), firstSegmentData.getLine().getVertex(0).getY(), firstSegmentData.getLine().getVertex(1).getX(), firstSegmentData.getLine().getVertex(1).getY());
        Point2D intersection = firstLine.getIntersection(secondLine = euclideanManager.createLine2D(secondSegmentData.getLine().getVertex(0).getX(), secondSegmentData.getLine().getVertex(0).getY(), secondSegmentData.getLine().getVertex(1).getX(), secondSegmentData.getLine().getVertex(1).getY()));
        Point intersectionPoint = GeometryUtils.createPoint((double)intersection.getX(), (double)intersection.getY());
        if (intersectionPoint == null) {
            return null;
        }
        if (firstSegmentData.getPosition().equals(2) && this.calculateZoneInSegment(intersectionPoint, firstSegmentData) == -1) {
            return null;
        }
        if (firstSegmentData.getPosition().equals(0) && this.calculateZoneInSegment(intersectionPoint, firstSegmentData) == -1) {
            return null;
        }
        if (secondSegmentData.getPosition().equals(2) && this.calculateZoneInSegment(intersectionPoint, firstSegmentData) == -1) {
            return null;
        }
        if (secondSegmentData.getPosition().equals(0) && this.calculateZoneInSegment(intersectionPoint, firstSegmentData) == -1) {
            return null;
        }
        return intersectionPoint;
    }

    private int calculateZoneInSegment(Point point, SegmentData segmentData) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Point secondVertex;
        Point firstVertex;
        Line line = segmentData.getLine();
        if (line.getNumVertices() > 2) {
            throw new IllegalArgumentException("Segment has more than two vertex.");
        }
        if (Objects.equals(segmentData.getPosition(), 2)) {
            firstVertex = line.getVertex(0);
            secondVertex = line.getVertex(1);
        } else {
            firstVertex = line.getVertex(1);
            secondVertex = line.getVertex(0);
        }
        double segmentLenght = firstVertex.distance((Geometry)secondVertex);
        if (segmentLenght >= firstVertex.distance((Geometry)point) && segmentLenght >= secondVertex.distance((Geometry)point)) {
            return 0;
        }
        if (firstVertex.distance((Geometry)point) > secondVertex.distance((Geometry)point)) {
            return 1;
        }
        return -1;
    }

    private boolean isPointBetweenTwoPoints(Point point, Point vertex1, Point vertex2) {
        if (point.getX() < vertex1.getX() && point.getX() < vertex2.getX()) {
            return false;
        }
        if (point.getX() > vertex1.getX() && point.getX() > vertex2.getX()) {
            return false;
        }
        if (point.getY() < vertex1.getY() && point.getY() < vertex2.getY()) {
            return false;
        }
        return !(point.getY() > vertex1.getY()) || !(point.getY() > vertex2.getY());
    }

    private double calculateDefaultAngle(Point pointToChamfer, Pair<Point, Point> oppositeVertices) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        Point2D p = euclideanManager.getPointAtDistance(pointToChamfer.getX(), pointToChamfer.getY(), pointToChamfer.distance((Geometry)oppositeVertices.getLeft()), GeometryUtils.calculateAngle((Point)pointToChamfer, (Point)((Point)oppositeVertices.getRight())), null);
        Point midPoint = GeometryUtils.getMidPoint((Point)((Point)oppositeVertices.getLeft()), (Point)GeometryUtils.createPoint((double)p.getX(), (double)p.getY()), (int)pointToChamfer.getGeometryType().getSubType());
        double angle = GeometryUtils.calculateAngle((Point)pointToChamfer, (Point)midPoint);
        if ((angle += 1.5707963267948966) > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        return Math.toDegrees(angle);
    }

    private Line calculateChamfer(SegmentData firstSegmentData, SegmentData secondSegmentData, Double length, Double angle, int subType) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        ScaffoldingToChamfer scaffolding = this.calculateScaffolding(firstSegmentData, secondSegmentData, this.pointToChamfer, length, angle, subType);
        if (scaffolding == null) {
            return null;
        }
        Line chamfer = scaffolding.isReversed() ? GeometryUtils.createLine((double)scaffolding.chamferRight.getX(), (double)scaffolding.chamferRight.getY(), (double)scaffolding.chamferLeft.getX(), (double)scaffolding.chamferLeft.getY(), (int)subType) : GeometryUtils.createLine((double)scaffolding.chamferLeft.getX(), (double)scaffolding.chamferLeft.getY(), (double)scaffolding.chamferRight.getX(), (double)scaffolding.chamferRight.getY(), (int)subType);
        return chamfer;
    }

    private ScaffoldingToChamfer calculateScaffolding(SegmentData firstSegmentData, SegmentData secondSegmentData, Point pointToChamfer, Double length, Double angle, int subType) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        EuclideanLine2D baseParallel;
        Point2D chamferLeft;
        EuclideanLine2D right;
        Pair<Point, Point> oppositeVertices = this.calculateOpositeToChamferVertices(firstSegmentData, secondSegmentData);
        Point p1 = GeometryUtils.createPoint((Point)pointToChamfer, (double)length, (double)angle);
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        boolean reverse = false;
        EuclideanLine2D base = euclideanManager.createLine2D(pointToChamfer.getX(), pointToChamfer.getY(), p1.getX(), p1.getY());
        Point o1 = (Point)oppositeVertices.getLeft();
        Point o2 = (Point)oppositeVertices.getRight();
        EuclideanLine2D left = euclideanManager.createLine2D(pointToChamfer.getX(), pointToChamfer.getY(), o1.getX(), o1.getY());
        EuclideanLine2D leftParallel = left.getParallel(p1.getX(), p1.getY());
        Point2D chamferRight = leftParallel.getIntersection(right = euclideanManager.createLine2D(pointToChamfer.getX(), pointToChamfer.getY(), o2.getX(), o2.getY()));
        if (!this.isPointBetweenTwoPoints(GeometryUtils.createPoint((double)chamferRight.getX(), (double)chamferRight.getY()), o2, pointToChamfer)) {
            reverse = true;
            o1 = (Point)oppositeVertices.getRight();
            o2 = (Point)oppositeVertices.getLeft();
            left = euclideanManager.createLine2D(pointToChamfer.getX(), pointToChamfer.getY(), o1.getX(), o1.getY());
            leftParallel = left.getParallel(p1.getX(), p1.getY());
            chamferRight = leftParallel.getIntersection(right = euclideanManager.createLine2D(pointToChamfer.getX(), pointToChamfer.getY(), o2.getX(), o2.getY()));
            if (!this.isPointBetweenTwoPoints(GeometryUtils.createPoint((double)chamferRight.getX(), (double)chamferRight.getY()), o2, pointToChamfer)) {
                return null;
            }
        }
        if (!this.isPointBetweenTwoPoints(GeometryUtils.createPoint((double)(chamferLeft = (baseParallel = base.getParallel(chamferRight)).getIntersection(left)).getX(), (double)chamferLeft.getY()), o1, pointToChamfer)) {
            return null;
        }
        ScaffoldingToChamfer scaffolding = new ScaffoldingToChamfer(chamferLeft, chamferRight, p1, reverse);
        return scaffolding;
    }

    private class ScaffoldingToChamfer {
        private final Point2D chamferLeft;
        private final Point2D chamferRight;
        private final Point p1;
        private final boolean reverse;

        public ScaffoldingToChamfer(Point2D chamferLeft, Point2D chamferRight, Point p1, boolean reverse) {
            this.chamferLeft = chamferLeft;
            this.chamferRight = chamferRight;
            this.p1 = p1;
            this.reverse = reverse;
        }

        public Point2D getChamferRight() {
            return this.chamferRight;
        }

        public Point2D getChamferLeft() {
            return this.chamferLeft;
        }

        public Point getP1() {
            return this.p1;
        }

        public boolean isReversed() {
            return this.reverse;
        }
    }
}

