/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.chamfer;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math.util.MathUtils;
import org.gvsig.euclidean.EuclideanLine2D;
import org.gvsig.euclidean.EuclideanManager;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.MultiPrimitive;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.primitive.Surface;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.symbology.SymbologyLocator;
import org.gvsig.symbology.SymbologyManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.text.ISimpleTextSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.prov.chamfer.SegmentData;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProviderLocator;
import org.gvsig.vectorediting.lib.spi.EditingProviderManager;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixChamferByLengthAndAngleEditingProvider
extends AbstractEditingProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FixChamferByLengthAndAngleEditingProvider.class);
    private static final int ERR_OK = 0;
    private static final int ERR_CHAMFER_TOO_LARGE = 1;
    private static final int ERR_CANT_CALCULATE_CHAMFER_POINT = 2;
    private static final int ERR_INVALID_VALUE = 3;
    private static final int ERR_INVALID_GEOMETRY_TYPE = 4;
    private static final int ERR_CANT_FIND_NEAREST_GEOMETRY = 5;
    private static final int ERR_CANT_CALCULATE_CHAMFER = 6;
    private static final int ERR_SELECTED_SEGMENT_IS_ONE_OF_THE_ENDS_OF_AN_OPEN_LINE = 7;
    private static final int ERR_SELECTED_SEGMENT_LENGTH_IS_IN_VALID_RANGE = 8;
    private static final int ERR_CANT_CALCULATE_OPPOSITE_VERTICES = 9;
    private static String[] stateMessages = new String[]{"_Valid", "_Chamfer_too_large", "_Cant_calculate_chamfer_point", "_Invalid_value", "_Invalid_geometry_type", "_Cant_find_nearest_geometry", "_Cant_calculate_chamfer", "_Selected_segment_is_one_of_the_ends_of_an_open_line", "_Selected_segment_lenght_is_in_valid_range_0_plus_minus_1", "_Cant_calculate_opposite_vertices"};
    private static final String CHAMFER_LENGTH = "_Length";
    private static final String TOLERANCE = "_Tolerance";
    private static final String ANGLE = "_Angle";
    private final EditingServiceParameter lengthParameter;
    private final EditingServiceParameter toleranceParameter;
    private final EditingServiceParameter chamferToFixParameter;
    private final EditingServiceParameter angleParameter;
    private final Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;
    private final MapContext mapContext;
    private SegmentData chamferToFixSegmentData;
    private Point pointToChamfer;
    private static Double savedDistance;
    private static Double savedTolerance;
    private ISymbol previewSymbol;

    public FixChamferByLengthAndAngleEditingProvider(ProviderServices providerServices, DynObject parameters) {
        super(providerServices);
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.mapContext = (MapContext)parameters.getDynValue("mapContext");
        this.chamferToFixParameter = new DefaultEditingServiceParameter("_Chamfer_to_fix", "_Chamfer_to_fix", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
        this.lengthParameter = new DefaultEditingServiceParameter(CHAMFER_LENGTH, CHAMFER_LENGTH, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE, EditingServiceParameter.TYPE.DISTANCE});
        this.toleranceParameter = new DefaultEditingServiceParameter(TOLERANCE, TOLERANCE, true, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.VALUE});
        this.toleranceParameter.setDefaultValue((Object)0.01);
        this.angleParameter = new DefaultEditingServiceParameter(ANGLE, ANGLE, new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION, EditingServiceParameter.TYPE.VALUE});
        this.values = new HashMap<EditingServiceParameter, Object>();
    }

    public String getName() {
        return "modify-fix-chamfer-by-length-and-angle";
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.lengthParameter) == null) {
            return this.lengthParameter;
        }
        if (this.values.get(this.chamferToFixParameter) == null) {
            return this.chamferToFixParameter;
        }
        if (this.values.get(this.angleParameter) == null) {
            return this.angleParameter;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        DefaultDrawingStatus geometries = new DefaultDrawingStatus();
        GeometryManager geometryManager = GeometryLocator.getGeometryManager();
        EditingProviderManager editingProviderManager = EditingProviderLocator.getProviderManager();
        ISymbol lineSymbolEditing = editingProviderManager.getSymbol("line-symbol-editing");
        ISymbol auxiliaryLineSymbolEditing = editingProviderManager.getSymbol("auxiliary-line-symbol-editing");
        ISymbol auxiliaryPointSymbolEditing = editingProviderManager.getSymbol("auxiliary-point-symbol-editing");
        ISymbol polygonSymbolEditing = editingProviderManager.getSymbol("polygon-symbol-editing");
        ISymbol ruleAxisSymbol = editingProviderManager.getSymbol("rule-axis-symbol");
        auxiliaryPointSymbolEditing.setColor(Color.RED);
        ISimpleTextSymbol textSymbol = this.getTextSymbol();
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Object previewSymbol = null;
        try {
            int subtype = editingProviderServices.getSubType(this.featureStore);
            if (this.values != null) {
                if (this.values.get(this.lengthParameter) == null) {
                    return geometries;
                }
                if (this.chamferToFixSegmentData == null) {
                    Feature selectedFeature = this.getFeatureNearestPoint(mousePosition);
                    if (selectedFeature == null) {
                        return geometries;
                    }
                    Geometry selectedGeometry = selectedFeature.getDefaultGeometry();
                    if (selectedGeometry == null || !this.validateGeometryType(selectedGeometry)) {
                        return geometries;
                    }
                    SegmentData segmentData = new SegmentData(selectedFeature, mousePosition);
                    if (this.validateSelectedSegmentData(segmentData) != 0) {
                        return geometries;
                    }
                    geometries.addStatus((Geometry)segmentData.getProjectedPoint(), auxiliaryPointSymbolEditing, "");
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)mousePosition, (Point)segmentData.getProjectedPoint(), (int)subtype), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)segmentData.getLine(), auxiliaryLineSymbolEditing, "");
                    return geometries;
                }
                if (this.values.get(this.angleParameter) == null) {
                    Pair<Point, Point> oppositePoints = this.calculateOpositeToChamferVertices(this.chamferToFixSegmentData);
                    Point tmpPointToFillet = this.calculatePointToChamfer(this.chamferToFixSegmentData, oppositePoints);
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)((Point)oppositePoints.getLeft()), (Point)tmpPointToFillet, (int)subtype), auxiliaryLineSymbolEditing, "");
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)((Point)oppositePoints.getRight()), (Point)tmpPointToFillet, (int)subtype), auxiliaryLineSymbolEditing, "");
                    Double distance = (Double)this.getValue(this.lengthParameter);
                    double angle = GeometryUtils.calculateAngle((Point)this.pointToChamfer, (Point)mousePosition);
                    geometries.addStatus((Geometry)tmpPointToFillet, auxiliaryPointSymbolEditing, "");
                    ScaffoldingToChamfer scaffolding = this.calculateScaffolding(this.chamferToFixSegmentData, tmpPointToFillet, distance, angle, subtype);
                    if (scaffolding == null) {
                        return geometries;
                    }
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)tmpPointToFillet, (Point)scaffolding.getP1(), (int)subtype), auxiliaryLineSymbolEditing, "");
                    if (scaffolding.isReversed()) {
                        geometries.addStatus((Geometry)GeometryUtils.createLine((Point)scaffolding.getP1(), (Point)GeometryUtils.createPoint((double)scaffolding.getChamferRight().getX(), (double)scaffolding.getChamferRight().getY()), (int)subtype), auxiliaryLineSymbolEditing, "");
                    } else {
                        geometries.addStatus((Geometry)GeometryUtils.createLine((Point)scaffolding.getP1(), (Point)GeometryUtils.createPoint((double)scaffolding.getChamferRight().getX(), (double)scaffolding.getChamferRight().getY()), (int)subtype), auxiliaryLineSymbolEditing, "");
                    }
                    geometries.addStatus((Geometry)GeometryUtils.createLine((Point)GeometryUtils.createPoint((double)scaffolding.getChamferRight().getX(), (double)scaffolding.getChamferRight().getY()), (Point)GeometryUtils.createPoint((double)scaffolding.getChamferLeft().getX(), (double)scaffolding.getChamferLeft().getY()), (int)subtype), auxiliaryLineSymbolEditing, "");
                    Line ruleAxisBaseLine = geometryManager.createLine(subtype);
                    ruleAxisBaseLine.addVertex(tmpPointToFillet);
                    Point p2 = geometryManager.createPoint(tmpPointToFillet.getX() + tmpPointToFillet.distance((Geometry)mousePosition), tmpPointToFillet.getY(), subtype);
                    ruleAxisBaseLine.addVertex(p2);
                    geometries.addStatus((Geometry)ruleAxisBaseLine, ruleAxisSymbol, "");
                    Line angleLine = geometryManager.createLine(subtype);
                    angleLine.addVertex(tmpPointToFillet);
                    angleLine.addVertex(mousePosition);
                    geometries.addStatus((Geometry)angleLine, ruleAxisSymbol, "");
                    Double ext = Math.PI * 2 - angle;
                    Arc arc = GeometryUtils.createArc((Point)tmpPointToFillet, (double)(tmpPointToFillet.distance((Geometry)mousePosition) / 2.0), (double)0.0, (double)angle, (int)0);
                    geometries.addStatus((Geometry)arc, auxiliaryLineSymbolEditing, "");
                    double textDistance = 3.0 * tmpPointToFillet.distance((Geometry)mousePosition) / 4.0;
                    Point pointText = geometryManager.createPoint(tmpPointToFillet.getX() + textDistance * Math.cos(angle / 2.0), tmpPointToFillet.getY() + textDistance * Math.sin(angle / 2.0), subtype);
                    geometries.addStatus((Geometry)pointText, (ISymbol)textSymbol, GeometryUtils.formatAngle((String)"%5.3D\u00b0", (double)Math.toDegrees(angle)));
                    this.drawResult(geometries, this.chamferToFixSegmentData, distance, angle, subtype);
                    return geometries;
                }
                this.drawResult(geometries, this.chamferToFixSegmentData, (Double)this.getValue(this.lengthParameter), Math.toRadians((Double)this.getValue(this.angleParameter)), subtype);
                return geometries;
            }
        }
        catch (Exception e) {
            throw new DrawServiceException((Throwable)e);
        }
        return geometries;
    }

    private void drawResult(DefaultDrawingStatus geometries, SegmentData selectedSegmentData, Double length, Double angle, int subtype) throws CreateGeometryException, GeometryOperationNotSupportedException, IllegalStateException, GeometryException, GeometryOperationException {
        if (this.previewSymbol == null) {
            return;
        }
        Pair<Point, Point> oppositeVertices = this.calculateOpositeToChamferVertices(selectedSegmentData);
        Point pointToChamfer = this.calculatePointToChamfer(selectedSegmentData, oppositeVertices);
        Line chamfer = this.calculateChamfer(selectedSegmentData, pointToChamfer, length, angle, subtype);
        if (chamfer == null) {
            return;
        }
        geometries.addStatus((Geometry)this.chamferPrimitive(selectedSegmentData.getPrimitive(), chamfer), this.previewSymbol, null);
    }

    private ISimpleTextSymbol getTextSymbol() {
        SymbologyManager symbologyManager = SymbologyLocator.getSymbologyManager();
        ISimpleTextSymbol textSymbol = symbologyManager.createSimpleTextSymbol();
        textSymbol.setFontSize(10.0);
        return textSymbol;
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.lengthParameter);
        parameters.add(this.toleranceParameter);
        parameters.add(this.chamferToFixParameter);
        parameters.add(this.angleParameter);
        return parameters;
    }

    public boolean isEnabled(EditingServiceParameter parameter) {
        return true;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter param = this.next();
        this.validateAndInsertValue(param, value);
    }

    private void validateAndInsertValue(EditingServiceParameter param, Object value) throws InvalidEntryException {
        try {
            EditingProviderServices editingProviderServices = this.getProviderServices();
            int subtype = editingProviderServices.getSubType(this.featureStore);
            I18nManager i18n = ToolsLocator.getI18nManager();
            if (param == this.lengthParameter) {
                Double distance = null;
                if (value instanceof Double) {
                    distance = (Double)value;
                } else if (value == null) {
                    distance = (Double)this.lengthParameter.getDefaultValue();
                    if (distance == null) {
                        throw new InvalidEntryException(this.getName(), 3, i18n.getTranslation(stateMessages[3]));
                    }
                } else {
                    throw new InvalidEntryException(this.getName(), 3, i18n.getTranslation(stateMessages[3]));
                }
                this.values.put(param, distance);
                savedDistance = distance;
            } else if (param == this.toleranceParameter) {
                Double tolerance = null;
                if (value instanceof Double) {
                    tolerance = (Double)value;
                } else if (value == null && (tolerance = (Double)this.toleranceParameter.getDefaultValue()) == null) {
                    throw new InvalidEntryException(this.getName(), 3, i18n.getTranslation(stateMessages[3]));
                }
                this.values.put(param, tolerance);
                savedTolerance = tolerance;
            } else if (param == this.chamferToFixParameter) {
                if (value instanceof Point) {
                    Point point = (Point)value;
                    Feature selectedFeature = this.getFeatureNearestPoint(point);
                    if (selectedFeature == null) {
                        throw new InvalidEntryException((Throwable)new IllegalArgumentException("Can't find nearest feature."));
                    }
                    Geometry selectedGeometry = selectedFeature.getDefaultGeometry();
                    if (!this.validateGeometryType(selectedGeometry)) {
                        throw new InvalidEntryException(this.getName(), 4, i18n.getTranslation(stateMessages[4]));
                    }
                    this.chamferToFixSegmentData = new SegmentData(selectedFeature, point);
                    int errno = this.validateSelectedSegmentData(this.chamferToFixSegmentData);
                    if (errno != 0) {
                        this.chamferToFixSegmentData = null;
                        this.pointToChamfer = null;
                        if (errno == 8) {
                            Double length = (Double)this.getValue(this.lengthParameter);
                            Double tolerance = (Double)this.getValue(this.toleranceParameter);
                            String[] args = new String[]{String.format("%.2f", length), String.format("%.2f", tolerance)};
                            throw new InvalidEntryException(this.getName(), errno, i18n.getTranslation(stateMessages[errno], args));
                        }
                        throw new InvalidEntryException(this.getName(), errno, i18n.getTranslation(stateMessages[errno]));
                    }
                    Pair<Point, Point> oppositeVertices = this.calculateOpositeToChamferVertices(this.chamferToFixSegmentData);
                    this.pointToChamfer = this.calculatePointToChamfer(this.chamferToFixSegmentData, oppositeVertices);
                    this.angleParameter.setDefaultValue((Object)this.calculateDefaultAngle(this.pointToChamfer, oppositeVertices));
                    this.values.put(param, value);
                    this.previewSymbol = this.getPreviewSymbol(this.chamferToFixSegmentData.getFeature());
                }
            } else if (param == this.angleParameter) {
                Double angle = null;
                if (value instanceof Double) {
                    angle = Math.toRadians((Double)value);
                } else if (value instanceof Point) {
                    Point point = (Point)value;
                    angle = GeometryUtils.calculateAngle((Point)this.pointToChamfer, (Point)point);
                } else if (value == null) {
                    angle = Math.toRadians((Double)param.getDefaultValue());
                } else {
                    throw new InvalidEntryException(this.getName(), 3, i18n.getTranslation(stateMessages[3]));
                }
                Double distance = (Double)this.getValue(this.lengthParameter);
                Line chamfer = this.calculateChamfer(this.chamferToFixSegmentData, this.pointToChamfer, distance, angle, subtype);
                if (chamfer == null) {
                    throw new InvalidEntryException(this.getName(), 6, i18n.getTranslation(stateMessages[5]));
                }
                this.values.put(param, Math.toDegrees(angle));
            }
        }
        catch (InvalidEntryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidEntryException((Throwable)ex);
        }
    }

    private boolean validateGeometryType(Geometry geometry) throws IllegalArgumentException {
        ArrayList<Integer> validGeometryTypes = new ArrayList<Integer>(Arrays.asList(18, 19, 21, 22));
        return validGeometryTypes.contains(geometry.getType());
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        Double distance = (Double)this.getValue(this.lengthParameter);
        Double angle = (Double)this.getValue(this.angleParameter);
        try {
            Geometry modifiedGeometry;
            EditingProviderServices editingProviderServices = this.getProviderServices();
            int subType = editingProviderServices.getSubType(this.featureStore);
            Line chamfer = this.calculateChamfer(this.chamferToFixSegmentData, this.pointToChamfer, (Double)this.getValue(this.lengthParameter), Math.toRadians((Double)this.getValue(this.angleParameter)), subType);
            if (chamfer == null) {
                throw new FinishServiceException("Can't calculate chamfer.", null);
            }
            Feature feature = this.chamferToFixSegmentData.getFeature();
            EditableFeature editableFeature = feature.getEditable();
            GeometryManager geomManager = GeometryLocator.getGeometryManager();
            Geometry selectedGeometry = this.chamferToFixSegmentData.getGeometry();
            Primitive selectedPrimitive = this.chamferToFixSegmentData.getPrimitive();
            if (selectedGeometry instanceof MultiPrimitive) {
                modifiedGeometry = geomManager.create(selectedGeometry.getGeometryType());
                MultiPrimitive selectedMultiPrimitive = (MultiPrimitive)selectedGeometry;
                for (Geometry geometry : selectedMultiPrimitive) {
                    Primitive primitive = (Primitive)geometry;
                    if (Objects.equals(selectedPrimitive, primitive)) {
                        Primitive modifiedPrimitive = this.chamferPrimitive(primitive, chamfer);
                        ((MultiPrimitive)modifiedGeometry).addPrimitive(modifiedPrimitive);
                        continue;
                    }
                    ((MultiPrimitive)modifiedGeometry).addPrimitive(primitive);
                }
            } else {
                modifiedGeometry = this.chamferPrimitive((Primitive)editableFeature.getDefaultGeometry(), chamfer);
            }
            editableFeature.setDefaultGeometry(modifiedGeometry);
            this.getProviderServices().updateFeatureInFeatureStore((Feature)editableFeature, this.featureStore);
        }
        catch (Exception e) {
            throw new FinishServiceException((Throwable)e);
        }
    }

    private Primitive chamferPrimitive(Primitive primitive, Line chamfer) throws IllegalStateException, GeometryException, GeometryOperationException, GeometryOperationNotSupportedException {
        Primitive modifiedPrimitive = (Primitive)primitive.cloneGeometry();
        if (primitive instanceof Line || primitive instanceof Polygon) {
            modifiedPrimitive = (Primitive)primitive.cloneGeometry();
        } else if (primitive instanceof Curve) {
            modifiedPrimitive = (Line)primitive.toLines().getPrimitiveAt(0);
        } else if (primitive instanceof Surface) {
            modifiedPrimitive = (Polygon)primitive.toPolygons().getPrimitiveAt(0);
        }
        if (modifiedPrimitive instanceof Line) {
            ((Line)modifiedPrimitive).removeVertex(this.chamferToFixSegmentData.getIdxVertex().intValue());
            ((Line)modifiedPrimitive).removeVertex(this.chamferToFixSegmentData.getIdxVertex().intValue());
            int i = 0;
            for (Point point : chamfer) {
                ((Line)modifiedPrimitive).insertVertex(this.chamferToFixSegmentData.getIdxVertex() + i++, point);
            }
            if (((Line)modifiedPrimitive).isClosed()) {
                if (Objects.equals(this.chamferToFixSegmentData.getPosition(), 0)) {
                    int lastVertex = ((Line)modifiedPrimitive).getNumVertices() - 1;
                    ((Line)modifiedPrimitive).removeVertex(lastVertex);
                    ((Line)modifiedPrimitive).insertVertex(lastVertex, ((Line)modifiedPrimitive).getVertex(0));
                } else if (Objects.equals(this.chamferToFixSegmentData.getPosition(), 2)) {
                    ((Line)modifiedPrimitive).removeVertex(0);
                    ((Line)modifiedPrimitive).insertVertex(0, ((Line)modifiedPrimitive).getVertex(((Line)modifiedPrimitive).getNumVertices() - 1));
                }
            }
        } else if (modifiedPrimitive instanceof Polygon) {
            ((Polygon)modifiedPrimitive).removeVertex(this.chamferToFixSegmentData.getIdxVertex().intValue());
            ((Polygon)modifiedPrimitive).removeVertex(this.chamferToFixSegmentData.getIdxVertex().intValue());
            int i = 0;
            for (Point point : chamfer) {
                ((Polygon)modifiedPrimitive).insertVertex(this.chamferToFixSegmentData.getIdxVertex() + i++, point);
            }
            if (Objects.equals(this.chamferToFixSegmentData.getPosition(), 0)) {
                int lastVertex = ((Polygon)modifiedPrimitive).getNumVertices() - 1;
                ((Polygon)modifiedPrimitive).removeVertex(lastVertex);
                ((Polygon)modifiedPrimitive).insertVertex(lastVertex, ((Polygon)modifiedPrimitive).getVertex(0));
            } else if (Objects.equals(this.chamferToFixSegmentData.getPosition(), 2)) {
                ((Polygon)modifiedPrimitive).removeVertex(0);
                ((Polygon)modifiedPrimitive).insertVertex(0, ((Polygon)modifiedPrimitive).getVertex(((Polygon)modifiedPrimitive).getNumVertices() - 1));
            }
        }
        return modifiedPrimitive;
    }

    private Pair<Point, Point> calculateOpositeToChamferVertices(SegmentData chamferToFixSegmentData) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Point firstVertex = null;
        Point secondVertex = null;
        Primitive primitive = chamferToFixSegmentData.getPrimitive();
        block0 : switch (primitive.getType()) {
            case 18: {
                if (((Line)primitive).isClosed()) {
                    switch (chamferToFixSegmentData.getPosition()) {
                        case 0: {
                            firstVertex = ((Line)primitive).getVertex(((Line)primitive).getNumVertices() - 2);
                            secondVertex = ((Line)primitive).getVertex(chamferToFixSegmentData.getIdxVertex() + 2);
                            break block0;
                        }
                        case 2: {
                            firstVertex = ((Line)primitive).getVertex(chamferToFixSegmentData.getIdxVertex() - 1);
                            secondVertex = ((Line)primitive).getVertex(1);
                            break block0;
                        }
                    }
                    firstVertex = ((Line)primitive).getVertex(chamferToFixSegmentData.getIdxVertex() - 1);
                    secondVertex = ((Line)primitive).getVertex(chamferToFixSegmentData.getIdxVertex() + 2);
                    break;
                }
                firstVertex = ((Line)primitive).getVertex(chamferToFixSegmentData.getIdxVertex() - 1);
                secondVertex = ((Line)primitive).getVertex(chamferToFixSegmentData.getIdxVertex() + 2);
                break;
            }
            case 19: {
                switch (chamferToFixSegmentData.getPosition()) {
                    case 0: {
                        firstVertex = ((Polygon)primitive).getVertex(((Polygon)primitive).getNumVertices() - 2);
                        secondVertex = ((Polygon)primitive).getVertex(chamferToFixSegmentData.getIdxVertex() + 2);
                        break block0;
                    }
                    case 2: {
                        firstVertex = ((Polygon)primitive).getVertex(chamferToFixSegmentData.getIdxVertex() - 1);
                        secondVertex = ((Polygon)primitive).getVertex(1);
                        break block0;
                    }
                }
                firstVertex = ((Polygon)primitive).getVertex(chamferToFixSegmentData.getIdxVertex() - 1);
                secondVertex = ((Polygon)primitive).getVertex(chamferToFixSegmentData.getIdxVertex() + 2);
                break;
            }
            default: {
                return null;
            }
        }
        return new ImmutablePair((Object)firstVertex, (Object)secondVertex);
    }

    public void start() throws StartServiceException {
        this.values.clear();
        this.chamferToFixSegmentData = null;
        this.pointToChamfer = null;
        if (savedDistance != null) {
            this.lengthParameter.setDefaultValue((Object)savedDistance);
        }
        if (savedTolerance != null) {
            this.toleranceParameter.setDefaultValue((Object)savedTolerance);
        }
    }

    public void restart() throws StartServiceException, InvalidEntryException, StopServiceException {
        this.values.clear();
        this.chamferToFixSegmentData = null;
        this.pointToChamfer = null;
        if (savedDistance != null) {
            this.lengthParameter.setDefaultValue((Object)savedDistance);
        }
        if (savedTolerance != null) {
            this.toleranceParameter.setDefaultValue((Object)savedTolerance);
        }
    }

    public void initDefaultValues() {
        super.initDefaultValues();
    }

    public void stop() throws StopServiceException {
        this.values.clear();
        this.chamferToFixSegmentData = null;
        this.pointToChamfer = null;
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }

    private Feature getFeatureNearestPoint(Point point) {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Feature feature = editingProviderServices.getFeature(point, this.featureStore, this.mapContext);
        return feature;
    }

    private int validateSelectedSegmentAndLength(SegmentData chamferToFixSegmentData, Point pointToChamfer) throws GeometryOperationNotSupportedException, GeometryOperationException {
        Pair<Point, Point> oppositeVertices = this.calculateOpositeToChamferVertices(chamferToFixSegmentData);
        Double length = (Double)this.getValue(this.lengthParameter);
        Double tolerance = (Double)(this.getValue(this.toleranceParameter) != null ? this.getValue(this.toleranceParameter) : this.toleranceParameter.getDefaultValue());
        if (MathUtils.compareTo((double)chamferToFixSegmentData.getLine().perimeter(), (double)length, (double)tolerance) == 0) {
            return 8;
        }
        double maxLength = Math.max(((Point)oppositeVertices.getLeft()).distance((Geometry)pointToChamfer), Math.max(((Point)oppositeVertices.getRight()).distance((Geometry)pointToChamfer), ((Point)oppositeVertices.getRight()).distance((Geometry)oppositeVertices.getLeft())));
        if (length > maxLength) {
            return 1;
        }
        return 0;
    }

    private Point calculatePointToChamfer(SegmentData selectedSegmentData, Pair<Point, Point> oppositeVertices) throws GeometryOperationNotSupportedException, GeometryOperationException {
        EuclideanLine2D secondLine;
        Point firstVertex = selectedSegmentData.getLine().getVertex(0);
        Point secondVertex = selectedSegmentData.getLine().getVertex(1);
        EuclideanManager euclidenManager = ToolsUtilLocator.getEuclideanManager();
        EuclideanLine2D firstLine = euclidenManager.createLine2D(((Point)oppositeVertices.getLeft()).getX(), ((Point)oppositeVertices.getLeft()).getY(), firstVertex.getX(), firstVertex.getY());
        Point2D intersection = firstLine.getIntersection(secondLine = euclidenManager.createLine2D(((Point)oppositeVertices.getRight()).getX(), ((Point)oppositeVertices.getRight()).getY(), secondVertex.getX(), secondVertex.getY()));
        if (intersection == null) {
            return null;
        }
        Point chamferPoint = GeometryUtils.createPoint((double)intersection.getX(), (double)intersection.getY());
        double leftSegmentLenght = ((Point)oppositeVertices.getLeft()).distance((Geometry)firstVertex);
        if (!(leftSegmentLenght >= firstVertex.distance((Geometry)chamferPoint) && leftSegmentLenght >= ((Point)oppositeVertices.getLeft()).distance((Geometry)chamferPoint) || ((Point)oppositeVertices.getLeft()).distance((Geometry)chamferPoint) > firstVertex.distance((Geometry)chamferPoint))) {
            return null;
        }
        double rightSegmentLenght = ((Point)oppositeVertices.getRight()).distance((Geometry)secondVertex);
        if (!(rightSegmentLenght >= secondVertex.distance((Geometry)chamferPoint) && rightSegmentLenght >= ((Point)oppositeVertices.getRight()).distance((Geometry)chamferPoint) || ((Point)oppositeVertices.getRight()).distance((Geometry)chamferPoint) > secondVertex.distance((Geometry)chamferPoint))) {
            return null;
        }
        return chamferPoint;
    }

    private boolean isPointBetweenTwoPoints(Point point, Point vertex1, Point vertex2) {
        if (point.getX() < vertex1.getX() && point.getX() < vertex2.getX()) {
            return false;
        }
        if (point.getX() > vertex1.getX() && point.getX() > vertex2.getX()) {
            return false;
        }
        if (point.getY() < vertex1.getY() && point.getY() < vertex2.getY()) {
            return false;
        }
        return !(point.getY() > vertex1.getY()) || !(point.getY() > vertex2.getY());
    }

    private double calculateDefaultAngle(Point pointToChamfer, Pair<Point, Point> oppositeVertices) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        Point2D p = euclideanManager.getPointAtDistance(pointToChamfer.getX(), pointToChamfer.getY(), pointToChamfer.distance((Geometry)oppositeVertices.getLeft()), GeometryUtils.calculateAngle((Point)pointToChamfer, (Point)((Point)oppositeVertices.getRight())), null);
        Point midPoint = GeometryUtils.getMidPoint((Point)((Point)oppositeVertices.getLeft()), (Point)GeometryUtils.createPoint((double)p.getX(), (double)p.getY()), (int)pointToChamfer.getGeometryType().getSubType());
        double angle = GeometryUtils.calculateAngle((Point)pointToChamfer, (Point)midPoint);
        if ((angle += 1.5707963267948966) > Math.PI * 2) {
            angle -= Math.PI * 2;
        }
        return Math.toDegrees(angle);
    }

    private Line calculateChamfer(SegmentData selectedSegmentData, Point pointToChamfer, Double length, Double angle, int subType) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        ScaffoldingToChamfer scaffolding = this.calculateScaffolding(selectedSegmentData, pointToChamfer, length, angle, subType);
        if (scaffolding == null) {
            return null;
        }
        Line chamfer = scaffolding.isReversed() ? GeometryUtils.createLine((double)scaffolding.chamferRight.getX(), (double)scaffolding.chamferRight.getY(), (double)scaffolding.chamferLeft.getX(), (double)scaffolding.chamferLeft.getY(), (int)subType) : GeometryUtils.createLine((double)scaffolding.chamferLeft.getX(), (double)scaffolding.chamferLeft.getY(), (double)scaffolding.chamferRight.getX(), (double)scaffolding.chamferRight.getY(), (int)subType);
        return chamfer;
    }

    private ScaffoldingToChamfer calculateScaffolding(SegmentData selectedSegmentData, Point pointToChamfer, Double length, Double angle, int subType) throws GeometryOperationNotSupportedException, GeometryOperationException, CreateGeometryException {
        EuclideanLine2D baseParallel;
        Point2D chamferLeft;
        EuclideanLine2D right;
        Pair<Point, Point> oppositeVertices = this.calculateOpositeToChamferVertices(selectedSegmentData);
        Point p1 = GeometryUtils.createPoint((Point)pointToChamfer, (double)length, (double)angle);
        EuclideanManager euclideanManager = ToolsUtilLocator.getEuclideanManager();
        boolean reverse = false;
        EuclideanLine2D base = euclideanManager.createLine2D(pointToChamfer.getX(), pointToChamfer.getY(), p1.getX(), p1.getY());
        Point o1 = (Point)oppositeVertices.getLeft();
        Point o2 = (Point)oppositeVertices.getRight();
        EuclideanLine2D left = euclideanManager.createLine2D(pointToChamfer.getX(), pointToChamfer.getY(), o1.getX(), o1.getY());
        EuclideanLine2D leftParallel = left.getParallel(p1.getX(), p1.getY());
        Point2D chamferRight = leftParallel.getIntersection(right = euclideanManager.createLine2D(pointToChamfer.getX(), pointToChamfer.getY(), o2.getX(), o2.getY()));
        if (!this.isPointBetweenTwoPoints(GeometryUtils.createPoint((double)chamferRight.getX(), (double)chamferRight.getY()), o2, pointToChamfer)) {
            reverse = true;
            o1 = (Point)oppositeVertices.getRight();
            o2 = (Point)oppositeVertices.getLeft();
            left = euclideanManager.createLine2D(pointToChamfer.getX(), pointToChamfer.getY(), o1.getX(), o1.getY());
            leftParallel = left.getParallel(p1.getX(), p1.getY());
            chamferRight = leftParallel.getIntersection(right = euclideanManager.createLine2D(pointToChamfer.getX(), pointToChamfer.getY(), o2.getX(), o2.getY()));
            if (!this.isPointBetweenTwoPoints(GeometryUtils.createPoint((double)chamferRight.getX(), (double)chamferRight.getY()), o2, pointToChamfer)) {
                return null;
            }
        }
        if (!this.isPointBetweenTwoPoints(GeometryUtils.createPoint((double)(chamferLeft = (baseParallel = base.getParallel(chamferRight)).getIntersection(left)).getX(), (double)chamferLeft.getY()), o1, pointToChamfer)) {
            return null;
        }
        ScaffoldingToChamfer scaffolding = new ScaffoldingToChamfer(chamferLeft, chamferRight, p1, reverse);
        return scaffolding;
    }

    private int validateSelectedSegmentData(SegmentData chamferToFixSegmentData) throws GeometryOperationNotSupportedException, GeometryOperationException {
        int errno = 0;
        if (!chamferToFixSegmentData.isFilled()) {
            chamferToFixSegmentData = null;
            return 5;
        }
        if (chamferToFixSegmentData == null) {
            return 5;
        }
        Primitive primitive = chamferToFixSegmentData.getPrimitive();
        switch (primitive.getType()) {
            case 18: {
                if (((Line)primitive).isClosed()) break;
                switch (chamferToFixSegmentData.getPosition()) {
                    case 0: 
                    case 2: {
                        errno = 7;
                    }
                }
                break;
            }
            case 19: {
                break;
            }
            default: {
                return 4;
            }
        }
        if (errno == 0) {
            errno = this.validateAdjacentSegments(chamferToFixSegmentData);
        }
        if (errno == 0) {
            Pair<Point, Point> oppositeVertices = this.calculateOpositeToChamferVertices(chamferToFixSegmentData);
            if (oppositeVertices == null) {
                errno = 9;
            }
            if (errno == 0) {
                Point pointToChamfer = this.calculatePointToChamfer(chamferToFixSegmentData, oppositeVertices);
                if (pointToChamfer == null) {
                    errno = 2;
                }
                if (errno == 0) {
                    errno = this.validateSelectedSegmentAndLength(chamferToFixSegmentData, pointToChamfer);
                }
            }
        }
        return errno;
    }

    private int validateAdjacentSegments(SegmentData chamferToFixSegmentData) {
        try {
            Pair<Point, Point> oppositeVertices = this.calculateOpositeToChamferVertices(chamferToFixSegmentData);
            Point pointToChamfer = this.calculatePointToChamfer(chamferToFixSegmentData, oppositeVertices);
            if (pointToChamfer == null) {
                return 2;
            }
        }
        catch (GeometryOperationException | GeometryOperationNotSupportedException ex) {
            return 2;
        }
        return 0;
    }

    private class ScaffoldingToChamfer {
        private final Point2D chamferLeft;
        private final Point2D chamferRight;
        private final Point p1;
        private final boolean reverse;

        public ScaffoldingToChamfer(Point2D chamferLeft, Point2D chamferRight, Point p1, boolean reverse) {
            this.chamferLeft = chamferLeft;
            this.chamferRight = chamferRight;
            this.p1 = p1;
            this.reverse = reverse;
        }

        public Point2D getChamferRight() {
            return this.chamferRight;
        }

        public Point2D getChamferLeft() {
            return this.chamferLeft;
        }

        public Point getP1() {
            return this.p1;
        }

        public boolean isReversed() {
            return this.reverse;
        }
    }
}

