/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.chamfer;

import java.util.Iterator;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.aggregate.Aggregate;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Polygon;
import org.gvsig.fmap.geom.primitive.Primitive;

public class SegmentData {
    public static final int SEGMENT_POSITION_FIRST = 0;
    public static final int SEGMENT_POSITION_MIDDLE = 1;
    public static final int SEGMENT_POSITION_LAST = 2;
    private Feature feature = null;
    private Primitive primitive = null;
    private Point projectedPoint = null;
    private Line line = null;
    private Integer idxVertex = null;

    public SegmentData(Feature feature, Point inputPoint) {
        this.feature = feature;
        if (!this.fill(feature.getDefaultGeometry(), inputPoint)) {
            this.primitive = null;
            this.projectedPoint = null;
            this.line = null;
            this.idxVertex = null;
        }
    }

    public Feature getFeature() {
        return this.feature;
    }

    public Geometry getGeometry() {
        return this.feature.getDefaultGeometry();
    }

    public Primitive getPrimitive() {
        return this.primitive;
    }

    public Point getProjectedPoint() {
        return this.projectedPoint;
    }

    public Line getLine() {
        return this.line;
    }

    public Integer getIdxVertex() {
        return this.idxVertex;
    }

    private boolean fill(Geometry geometry, Point inputPoint) {
        try {
            Iterator it;
            switch (geometry.getType()) {
                case 18: {
                    this.primitive = (Primitive)geometry;
                    break;
                }
                case 19: {
                    this.primitive = (Primitive)geometry;
                    break;
                }
                case 21: 
                case 22: {
                    Aggregate aggregate = (Aggregate)geometry;
                    this.primitive = this.getNearestPrimitive(aggregate, inputPoint);
                    if (this.primitive != null) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            switch (this.primitive.getType()) {
                case 18: {
                    it = ((Line)this.primitive).iterator();
                    break;
                }
                case 19: {
                    it = ((Polygon)this.primitive).iterator();
                    break;
                }
                default: {
                    return false;
                }
            }
            this.projectedPoint = (Point)this.primitive.toLines().closestPoints((Geometry)inputPoint)[0];
            Integer auxPosition = 0;
            Line auxLine = null;
            int idx = 0;
            if (it != null && it.hasNext()) {
                Point prevVertex = ((Point)it.next()).cloneGeometry();
                double distance = Double.POSITIVE_INFINITY;
                while (it.hasNext()) {
                    Point currentVertex = ((Point)it.next()).cloneGeometry();
                    Line tmpLine = GeometryUtils.createLine((Point)prevVertex, (Point)currentVertex, (int)geometry.getGeometryType().getSubType());
                    double d = tmpLine.distance((Geometry)this.projectedPoint);
                    if (d < distance) {
                        this.idxVertex = idx;
                        distance = d;
                        auxLine = tmpLine;
                    }
                    prevVertex = currentVertex;
                    ++idx;
                }
            }
            if (this.idxVertex != null) {
                this.line = auxLine;
                return true;
            }
        }
        catch (GeometryException | GeometryOperationException | GeometryOperationNotSupportedException ex) {
            return false;
        }
        return false;
    }

    private int primitiveNumVertices() {
        switch (this.primitive.getType()) {
            case 18: {
                return ((Line)this.primitive).getNumVertices();
            }
            case 19: {
                return ((Polygon)this.primitive).getNumVertices();
            }
        }
        return 0;
    }

    private Primitive getNearestPrimitive(Aggregate aggregate, Point point) throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (aggregate == null || point == null) {
            throw new IllegalArgumentException("Parameters should not be null");
        }
        double distance = Double.POSITIVE_INFINITY;
        Primitive nearestPrimitive = null;
        for (Geometry geometry : aggregate) {
            if (geometry instanceof Aggregate) {
                return this.getNearestPrimitive((Aggregate)geometry, point);
            }
            Primitive prim = (Primitive)geometry;
            double d = prim.distance((Geometry)point);
            if (!(d < distance)) continue;
            distance = d;
            nearestPrimitive = (Primitive)prim.cloneGeometry();
        }
        return nearestPrimitive;
    }

    public Integer getPosition() throws GeometryOperationNotSupportedException, GeometryOperationException {
        if (this.idxVertex != null) {
            if (this.primitive.getType() == 18 && this.primitiveNumVertices() == 2) {
                if (((Line)this.primitive).getVertex(0).distance((Geometry)this.projectedPoint) <= ((Line)this.primitive).getVertex(1).distance((Geometry)this.projectedPoint)) {
                    return 2;
                }
                return 0;
            }
            if (this.idxVertex == 0) {
                return 0;
            }
            if (this.idxVertex >= this.primitiveNumVertices() - 2) {
                return 2;
            }
            return 1;
        }
        return null;
    }

    public boolean isFilled() {
        return this.feature != null && this.primitive != null && this.projectedPoint != null && this.line != null && this.idxVertex != null;
    }
}

