/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.extendline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.cresques.cts.IProjection;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryException;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.aggregate.MultiCurve;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Line;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.fmap.geom.primitive.Primitive;
import org.gvsig.fmap.geom.type.GeometryType;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.vectorial.SpatialEvaluatorsFactory;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.evaluator.Evaluator;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.service.spi.ProviderServices;
import org.gvsig.vectorediting.lib.api.DrawingStatus;
import org.gvsig.vectorediting.lib.api.EditingServiceParameter;
import org.gvsig.vectorediting.lib.api.exceptions.DrawServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.FinishServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.InvalidEntryException;
import org.gvsig.vectorediting.lib.api.exceptions.StartServiceException;
import org.gvsig.vectorediting.lib.api.exceptions.StopServiceException;
import org.gvsig.vectorediting.lib.prov.extendline.operation.ExtendLineOperation;
import org.gvsig.vectorediting.lib.prov.extendline.operation.ExtendLineOperationUtils;
import org.gvsig.vectorediting.lib.spi.AbstractEditingProvider;
import org.gvsig.vectorediting.lib.spi.DefaultDrawingStatus;
import org.gvsig.vectorediting.lib.spi.DefaultEditingServiceParameter;
import org.gvsig.vectorediting.lib.spi.EditingProvider;
import org.gvsig.vectorediting.lib.spi.EditingProviderServices;

public class ExtendLineEditingProvider
extends AbstractEditingProvider
implements EditingProvider {
    private final int TOLERANCE_PIXELS = 3;
    private Point insertedPoint;
    private final EditingServiceParameter selectionParameter;
    private final EditingServiceParameter geometryToExtendToParameter;
    protected Map<EditingServiceParameter, Object> values;
    private final FeatureStore featureStore;
    private final MapContext mapContext;

    public ExtendLineEditingProvider(ProviderServices services, DynObject parameters) {
        super(services);
        this.featureStore = (FeatureStore)parameters.getDynValue("featureStore");
        this.mapContext = (MapContext)parameters.getDynValue("mapContext");
        this.selectionParameter = new DefaultEditingServiceParameter("selection", "selection", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.SELECTION});
        this.geometryToExtendToParameter = new DefaultEditingServiceParameter("geometry_to_extend_to", "geometry_to_extend_to", new EditingServiceParameter.TYPE[]{EditingServiceParameter.TYPE.POSITION});
    }

    public EditingServiceParameter next() {
        if (this.values.get(this.selectionParameter) == null) {
            return this.selectionParameter;
        }
        if (this.values.get(this.geometryToExtendToParameter) == null) {
            return this.geometryToExtendToParameter;
        }
        return null;
    }

    public DrawingStatus getDrawingStatus(Point mousePosition) throws DrawServiceException {
        FeatureSelection selection = (FeatureSelection)this.values.get(this.selectionParameter);
        if (selection != null) {
            DefaultDrawingStatus drawingStatus = new DefaultDrawingStatus();
            return drawingStatus;
        }
        return null;
    }

    private boolean isClosed(Curve curve) {
        Point lastPoint;
        Point firstPoint;
        Arc arc;
        return curve instanceof Arc ? (arc = (Arc)curve).getInitPoint().equals(arc.getEndPoint()) : curve instanceof Curve && (firstPoint = curve.getVertex(0)).equals(lastPoint = curve.getVertex(curve.getNumVertices() - 1));
    }

    private Curve extendLine(Point mousePosition, Curve curve, Geometry boundaryGeometry) throws GeometryOperationNotSupportedException, GeometryOperationException, DataException, GeometryException {
        ExtendLineOperation operation = ExtendLineOperationUtils.getOperation((Primitive)curve);
        return operation.extendLine(curve, mousePosition, boundaryGeometry);
    }

    public void stop() throws StopServiceException {
        this.values.clear();
    }

    public List<EditingServiceParameter> getParameters() {
        ArrayList<EditingServiceParameter> parameters = new ArrayList<EditingServiceParameter>();
        parameters.add(this.selectionParameter);
        parameters.add(this.geometryToExtendToParameter);
        return parameters;
    }

    public void setValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        this.validateAndInsertValue(parameter, value);
    }

    public void setValue(Object value) throws InvalidEntryException {
        EditingServiceParameter parameter = this.next();
        this.validateAndInsertValue(parameter, value);
    }

    private void validateAndInsertValue(EditingServiceParameter parameter, Object value) throws InvalidEntryException {
        Point point;
        Geometry geometry;
        if (parameter == this.selectionParameter) {
            FeatureSelection featureSelection;
            if (value instanceof FeatureSelection && (featureSelection = (FeatureSelection)value).getSelectedCount() > 0L) {
                try {
                    featureSelection.accept(obj -> {
                        Feature feature = (Feature)obj;
                        Geometry geometry = feature.getDefaultGeometry();
                        if (!this.isValidGeometryToSelect(geometry)) {
                            throw new InvalidEntryException(null);
                        }
                    });
                    this.values.put(parameter, featureSelection);
                    return;
                }
                catch (BaseException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
        } else if (parameter == this.geometryToExtendToParameter && value instanceof Point && (geometry = this.getGeometry(point = (Point)value)) != null) {
            this.values.put(parameter, geometry);
            this.insertedPoint = point;
            return;
        }
        throw new InvalidEntryException(null);
    }

    private boolean isValidGeometryToSelect(Geometry geometry) {
        GeometryType geoType = geometry.getGeometryType();
        if (!geoType.isTypeOf(2) && !geoType.isTypeOf(8)) {
            return false;
        }
        if (geoType.isTypeOf(2)) {
            if (geometry instanceof Line) {
                Line line = (Line)geometry;
                return !line.isClosed();
            }
            if (geometry instanceof Arc) {
                Arc arc = (Arc)geometry;
                return !arc.getInitPoint().equals(arc.getEndPoint());
            }
            return false;
        }
        if (geoType.isTypeOf(8)) {
            MultiCurve multiCurve = (MultiCurve)geometry;
            for (Geometry geom : multiCurve) {
                if (this.isValidGeometryToSelect(geom)) continue;
                return false;
            }
        }
        return true;
    }

    private Geometry getGeometry(Point point) {
        EditingProviderServices editingProviderServices = this.getProviderServices();
        Geometry geometry = editingProviderServices.getGeometryOfVisibleLayers(point, this.featureStore, this.mapContext);
        return geometry;
    }

    private FeatureSet getGeometryByBuffer(Geometry buffer) throws DataException {
        FeatureQuery queryByGeometry = this.featureStore.createFeatureQuery();
        IProjection defaultSRS = this.featureStore.getDefaultFeatureType().getDefaultSRS();
        Evaluator iee = SpatialEvaluatorsFactory.getInstance().intersects(buffer, defaultSRS, this.featureStore);
        queryByGeometry.setFilter(iee);
        queryByGeometry.setAttributeNames(null);
        return this.featureStore.getFeatureSet(queryByGeometry);
    }

    public Geometry finish() throws FinishServiceException {
        return null;
    }

    public void finishAndStore() throws FinishServiceException {
        FeatureSelection selection = (FeatureSelection)this.values.get(this.selectionParameter);
        Geometry geometryToExtendTo = (Geometry)this.values.get(this.geometryToExtendToParameter);
        if (selection != null && geometryToExtendTo != null) {
            try {
                selection.accept(obj -> {
                    Feature feature = (Feature)obj;
                    Geometry geometry = feature.getDefaultGeometry();
                    EditableFeature eFeature = feature.getEditable();
                    if (geometry instanceof MultiCurve) {
                        MultiCurve extendedMultiCurve = this.createMultiCurve(geometry);
                        MultiCurve multiCurve = (MultiCurve)geometry;
                        for (int i = 0; i < multiCurve.getPrimitivesNumber(); ++i) {
                            Curve curve = multiCurve.getCurveAt(i);
                            Curve extendedCurve = this.extendLine(this.insertedPoint, curve, geometryToExtendTo);
                            extendedMultiCurve.addCurve(extendedCurve);
                        }
                        eFeature.setDefaultGeometry((Geometry)extendedMultiCurve);
                    } else if (geometry instanceof Curve) {
                        Curve extendedCurve = this.extendLine(this.insertedPoint, (Curve)geometry, geometryToExtendTo);
                        eFeature.setDefaultGeometry((Geometry)extendedCurve);
                    }
                    selection.update(eFeature);
                });
            }
            catch (BaseException e) {
                throw new FinishServiceException((Throwable)e);
            }
        }
    }

    private MultiCurve createMultiCurve(Geometry geometry) throws FinishServiceException {
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        int subtype = geometry.getGeometryType().getSubType();
        MultiCurve extendedMultiCurve = null;
        try {
            extendedMultiCurve = geoManager.createMultiCurve(subtype);
        }
        catch (GeometryException e) {
            throw new FinishServiceException((Throwable)e);
        }
        return extendedMultiCurve;
    }

    public void start() throws StartServiceException, InvalidEntryException {
        this.values = new HashMap<EditingServiceParameter, Object>();
        FeatureSelection selected = null;
        if (this.featureStore != null && this.values.get(this.selectionParameter) == null) {
            try {
                selected = this.featureStore.getFeatureSelection();
            }
            catch (DataException e) {
                throw new StartServiceException((Throwable)e);
            }
            if (selected.getSelectedCount() > 0L) {
                try {
                    this.setValue(selected);
                }
                catch (InvalidEntryException e) {
                    throw new InvalidEntryException((Throwable)e);
                }
            }
        }
    }

    public String getName() {
        return "modify-extend-line";
    }

    public Object getValue(EditingServiceParameter parameter) {
        return this.values != null ? this.values.get(parameter) : null;
    }
}

