/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vectorediting.lib.prov.extendline.operation;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Arc;
import org.gvsig.fmap.geom.primitive.Curve;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.vectorediting.lib.prov.extendline.operation.ExtendLineOperation;
import org.gvsig.vectorediting.lib.prov.extendline.operation.ExtendLineOperationUtils;

public class ArcExtendLineOperation
implements ExtendLineOperation {
    @Override
    public Curve extendLine(Curve lineToExtend, Point insertedPoint, FeatureSelection boundaryObjects) throws GeometryOperationNotSupportedException, GeometryOperationException, DataException, CreateGeometryException {
        Arc arcToBeExtend = (Arc)lineToExtend;
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        int subtype = lineToExtend.getGeometryType().getSubType();
        Arc extendedArc = (Arc)geoManager.create(12, subtype);
        Point startVertex = arcToBeExtend.getInitPoint();
        Point endVertex = arcToBeExtend.getEndPoint();
        Point startIntersectionPoint = null;
        Point endIntersectionPoint = null;
        if (insertedPoint.distance((Geometry)startVertex) < insertedPoint.distance((Geometry)endVertex)) {
            startIntersectionPoint = ExtendLineOperationUtils.arcIntersection(arcToBeExtend, "start", boundaryObjects);
        } else {
            endIntersectionPoint = ExtendLineOperationUtils.arcIntersection(arcToBeExtend, "end", boundaryObjects);
        }
        if (startIntersectionPoint == null) {
            startIntersectionPoint = arcToBeExtend.getInitPoint();
        }
        if (endIntersectionPoint == null) {
            endIntersectionPoint = arcToBeExtend.getEndPoint();
        }
        Point center = arcToBeExtend.getCenterPoint();
        double radius = center.distance((Geometry)arcToBeExtend.getInitPoint());
        double startAngle = GeometryUtils.calculateAngle((Point)center, (Point)startIntersectionPoint);
        double endAngle = GeometryUtils.calculateAngle((Point)center, (Point)endIntersectionPoint);
        extendedArc.setPointsStartEnd(center, radius, startAngle, endAngle);
        return extendedArc;
    }

    @Override
    public Curve extendLine(Curve lineToExtend, Point insertedPoint, Geometry boundaryObject) throws GeometryOperationNotSupportedException, GeometryOperationException, DataException, CreateGeometryException {
        Arc arcToBeExtend = (Arc)lineToExtend;
        GeometryManager geoManager = GeometryLocator.getGeometryManager();
        int subtype = lineToExtend.getGeometryType().getSubType();
        Arc extendedArc = (Arc)geoManager.create(12, subtype);
        Point startVertex = arcToBeExtend.getInitPoint();
        Point endVertex = arcToBeExtend.getEndPoint();
        Point midVertex = arcToBeExtend.getMiddlePoint();
        Point startIntersectionPoint = null;
        Point endIntersectionPoint = null;
        if (insertedPoint.distance((Geometry)startVertex) < insertedPoint.distance((Geometry)endVertex)) {
            startIntersectionPoint = ExtendLineOperationUtils.arcIntersection(arcToBeExtend, "start", boundaryObject);
        } else {
            endIntersectionPoint = ExtendLineOperationUtils.arcIntersection(arcToBeExtend, "end", boundaryObject);
        }
        if (startIntersectionPoint == null) {
            startIntersectionPoint = arcToBeExtend.getInitPoint();
        }
        if (endIntersectionPoint == null) {
            endIntersectionPoint = arcToBeExtend.getEndPoint();
        }
        extendedArc.setPoints(startIntersectionPoint, midVertex, endIntersectionPoint);
        return extendedArc;
    }
}

