/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.shp;

import java.awt.BorderLayout;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.preferences.AbstractPreferencePage;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.andami.preferences.StoreException;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataTypeUtils;
import org.gvsig.shp.DBFPreferencesPageView;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;

public class DBFPreferencesPage
extends AbstractPreferencePage
implements IPreference {
    public static String id = DBFPreferencesPage.class.getName();
    private DBFPreferencesPageView view;
    private boolean hasChanges;
    private ImageIcon icon;

    public DBFPreferencesPage() {
        this.setParentID("org.gvsig.app.gui.preferencespage.dal.DALPage");
        this.initComponents();
        this.initializeValues();
    }

    private void initComponents() {
        this.view = new DBFPreferencesPageView();
        this.translate();
        this.setLayout(new BorderLayout());
        this.add(this.view, "Center");
        this.view.chkAutodetectEncoding.addChangeListener(e -> {
            this.hasChanges = true;
        });
        this.view.spnAutodetectEncodingMaxRecords.addChangeListener(e -> {
            this.hasChanges = true;
        });
    }

    private void translate() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate((AbstractButton)this.view.chkAutodetectEncoding);
        toolsSwingManager.translate(this.view.lblAutodetectEncodingMaxRecords);
        toolsSwingManager.translate((JComponent)this.view.spnAutodetectEncodingMaxRecords);
    }

    public boolean isResizeable() {
        return true;
    }

    public void initializeValues() {
        DataManager dataManager = DALLocator.getDataManager();
        boolean autodetectCharset = DataTypeUtils.toBoolean((Object)dataManager.getProperty("dbf_AutodetectEncoding"), (boolean)false);
        int autodetectCharsetMaxRecords = DataTypeUtils.toInteger((Object)dataManager.getProperty("dbf_AutodetectEncodingMaxRecords"), (int)1000);
        this.view.chkAutodetectEncoding.setSelected(autodetectCharset);
        this.view.spnAutodetectEncodingMaxRecords.setValue(autodetectCharsetMaxRecords);
    }

    public String getID() {
        return id;
    }

    public String getTitle() {
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        return i18nManager.getTranslation("_DBF_provider");
    }

    public JPanel getPanel() {
        return this;
    }

    public void storeValues() throws StoreException {
        DataManager dataManager = DALLocator.getDataManager();
        dataManager.setProperty("dbf_AutodetectEncoding", (Object)this.view.chkAutodetectEncoding.isSelected());
        dataManager.setProperty("dbf_AutodetectEncodingMaxRecords", (Object)((Number)this.view.spnAutodetectEncodingMaxRecords.getValue()).longValue());
    }

    public void initializeDefaults() {
        this.view.chkAutodetectEncoding.setSelected(false);
        this.view.spnAutodetectEncodingMaxRecords.setValue(1000);
    }

    public ImageIcon getIcon() {
        if (this.icon == null) {
            this.icon = IconThemeHelper.getImageIcon((String)"preferences-dbfprovider");
        }
        return this.icon;
    }

    public boolean isValueChanged() {
        return this.hasChanges;
    }

    public void setChangesApplied() {
        this.hasChanges = true;
    }

    private void translateAll() {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

