/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.shp;

import java.util.ArrayList;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginsLocator;
import org.gvsig.andami.PluginsManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.andami.preferences.IPreferenceExtension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.view.ViewDocument;
import org.gvsig.app.project.documents.view.ViewManager;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataStore;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.operations.SingleLayer;
import org.gvsig.shp.DBFPreferencesPage;
import org.gvsig.tools.dynobject.DynObject;
import org.gvsig.tools.dynobject.exception.DynMethodNotSupportedException;

public class SHPExtension
extends Extension
implements IPreferenceExtension {
    public void initialize() {
        IconThemeHelper.registerIcon((String)"preferences", (String)"preferences-dbfprovider", (Object)((Object)this));
    }

    public void postInitialize() {
        this.loadDBFPreferences();
        PluginsManager pluginsManager = PluginsLocator.getPluginsManager();
        pluginsManager.addShutdownTask("SaveDBFPreferences", this::saveDBFPreferences, false, 0);
    }

    private void saveDBFPreferences() {
        DynObject props = this.getPlugin().getPluginProperties();
        DataManager dataManager = DALLocator.getDataManager();
        props.setDynValue("dbf_AutodetectEncoding", dataManager.getProperty("dbf_AutodetectEncoding"));
        props.setDynValue("dbf_AutodetectEncodingMaxRecords", dataManager.getProperty("dbf_AutodetectEncodingMaxRecords"));
    }

    private void loadDBFPreferences() {
        DynObject props = this.getPlugin().getPluginProperties();
        DataManager dataManager = DALLocator.getDataManager();
        dataManager.setProperty("dbf_AutodetectEncoding", props.getDynValue("dbf_AutodetectEncoding"));
        dataManager.setProperty("dbf_AutodetectEncodingMaxRecords", props.getDynValue("dbf_AutodetectEncodingMaxRecords"));
    }

    public void execute(String actionCommand) {
        FLayer[] layers = this.getActiveLayers();
        if (layers == null) {
            return;
        }
        ArrayList<FLayer> problems = new ArrayList<FLayer>();
        for (FLayer layer : layers) {
            if (!(layer instanceof SingleLayer)) continue;
            DataStore ds = ((SingleLayer)layer).getDataStore();
            try {
                ds.invokeDynMethod("saveEncoding", null);
            }
            catch (DynMethodNotSupportedException dynMethodNotSupportedException) {
            }
            catch (Throwable ex) {
                logger.warn("Can't save encoding of layer '" + layer.getName() + "'.", ex);
                problems.add(layer);
            }
        }
        if (!problems.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            builder.append("\n");
            for (FLayer problem : problems) {
                builder.append("- ").append(problem.getName()).append("\n");
            }
            ApplicationManager application = ApplicationLocator.getManager();
            application.messageDialog("_There_have_been_problems_saving_the_encoding_of_the_following_layers:", new String[]{builder.toString()}, "_Problems_saving_encoding_of_layer", 2, "_Problems_saving_encoding_of_layer");
        }
    }

    public boolean isEnabled() {
        FLayer[] layers = this.getActiveLayers();
        if (layers == null) {
            return false;
        }
        for (FLayer layer : layers) {
            try {
                DataStore ds;
                if (!(layer instanceof SingleLayer) || !(ds = ((SingleLayer)layer).getDataStore()).hasDynMethod("saveEncoding")) continue;
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isVisible() {
        FLayer[] layers = this.getActiveLayers();
        if (layers == null) {
            return false;
        }
        for (FLayer layer : layers) {
            try {
                if (!(layer instanceof SingleLayer)) continue;
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private FLayer[] getActiveLayers() {
        ApplicationManager application = ApplicationLocator.getManager();
        ViewDocument viewdoc = (ViewDocument)application.getActiveDocument(ViewManager.TYPENAME);
        if (viewdoc == null) {
            return null;
        }
        MapContext map = viewdoc.getMapContext();
        if (!map.hasActiveLayers()) {
            return null;
        }
        FLayer[] layers = viewdoc.getMapContext().getLayers().getActives();
        return layers;
    }

    public IPreference[] getPreferencesPages() {
        return new IPreference[]{new DBFPreferencesPage()};
    }
}

