/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.exportto.kml.service;

import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.cresques.cts.ICoordTrans;
import org.cresques.cts.IProjection;
import org.gvsig.export.ExportException;
import org.gvsig.export.ExportParameters;
import org.gvsig.export.spi.AbstractExportService;
import org.gvsig.export.spi.ExportService;
import org.gvsig.export.spi.ExportServiceFactory;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataServerExplorer;
import org.gvsig.fmap.dal.NewDataStoreParameters;
import org.gvsig.fmap.dal.OpenDataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.OpenFeatureStoreParameters;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContextException;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.IVectorLegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gpe.exportto.generic.util.CoordinatesSequenceBbox;
import org.gvsig.gpe.exportto.generic.util.GeometryToGPEWriter;
import org.gvsig.gpe.exportto.kml.service.ExportKMLParameters;
import org.gvsig.gpe.exportto.kml.style.KmlStyle;
import org.gvsig.gpe.exportto.kml.style.StyleUtils;
import org.gvsig.gpe.lib.api.GPELocator;
import org.gvsig.gpe.lib.api.writer.ICoordinateSequence;
import org.gvsig.gpe.lib.api.writer.IGPEWriterHandler;
import org.gvsig.gpe.lib.api.writer.IGPEWriterHandlerImplementor;
import org.gvsig.gpe.prov.kml.utils.Kml2_1_Tags;
import org.gvsig.gpe.prov.kml.writer.GPEKmlWriterHandlerImplementor;
import org.gvsig.tools.dispose.DisposableIterator;
import org.gvsig.tools.locator.LocatorException;
import org.gvsig.tools.util.HasAFile;
import org.gvsig.xmlpull.lib.api.stream.IXmlStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportKMLService
extends AbstractExportService
implements ExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportKMLService.class);

    ExportKMLService(ExportServiceFactory factory, ExportParameters parameters) {
        super(factory, parameters);
    }

    protected DataServerExplorer createServerExplorer() throws ExportException {
        return null;
    }

    protected NewDataStoreParameters createTargetNewStoreParameters() throws ExportException {
        return null;
    }

    protected OpenDataStoreParameters createTargetOpenStoreParameters() throws ExportException {
        try {
            DataManager dataManager = DALLocator.getDataManager();
            OpenFeatureStoreParameters openStoreParameters = (OpenFeatureStoreParameters)dataManager.createStoreParameters("KML");
            ((HasAFile)openStoreParameters).setFile(this.getParameters().getEvaluatedFile());
            openStoreParameters.setDynValue("CRS", (Object)this.getParameters().getTargetProjection());
            return openStoreParameters;
        }
        catch (DataException ex) {
            return null;
        }
    }

    public ExportKMLParameters getParameters() {
        return (ExportKMLParameters)super.getParameters();
    }

    public void export(FeatureSet featureSet) throws ExportException {
        File outFile = this.getParameters().getEvaluatedFile();
        FeatureSet featureStore = featureSet;
        FLyrVect vectorLayer = null;
        String mimeType = this.getParameters().getMimeType();
        ArrayList<ICoordTrans> transfList = new ArrayList<ICoordTrans>();
        ICoordTrans ct = this.getParameters().getSourceTransformation();
        IProjection targetproj = this.getParameters().getTargetProjection();
        if (ct == null) {
            if (targetproj == null) {
                targetproj = this.getParameters().getSourceProjection();
            }
            ct = this.getParameters().getSourceProjection().getCT(targetproj);
            transfList.add(ct);
        } else {
            targetproj = ct.getPDest();
            transfList.add(ct);
        }
        String srs = targetproj.getAbrev();
        String[] fldNames = null;
        Envelope env = null;
        long count = 0L;
        try {
            count = featureSet.getSize();
            this.getTaskStatus().setRangeOfValues(0L, count);
            FeatureType ftype = this.getParameters().getExportAttributes().isActive() ? this.getParameters().getExportAttributes().getTargetFeatureType() : featureStore.getDefaultFeatureType();
            fldNames = this.getAttributes(ftype);
            env = GeometryLocator.getGeometryManager().createEnvelope(0);
            this.initEnvelope(env, featureSet);
        }
        catch (DataException | CreateEnvelopeException | LocatorException e) {
            throw new ExportException(e);
        }
        try {
            env = this.reproject(env, transfList);
        }
        catch (CreateEnvelopeException ex) {
            throw new ExportException((Throwable)ex);
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(env.getMinimum(0), env.getMinimum(1), env.getLength(0), env.getLength(1));
        File fixedFile = outFile;
        try {
            if (!outFile.getAbsolutePath().toLowerCase().endsWith("." + this.getFileExtension().toLowerCase())) {
                fixedFile = new File(outFile.getAbsolutePath() + "." + this.getFileExtension());
            }
            IGPEWriterHandler wh = GPELocator.getGPEManager().createWriterByMimeType(mimeType);
            FileOutputStream fos = new FileOutputStream(fixedFile);
            wh.setOutputStream((OutputStream)fos);
            wh.initialize();
            wh.startLayer(null, null, fixedFile.getName(), null, srs);
            Map<ISymbol, KmlStyle> symsty = null;
            IXmlStreamWriter xmlw = this.getXmlStreamWriter(wh);
            if (xmlw != null && vectorLayer instanceof FLyrVect) {
                symsty = StyleUtils.getSymbolStyles(vectorLayer, featureSet, fldNames);
                for (KmlStyle sty : symsty.values()) {
                    this.writeStyle(xmlw, sty);
                }
            }
            wh.startBbox(null, (ICoordinateSequence)new CoordinatesSequenceBbox((Rectangle2D)rect), srs);
            wh.endBbox();
            IVectorLegend legend = vectorLayer instanceof FLyrVect ? (IVectorLegend)vectorLayer.getLegend() : null;
            this.writeFeatures(wh, xmlw, featureSet, fldNames, symsty, legend, transfList);
            wh.endLayer();
            wh.close();
            fos.close();
        }
        catch (Exception exc) {
            throw new ExportException((Throwable)exc);
        }
        this.getTaskStatus().setCurValue(count);
        this.getTaskStatus().terminate();
        this.getTaskStatus().remove();
    }

    private String[] getAttributes(FeatureType ftype) {
        FeatureAttributeDescriptor[] atts = ftype.getAttributeDescriptors();
        ArrayList<String> list = new ArrayList<String>();
        for (FeatureAttributeDescriptor att : atts) {
            FeatureAttributeDescriptor desc = att;
            if (desc.getDataType().getType() == 66) continue;
            list.add(desc.getName());
        }
        return list.toArray(new String[0]);
    }

    private Geometry reproject(Geometry geom, List<ICoordTrans> transfList) {
        int sz = transfList.size();
        if (sz == 0) {
            return geom;
        }
        Geometry resp = geom.cloneGeometry();
        for (int i = 0; i < sz; ++i) {
            resp.reProject(transfList.get(i));
        }
        return resp;
    }

    public String getFileExtension() {
        return "kml";
    }

    private void writeStyle(IXmlStreamWriter xmlw, KmlStyle sty) throws IOException {
        xmlw.writeStartElement(Kml2_1_Tags.STYLE);
        xmlw.writeStartAttribute(Kml2_1_Tags.ID);
        xmlw.writeValue(sty.getId());
        xmlw.writeEndAttributes();
        sty.writeXml(xmlw);
        xmlw.writeEndElement();
    }

    private IXmlStreamWriter getXmlStreamWriter(IGPEWriterHandler wh) {
        IGPEWriterHandlerImplementor imple = wh.getImplementor();
        if (!(imple instanceof GPEKmlWriterHandlerImplementor)) {
            return null;
        }
        GPEKmlWriterHandlerImplementor kmlimple = (GPEKmlWriterHandlerImplementor)imple;
        IXmlStreamWriter xmlw = kmlimple.getXMLStreamWriter();
        return xmlw;
    }

    private void writeFeatures(IGPEWriterHandler gwh, IXmlStreamWriter xmlw, FeatureSet fset, String[] fieldNames, Map<ISymbol, KmlStyle> symsty, IVectorLegend lege, List<ICoordTrans> transfList) throws Exception {
        GeometryToGPEWriter gw = new GeometryToGPEWriter(gwh);
        DisposableIterator diter = fset.fastIterator();
        long count = 0L;
        this.getTaskStatus().setCurValue(count);
        ISymbol sym = null;
        int nullGeometries = 0;
        while (diter.hasNext()) {
            KmlStyle kmlStyle;
            Feature feat = (Feature)diter.next();
            try {
                if (lege instanceof IVectorLegend) {
                    sym = lege.getSymbolByFeature(feat);
                }
            }
            catch (MapContextException mce) {
                LOGGER.info("While getting legend symbol.", (Throwable)mce);
            }
            try {
                kmlStyle = symsty.get(sym);
            }
            catch (Exception e) {
                kmlStyle = null;
            }
            if (!this.writeFeature(feat, gwh, xmlw, gw, count, fieldNames, kmlStyle, transfList)) {
                ++nullGeometries;
            }
            this.getTaskStatus().setCurValue(++count);
        }
        if (nullGeometries > 0) {
            LOGGER.warn("Can't export " + nullGeometries + " features because source geometries are null.");
        }
        diter.dispose();
    }

    private boolean writeFeature(Feature feat, IGPEWriterHandler gwh, IXmlStreamWriter xmlw, GeometryToGPEWriter gw, long index, String[] fieldNames, KmlStyle ksty, List<ICoordTrans> transfList) throws IOException {
        Geometry geom = feat.getDefaultGeometry();
        if (geom == null) {
            return false;
        }
        String strindex = String.valueOf(index);
        if (this.getParameters().getUseLabels()) {
            String lbl = this.getLabelForFeature(feat);
            gwh.startFeature(strindex, "FEATURE", lbl);
        } else {
            gwh.startFeature(strindex, "FEATURE", "");
        }
        if (ksty != null) {
            xmlw.writeStartElement(Kml2_1_Tags.STYLEURL);
            xmlw.writeValue("#" + ksty.getId());
            xmlw.writeEndElement();
        }
        this.writeBalloon(xmlw, feat, fieldNames);
        geom = this.reproject(geom, transfList);
        gw.writeGeometry(geom, this.getParameters().getUseLabels());
        for (String fieldName : fieldNames) {
            Object val = feat.get(fieldName);
            String fldname = fieldName.replace(' ', '_');
            gwh.startElement("", fldname, (Object)(val == null ? "" : val.toString()));
            gwh.endElement();
        }
        gwh.endFeature();
        return true;
    }

    private String getLabelForFeature(Feature feat) {
        return "";
    }

    private void writeBalloon(IXmlStreamWriter xmlw, Feature feat, String[] fieldNames) throws IOException {
        xmlw.writeStartElement(Kml2_1_Tags.EXTENDED_DATA);
        for (String fieldName : fieldNames) {
            String fldrep = fieldName.replace(' ', '_');
            xmlw.writeStartElement(Kml2_1_Tags.DATA);
            xmlw.writeStartAttribute(null, "name");
            xmlw.writeValue(fldrep);
            xmlw.writeEndAttributes();
            xmlw.writeStartElement(Kml2_1_Tags.VALUE);
            Object val = feat.get(fieldName);
            xmlw.writeValue(val == null ? "" : val.toString());
            xmlw.writeEndElement();
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
    }

    private Envelope reproject(Envelope env, List<ICoordTrans> transfList) throws CreateEnvelopeException {
        int sz = transfList.size();
        if (sz == 0) {
            return env;
        }
        Envelope resp = env;
        try {
            for (int i = 0; i < sz; ++i) {
                resp = resp.convert(transfList.get(i));
            }
        }
        catch (Exception exc) {
            double[] max;
            double[] min;
            GeometryManager gm = GeometryLocator.getGeometryManager();
            IProjection targetproj = this.getParameters().getTargetProjection();
            if (targetproj.isProjected()) {
                min = new double[]{-2.0E7, -2.0E7};
                max = new double[]{2.0E7, 2.0E7};
            } else {
                min = new double[]{-180.0, -90.0};
                max = new double[]{180.0, 90.0};
            }
            resp = gm.createEnvelope(min[0], min[1], max[0], max[1], 0);
        }
        return resp;
    }

    private void initEnvelope(Envelope env, FeatureSet featureSet) {
        for (Feature feature : featureSet) {
            Geometry geometry = feature.getDefaultGeometry();
            if (geometry == null || !geometry.isValid()) continue;
            env.add(geometry);
        }
    }
}

