/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.gpe.exportto.kml.swing.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.gvsig.gpe.lib.api.writer.IGPEWriterHandler;
import org.gvsig.gpe.lib.spi.GPEProviderLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KMLPanelView
extends JPanel {
    private static final long serialVersionUID = -3278172717881233447L;
    private static final Logger LOG = LoggerFactory.getLogger(KMLPanelView.class);
    private final boolean offerLabels = false;
    private JCheckBox labelsChk = null;
    private JCheckBox reproChk = null;
    private JComboBox versionCombo = null;
    I18nManager i18n = ToolsLocator.getI18nManager();

    public KMLPanelView() {
        this.initializePanel();
    }

    protected void initializePanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.createPanel(), "Center");
    }

    private JPanel createPanel() {
        JPanel jpanel1 = new JPanel();
        jpanel1.setLayout(new BorderLayout());
        FlowLayout fl = new FlowLayout(0);
        JPanel topPanel = new JPanel(fl);
        JPanel gridPanel = new JPanel();
        gridPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(3, 3, 3, 3);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gridPanel.add((Component)new JLabel(this.i18n.getTranslation("kml_Choose_KML_version")), gbc);
        gbc.gridx = 3;
        gbc.gridwidth = 3;
        gridPanel.add((Component)this.getVersionsCombo(), gbc);
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.gridwidth = 1;
        this.getLabelsCheckbox(false);
        gbc.gridx = 1;
        gbc.gridwidth = 5;
        JLabel lbl_lbl = new JLabel(this.i18n.getTranslation("kml_Use_labels_Label_point_will_be_added_to_non_points"));
        lbl_lbl.setEnabled(false);
        topPanel.add(gridPanel);
        jpanel1.add((Component)topPanel, "North");
        return jpanel1;
    }

    public String getMimeType() {
        Object obj = this.getVersionsCombo().getSelectedItem();
        if (obj instanceof FormatListItem) {
            return ((FormatListItem)obj).getLongFormat();
        }
        return null;
    }

    public boolean getUseLabels() {
        return this.labelsChk.isSelected();
    }

    public boolean getReprojectTo4326() {
        return this.reproChk.isSelected();
    }

    private JCheckBox getLabelsCheckbox(boolean enabled) {
        if (this.labelsChk == null) {
            this.labelsChk = new JCheckBox("");
            this.labelsChk.setSelected(false);
            this.labelsChk.setEnabled(enabled);
        }
        return this.labelsChk;
    }

    private JCheckBox getReproCheckbox(boolean enabled) {
        if (this.reproChk == null) {
            this.reproChk = new JCheckBox("");
            this.reproChk.setSelected(true);
            this.reproChk.setEnabled(enabled);
        }
        return this.reproChk;
    }

    private JComboBox getVersionsCombo() {
        if (this.versionCombo == null) {
            this.versionCombo = new JComboBox();
            ArrayList list = GPEProviderLocator.getGPEProviderManager().getWriterHandlerByFormat("kml");
            for (int i = 0; i < list.size(); ++i) {
                IGPEWriterHandler item = (IGPEWriterHandler)list.get(i);
                String longn = item.getFormat();
                String shortn = this.getShortWithVersion(longn);
                if (longn == null || shortn == null) continue;
                this.versionCombo.addItem(new FormatListItem(longn, shortn));
            }
        }
        return this.versionCombo;
    }

    public String getPanelTitle() {
        return this.i18n.getTranslation("kml_KML_options");
    }

    public boolean isValidPanel() {
        return this.getLongFormat() != null;
    }

    private String getShortWithVersion(String fmt) {
        if (fmt == null) {
            return null;
        }
        String[] parts = fmt.split(";");
        if (parts.length <= 1) {
            return null;
        }
        String aux = parts[1].trim();
        parts = aux.split("=");
        if (parts.length > 1) {
            aux = parts[1].trim();
            aux = aux.replaceAll("/", " ");
            return aux.toUpperCase();
        }
        return null;
    }

    public void enterPanel() {
    }

    public JComponent asJComponent() {
        return this;
    }

    public String getLongFormat() {
        Object obj = this.getVersionsCombo().getSelectedItem();
        if (obj instanceof FormatListItem) {
            return ((FormatListItem)obj).getLongFormat();
        }
        return null;
    }

    public boolean useLabels() {
        return this.getLabelsCheckbox(false).isSelected();
    }

    public boolean useBalloons() {
        return true;
    }

    public boolean mustReprojectToEpsg4326() {
        return this.getReproCheckbox(true).isSelected();
    }

    public class FormatListItem {
        private String longName = "";
        private String shortName = "";

        public FormatListItem(String longname, String shortname) {
            this.longName = longname;
            this.shortName = shortname;
        }

        public String toString() {
            return this.shortName;
        }

        public String getLongFormat() {
            return this.longName;
        }
    }
}

