/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonValue;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.mutable.MutableObject;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.json.Json;
import org.gvsig.json.JsonObjectBuilder;
import org.gvsig.report.lib.api.Report;
import org.gvsig.report.lib.api.ReportConfig;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportLocator;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.report.lib.impl.DefaultReport;
import org.gvsig.tools.resourcesstorage.FilesResourcesStorage;
import org.gvsig.tools.resourcesstorage.ResourcesStorage;

public class DefaultReportConfig
implements ReportConfig {
    private String name;
    private String dataSetName;
    private String templateName;
    private String filterFieldPrefix;
    private String filterFieldTable;
    private String orderFields;
    private List<String> requiredFields;
    private ResourcesStorage reportResourcesStorage;
    private ReportDataSet dataset;
    private ReportServer server;
    private int layout;

    public void fromJSON(JsonObject json) {
        JsonArray arrayJson;
        this.name = json.getString("name", null);
        this.dataSetName = json.getString("dataSetName", null);
        this.templateName = json.getString("templateName", null);
        this.filterFieldPrefix = json.getString("filterFieldPrefix", null);
        this.filterFieldTable = json.getString("filterFieldTable", null);
        if (json.containsKey((Object)"FilesResourcesStorage") && !json.isNull("FilesResourcesStorage")) {
            arrayJson = json.getJsonArray("FilesResourcesStorage");
            FilesResourcesStorage storage = null;
            for (JsonValue jsonValue : arrayJson) {
                if (storage == null) {
                    storage = new FilesResourcesStorage(jsonValue.toString());
                    continue;
                }
                storage.getPaths().add(jsonValue.toString());
            }
            this.reportResourcesStorage = storage;
        } else {
            this.reportResourcesStorage = null;
        }
        this.dataset = null;
        this.server = null;
        this.orderFields = json.getString("orderFields", null);
        if (json.containsKey((Object)"requiredFields") && !json.isNull("requiredFields")) {
            arrayJson = json.getJsonArray("requiredFields");
            for (JsonValue jsonValue : arrayJson) {
                if (this.requiredFields == null) {
                    this.requiredFields = new ArrayList<String>();
                }
                this.requiredFields.add(Json.toObject((JsonValue)jsonValue).toString());
            }
        } else {
            this.requiredFields = null;
        }
    }

    public JsonObject toJSON() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("name", this.name);
        builder.add("dataSetName", this.getDataSetName());
        builder.add("templateName", this.templateName);
        if (this.filterFieldPrefix == null) {
            builder.addNull("filterFieldPrefix");
        } else {
            builder.add("filterFieldPrefix", this.filterFieldPrefix);
        }
        if (this.filterFieldTable == null) {
            builder.addNull("filterFieldTable");
        } else {
            builder.add("filterFieldTable", this.filterFieldTable);
        }
        if (this.reportResourcesStorage instanceof FilesResourcesStorage) {
            FilesResourcesStorage storage = (FilesResourcesStorage)this.reportResourcesStorage;
            org.gvsig.json.JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String path : storage.getPaths()) {
                arrayBuilder.add(path);
            }
            builder.add("FilesResourcesStorage", (JsonArrayBuilder)arrayBuilder);
        } else {
            builder.addNull("FilesResourcesStorage");
        }
        builder.add("orderFields", this.orderFields);
        if (this.requiredFields != null) {
            org.gvsig.json.JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String field : this.requiredFields) {
                arrayBuilder.add(field);
            }
            builder.add("requiredFields", (JsonArrayBuilder)arrayBuilder);
        } else {
            builder.addNull("requiredFields");
        }
        return builder.build();
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("name", (Object)this.name);
        builder.append("dataSetName", (Object)this.dataSetName);
        builder.append("templateName", (Object)this.templateName);
        builder.append("filterFieldPrefix", (Object)this.filterFieldPrefix);
        if (this.reportResourcesStorage instanceof FilesResourcesStorage) {
            FilesResourcesStorage storage = (FilesResourcesStorage)this.reportResourcesStorage;
            builder.append("reportResourcesStorage", storage.getPaths().toArray());
        }
        builder.append("orderFields", (Object)this.orderFields);
        builder.append("requiredFields", this.requiredFields.toArray());
        return builder.toString();
    }

    public String getName() {
        if (StringUtils.isBlank((CharSequence)this.name)) {
            if (StringUtils.isBlank((CharSequence)this.templateName)) {
                return this.getDataSetName();
            }
            return this.templateName;
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFilterFieldPrefix() {
        return this.filterFieldPrefix;
    }

    public String getFilterFieldTable() {
        return this.filterFieldTable;
    }

    public String getDataSetName() {
        if (StringUtils.isBlank((CharSequence)this.dataSetName)) {
            if (this.dataset == null) {
                return null;
            }
            return this.dataset.getName();
        }
        return this.dataSetName;
    }

    public void setDataSetName(String name) {
        this.dataSetName = name;
    }

    public String getReportTemplateName() {
        return this.templateName;
    }

    public void setReportTemplate(String templateName) {
        this.templateName = templateName;
    }

    public void setReportResourcesStorage(ResourcesStorage storage) {
        this.reportResourcesStorage = storage;
    }

    public boolean hasDataSet() {
        if (this.dataset != null) {
            return true;
        }
        return !StringUtils.isBlank((CharSequence)this.dataSetName);
    }

    private ReportServer getServer() {
        if (this.server == null) {
            this.server = ReportLocator.getReportManager().getDefaultServer();
        }
        return this.server;
    }

    public ReportDataSet getDataSet() {
        if (this.dataset == null) {
            DataManager dataManager;
            FeatureStore store;
            if (StringUtils.isBlank((CharSequence)this.dataSetName)) {
                return null;
            }
            this.dataset = this.getServer().getConfig().getDataset(this.dataSetName);
            if (this.dataset == null && (store = (FeatureStore)(dataManager = DALLocator.getDataManager()).getStoresRepository().getStore(this.dataSetName)) != null) {
                this.dataset = ReportLocator.getReportManager().createDataSet(store);
            }
            if (this.orderFields != null && !this.orderFields.isEmpty()) {
                FeatureQueryOrder dataOrder = this.dataset.getQuery().getOrder();
                dataOrder.clear();
                dataOrder.add(this.orderFields);
            }
            MutableObject mutableObject = new MutableObject();
        }
        return this.dataset;
    }

    public void setDataSet(ReportDataSet dataset) {
        this.dataset = dataset;
    }

    public ResourcesStorage getResources() {
        if (this.reportResourcesStorage != null) {
            return this.reportResourcesStorage;
        }
        return this.getDataSet().getStore().getResourcesStorage();
    }

    public ResourcesStorage.Resource getReportTemplateAsResource() {
        ResourcesStorage storage = this.getResources();
        ResourcesStorage.Resource resource = storage.getResource(this.templateName);
        return resource;
    }

    public InputStream getReportTemplateAsStream() {
        URL url = null;
        try {
            ResourcesStorage.Resource resource = this.getReportTemplateAsResource();
            url = resource.getURL();
            InputStream is = resource.asInputStream();
            if (is == null) {
                throw new RuntimeException("Can't access to report template '" + Objects.toString(url) + "'.");
            }
            return is;
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't access to report template '" + Objects.toString(url) + "'.", ex);
        }
    }

    public URL getReportTemplateAsURL() {
        ResourcesStorage.Resource resource = this.getReportTemplateAsResource();
        URL url = resource.getURL();
        return url;
    }

    public Report createReport() {
        DefaultReport r = new DefaultReport(this);
        return r;
    }

    public int getLayoutManager() {
        return this.layout;
    }

    public void setLayoutManager(int layout) {
        this.layout = layout;
    }

    public boolean isValid(MutableObject<String> message) {
        boolean valid = true;
        if (this.requiredFields != null && !this.requiredFields.isEmpty()) {
            FeatureType ft = this.getDataSet().getFeatureType();
            for (String requiredField : this.requiredFields) {
                if (ft.get(requiredField) != null) continue;
                if (message != null) {
                    message.setValue((Object)((String)message.getValue() + " Field not found: " + requiredField + "."));
                }
                valid = false;
            }
        }
        return valid;
    }
}

