/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionBuilder;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.expressionevaluator.SymbolTable;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.DataQuery;
import org.gvsig.fmap.dal.DataStoreParameters;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.expressionevaluator.FeatureSymbolTable;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureQueryOrder;
import org.gvsig.fmap.dal.feature.FeatureReference;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.serverexplorer.filesystem.FilesystemStoreParameters;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportServices;
import org.gvsig.report.lib.impl.DefaultSelectionOfFeatures;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.util.UnmodifiableBasicList64;
import org.gvsig.tools.util.UnmodifiableBasicList64Adapter;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;
import org.json.JSONArray;
import org.json.JSONObject;

public class DefaultReportDataSet
implements ReportDataSet {
    private final ReportServices services;
    private String name;
    private FeatureStore store;
    private String fullName;
    private File path;
    private int limit;
    private Expression filter;
    private boolean exposeGeometry;
    private final DefaultSelectionOfFeatures selectionOfFeatures;
    private FeatureQuery query;

    public DefaultReportDataSet(ReportServices services, String name, FeatureStore store) {
        this.services = services;
        this.name = name;
        this.store = store;
        this.selectionOfFeatures = new DefaultSelectionOfFeatures(this);
        if (store != null) {
            this.fullName = store.getFullName();
            DataStoreParameters parameters = this.store.getParameters();
            if (parameters instanceof FilesystemStoreParameters) {
                this.path = ((FilesystemStoreParameters)parameters).getFile();
            }
        }
        this.limit = -1;
        this.query = store.createFeatureQuery();
    }

    public DefaultReportDataSet(ReportServices services, String name, FeatureStore store, FeatureQuery query) {
        this(services, name, store);
        this.query = query == null ? store.createFeatureQuery() : query;
    }

    public DefaultReportDataSet(ReportServices services, JSONObject jsonDataSet) {
        this.services = services;
        this.selectionOfFeatures = new DefaultSelectionOfFeatures(this);
        this.name = jsonDataSet.getString("name");
        this.fullName = jsonDataSet.getString("fullName");
        this.limit = jsonDataSet.getInt("limit");
        if (jsonDataSet.has("filter")) {
            this.filter = ExpressionUtils.createExpression();
            this.filter.fromJSON(jsonDataSet.getString("filter"));
        } else {
            this.filter = null;
        }
        this.exposeGeometry = jsonDataSet.getBoolean("exposeGeometry");
        if (jsonDataSet.has("path")) {
            this.path = this.services.derelativizeFile(new File(jsonDataSet.getString("path")));
        }
        this.store = null;
        if (jsonDataSet.has("features")) {
            JSONArray jsonFeatures = jsonDataSet.getJSONArray("features");
            for (Object x : jsonFeatures) {
                String referenceCode = (String)x;
                this.selectionOfFeatures.add(referenceCode);
            }
        }
    }

    JSONObject toJSON() {
        JSONObject jsonDataSet = new JSONObject();
        jsonDataSet.put("name", (Object)this.name);
        jsonDataSet.put("limit", this.limit);
        jsonDataSet.put("filter", (Object)this.filter);
        jsonDataSet.put("fullName", (Object)this.fullName);
        jsonDataSet.put("exposeGeometry", this.exposeGeometry);
        if (this.path != null) {
            jsonDataSet.put("path", (Object)this.services.relativizeFile(this.path).getPath());
        }
        if (!this.selectionOfFeatures.isEmpty()) {
            JSONArray jsonFeatures = new JSONArray();
            int i = 0;
            while ((long)i < this.selectionOfFeatures.size64()) {
                FeatureReference reference = this.selectionOfFeatures.getReference(i);
                jsonFeatures.put((Object)reference.getCode());
                ++i;
            }
            jsonDataSet.put("features", (Object)jsonFeatures);
        }
        return jsonDataSet;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultReportDataSet)) {
            return false;
        }
        DefaultReportDataSet other = (DefaultReportDataSet)obj;
        if (this.store != other.store) {
            return false;
        }
        return StringUtils.equals((CharSequence)this.getName(), (CharSequence)other.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        try {
            FeatureAttributeDescriptor attr = this.getStore().getDefaultFeatureType().getDefaultGeometryAttribute();
            String geomType = attr.getGeomType().getName();
            return this.name + " (" + geomType + ")";
        }
        catch (Exception ex) {
            return this.name;
        }
    }

    public FeatureStore getStore() {
        DataStoreParameters parameters;
        if (this.store == null) {
            this.store = this.services.getFeatureStore((ReportDataSet)this);
        }
        if (this.store != null && (parameters = this.store.getParameters()) instanceof FilesystemStoreParameters) {
            this.path = ((FilesystemStoreParameters)parameters).getFile();
        }
        return this.store;
    }

    public FeatureType getFeatureType() {
        FeatureStore theStore = this.getStore();
        try {
            return theStore.getDefaultFeatureType();
        }
        catch (DataException ex) {
            return null;
        }
    }

    public boolean hasThisStore(FeatureStore store) {
        if (store == null) {
            return false;
        }
        if (this.path != null) {
            try {
                DataStoreParameters parameters = store.getParameters();
                if (parameters instanceof FilesystemStoreParameters) {
                    File thePath = ((FilesystemStoreParameters)parameters).getFile();
                    if (this.path.getCanonicalPath().equals(thePath.getCanonicalPath())) {
                        return true;
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return StringUtils.equals((CharSequence)this.fullName, (CharSequence)store.getFullName());
    }

    public void accept(Visitor visitor) {
        this.accept(visitor, (Expression)null, null, true);
    }

    public void accept(Visitor visitor, Expression filter) {
        this.accept(visitor, filter, null, true);
    }

    public void accept(Visitor visitor, String filter, String sortfields, boolean ascending) {
        this.accept(visitor, ExpressionUtils.createExpression((String)filter), sortfields, ascending);
    }

    public void accept(final Visitor visitor, final Expression filter, String sortfields, boolean ascending) {
        try {
            if (this.selectionOfFeatures.isEmpty()) {
                FeatureQuery dataQuery = this.getQuery();
                if (filter != null) {
                    dataQuery.addFilter(filter);
                    dataQuery.retrievesAllAttributes();
                }
                if (!StringUtils.isEmpty((CharSequence)sortfields)) {
                    FeatureQueryOrder order = dataQuery.getOrder();
                    for (String field : StringUtils.split((String)sortfields, (char)',')) {
                        order.add(field, ascending);
                    }
                }
                FeatureStore st = this.getStore();
                st.accept(visitor, (DataQuery)dataQuery);
                return;
            }
            if (filter == null) {
                this.selectionOfFeatures.accept(visitor);
                return;
            }
            DataManager manager = DALLocator.getDataManager();
            final FeatureSymbolTable featureSymbolTable = manager.createFeatureSymbolTable();
            this.selectionOfFeatures.accept(new Visitor(){

                public void visit(Object o) throws VisitCanceledException, BaseException {
                    featureSymbolTable.setFeature((Feature)o);
                    Boolean r = (Boolean)filter.execute((SymbolTable)featureSymbolTable);
                    if (r.booleanValue()) {
                        visitor.visit(o);
                    }
                }
            });
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public FeatureQuery getQuery() {
        return this.getQuery(null);
    }

    public FeatureQuery getQuery(Expression filter) {
        FeatureQuery dataQuery = this.query;
        if (!ExpressionUtils.isPhraseEmpty((Expression)this.filter) && !ExpressionUtils.isPhraseEmpty((Expression)filter)) {
            ExpressionBuilder builder = ExpressionUtils.createExpressionBuilder();
            Expression f = ExpressionUtils.createExpression((String)builder.and(filter, this.filter).toString());
            dataQuery.addFilter(f);
            dataQuery.retrievesAllAttributes();
        } else if (!ExpressionUtils.isPhraseEmpty((Expression)this.filter)) {
            dataQuery.addFilter(this.filter);
            dataQuery.retrievesAllAttributes();
        } else if (!ExpressionUtils.isPhraseEmpty((Expression)filter)) {
            dataQuery.addFilter(filter);
            dataQuery.retrievesAllAttributes();
        }
        dataQuery.setLimit((long)this.limit);
        return dataQuery;
    }

    public ReportDataSet.SelectionOfFeatures getSelectionOfFeatures() {
        return this.selectionOfFeatures;
    }

    public UnmodifiableBasicList64<Feature> getFeatures() {
        return this.getFeatures(null);
    }

    public UnmodifiableBasicList64<Feature> getFeatures(Expression filter) {
        if (this.selectionOfFeatures.isEmpty()) {
            FeatureStore theStore = this.getStore();
            FeatureQuery query = this.getQuery(filter);
            List r = theStore.getFeatures(query);
            return new UnmodifiableBasicList64Adapter(r);
        }
        return this.getSelectionOfFeatures();
    }

    public int getLimit() {
        return this.limit;
    }

    public Expression getFilter() {
        return this.filter;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setFilter(Expression filter) {
        this.filter = filter;
    }

    public boolean getExposeGeometry() {
        return this.exposeGeometry;
    }

    public void setExposeGeometry(boolean selected) {
        this.exposeGeometry = selected;
    }

    public String getURLPath() {
        String p = "/dataset/" + this.getName();
        return p;
    }
}

