/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportDataSets;
import org.gvsig.report.lib.api.ReportManager;
import org.gvsig.report.lib.api.ReportServices;

public class DefaultReportDataSets
extends ArrayList<ReportDataSet>
implements ReportDataSets {
    private final ReportServices services;
    private final ReportManager manager;
    private final PropertyChangeSupport propertyChangeSupport;

    public DefaultReportDataSets(ReportManager manager, ReportServices services) {
        this.services = services;
        this.manager = manager;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public ReportDataSet get(String name) {
        for (ReportDataSet dataset : this) {
            if (!dataset.getName().equalsIgnoreCase(name)) continue;
            return dataset;
        }
        return null;
    }

    public void add(String name, FeatureStore store) {
        if (!this.isValidName(name)) {
            name = this.getValidName(name);
        }
        name = this.getUniqueName(name);
        ReportDataSet dataset = this.manager.createDataSet(this.services, name, store);
        this.add(dataset);
    }

    @Override
    public boolean add(ReportDataSet dataset) {
        String name = dataset.getName();
        if (!this.isValidName(name)) {
            name = this.getValidName(name);
        }
        name = this.getUniqueName(name);
        dataset.setName(name);
        boolean x = super.add(dataset);
        this.propertyChangeSupport.firePropertyChange("add", null, null);
        return x;
    }

    public void remove(String name) {
        ReportDataSet dataset = this.get(name);
        if (dataset == null) {
            return;
        }
        this.remove(dataset);
        this.propertyChangeSupport.firePropertyChange("remove", null, null);
    }

    public boolean contains(FeatureStore store) {
        for (ReportDataSet dataset : this) {
            if (!dataset.hasThisStore(store)) continue;
            return true;
        }
        return false;
    }

    public boolean contains(String name) {
        return this.get(name) != null;
    }

    public boolean isValidName(String name) {
        if (!StringUtils.isAlpha((CharSequence)(name = name.toLowerCase()).substring(0, 1))) {
            return false;
        }
        return StringUtils.containsOnly((CharSequence)"abcdefghijklmnopqrstuvwxyz0987654321_", (char[])new char[0]);
    }

    public String getValidName(String name) {
        name = name.toLowerCase();
        name = StringUtils.normalizeSpace((String)name);
        name = StringUtils.replaceChars((String)name, (char)'_', (char)'_');
        name = StringUtils.replaceChars((String)name, (char)' ', (char)'_');
        name = StringUtils.stripAccents((String)name);
        name = StringUtils.removeAll((String)name, (String)"[^a-z0-9_]");
        return name;
    }

    public String getUniqueName(String name) {
        if (!this.contains(name)) {
            return name;
        }
        for (int i = 0; i < 1000; ++i) {
            String s = name + "_" + i;
            if (this.contains(s)) continue;
            return s;
        }
        return name + "_" + Long.toHexString(System.currentTimeMillis());
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }
}

