/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl.commands;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.ExpressionUtils;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureSelection;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.report.lib.api.ReportViewCapture;
import org.gvsig.report.lib.api.commands.AbstractCommand;
import org.gvsig.report.lib.api.commands.CommandFactory;
import org.gvsig.tools.exception.BaseException;
import org.gvsig.tools.visitor.VisitCanceledException;
import org.gvsig.tools.visitor.Visitor;

public class CaptureView
extends AbstractCommand {
    public CaptureView(CommandFactory factory, ReportServer server) {
        super(factory, server);
    }

    public Object call(int argc, String[] args) {
        BufferedImage image;
        Envelope envelope = null;
        Envelope center = null;
        int margins = -1;
        int width = -1;
        int height = -1;
        int dpi = 0;
        String viewName = null;
        ReportViewCapture viewcapture = null;
        int n = 1;
        block27: while (n < args.length) {
            String option;
            switch (option = args[n++].toLowerCase()) {
                case "viewname": {
                    viewName = args[n++];
                    continue block27;
                }
                case "capturename": {
                    String id = args[n++];
                    viewcapture = this.getConfig().getViewCapture(id);
                    continue block27;
                }
                case "zoom": {
                    if (envelope != null) {
                        throw new IllegalArgumentException("Option '" + option + "' duplicated.");
                    }
                    envelope = this.getEnvelope(args[n++], this.createExpression(args[n++]));
                    continue block27;
                }
                case "center": {
                    if (center != null) {
                        throw new IllegalArgumentException("Option '" + option + "' duplicated.");
                    }
                    center = this.getEnvelope(args[n++], this.createExpression(args[n++]));
                    continue block27;
                }
                case "select": {
                    this.select(args[n++], this.createExpression(args[n++]));
                    continue block27;
                }
                case "clearselection": 
                case "deselect": {
                    this.deselect(args[n++]);
                    continue block27;
                }
                case "margins": {
                    margins = NumberUtils.toInt((String)args[n++], (int)-1);
                    continue block27;
                }
                case "width": {
                    width = NumberUtils.toInt((String)args[n++], (int)-1);
                    continue block27;
                }
                case "dpi": {
                    dpi = NumberUtils.toInt((String)args[n++], (int)-1);
                    continue block27;
                }
                case "height": {
                    height = NumberUtils.toInt((String)args[n++], (int)-1);
                    continue block27;
                }
            }
            throw new IllegalArgumentException("Option '" + option + "' not supported.");
        }
        if (viewcapture != null) {
            margins = viewcapture.getMargins();
            width = viewcapture.getDimensions().width;
            height = viewcapture.getDimensions().height;
            dpi = viewcapture.getResolution();
        }
        if (dpi < 72) {
            dpi = 72;
        }
        Dimension dimension = null;
        if (width > 0 && height > 0) {
            dimension = new Dimension((int)Math.round((double)width * 0.0393701 * (double)dpi), (int)Math.round((double)height * 0.0393701 * (double)dpi));
        }
        if (margins > 0) {
            this.applyMargins(envelope, margins);
        }
        if (center != null) {
            envelope = this.move(envelope, center);
        }
        if ((image = this.getServices().getViewImage(viewName, dimension, envelope)) == null) {
            this.getServer().log(1, "Can't get view image for view name '" + viewName + "' (" + ArrayUtils.toString((Object)args) + ").");
            image = this.getDefaultImage(dimension);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", (OutputStream)out);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex.toString(), ex);
        }
        return out.toByteArray();
    }

    private Envelope getEnvelope(String datasetName, Expression filter) {
        ReportDataSet dataset = this.getConfig().getDataset(datasetName);
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset '" + datasetName + "' not exists.");
        }
        final Envelope envelope = GeometryUtils.createEnvelope((int)0);
        dataset.accept(new Visitor(){

            public void visit(Object o) throws VisitCanceledException, BaseException {
                Feature f = (Feature)o;
                envelope.add(f.getDefaultGeometry());
            }
        }, filter);
        return envelope;
    }

    private void select(String datasetName, Expression filter) {
        ReportDataSet dataset = this.getConfig().getDataset(datasetName);
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset '" + datasetName + "' not exists.");
        }
        try {
            FeatureStore store = dataset.getStore();
            final FeatureSelection selection = store.createFeatureSelection();
            dataset.accept(new Visitor(){

                public void visit(Object o) throws VisitCanceledException, BaseException {
                    Feature f = (Feature)o;
                    selection.select(f);
                }
            }, filter);
            store.setSelection((FeatureSet)selection);
        }
        catch (DataException ex) {
            throw new RuntimeException("Can't select features from '" + datasetName + "' with filter '" + filter + "'.");
        }
    }

    private void deselect(String datasetName) {
        ReportDataSet dataset = this.getConfig().getDataset(datasetName);
        if (dataset == null) {
            throw new IllegalArgumentException("Dataset '" + datasetName + "' not exists.");
        }
        try {
            dataset.getStore().getFeatureSelection().deselectAll();
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't deselect features from '" + datasetName + "'.");
        }
    }

    private void applyMargins(Envelope envelope, int margins) {
    }

    private Envelope move(Envelope source, Envelope target) {
        try {
            double sourceCenterX = source.getCenter(0);
            double sourceCenterY = source.getCenter(1);
            double targetCenterX = target.getCenter(0);
            double targetCenterY = target.getCenter(1);
            double movX = targetCenterX - sourceCenterX;
            double movY = targetCenterY - sourceCenterY;
            double minx = source.getMinimum(0) + movX;
            double miny = source.getMinimum(1) + movY;
            double maxX = source.getMaximum(0) + movX;
            double maxY = source.getMaximum(1) + movY;
            Envelope envelope = GeometryLocator.getGeometryManager().createEnvelope(minx, miny, maxX, maxY, 0);
            return envelope;
        }
        catch (Exception ex) {
            throw new RuntimeException("Can't move source envelope to center of target.");
        }
    }

    private BufferedImage getDefaultImage(Dimension dimension) {
        if (dimension == null) {
            dimension = new Dimension(100, 100);
        }
        BufferedImage image = new BufferedImage(dimension.width, dimension.height, 2);
        return image;
    }

    private Expression createExpression(String s) {
        Expression expression = ExpressionUtils.createExpression((String)s);
        expression.setUseBracketsForIdentifiers(true);
        return expression;
    }
}

