/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl.commands;

import java.net.URL;
import java.net.URLDecoder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.gvsig.fmap.dal.DALLocator;
import org.gvsig.fmap.dal.DataManager;
import org.gvsig.fmap.dal.feature.DataProfile;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureQuery;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportLocator;
import org.gvsig.report.lib.api.ReportServer;
import org.gvsig.report.lib.api.commands.AbstractCommand;
import org.gvsig.report.lib.api.commands.CommandFactory;
import org.gvsig.report.lib.impl.commands.GetImageFactory;
import org.gvsig.tools.swing.api.SimpleImage;
import org.gvsig.tools.swing.api.ToolsSwingLocator;

public class GetImage
extends AbstractCommand {
    public GetImage() {
        super((CommandFactory)GetImageFactory.getInstance(), ReportLocator.getReportManager().getDefaultServer());
    }

    public GetImage(CommandFactory factory, ReportServer server) {
        super(factory, server);
    }

    public boolean canUse(URL url) throws Exception {
        String line = URLDecoder.decode(url.getPath(), "UTF-8");
        String[] args = org.apache.commons.lang3.StringUtils.split((String)line, (char)'/');
        return StringUtils.equalsIgnoreCase((String)args[0], (String)this.getName());
    }

    public byte[] fetch(URL url) throws Exception {
        String line = URLDecoder.decode(url.getPath(), "UTF-8");
        String[] args = org.apache.commons.lang3.StringUtils.split((String)line, (char)'/');
        int argc = args.length - 1;
        return (byte[])this.call(argc, args);
    }

    public Object call(int argc, String[] args) throws Exception {
        MutableBoolean withGeom = new MutableBoolean(false);
        boolean limit = true;
        String filter = null;
        String columnName = null;
        boolean ascending = true;
        String orderFields = null;
        int n = 1;
        String datasetName = args[n++];
        block12: while (n < args.length) {
            String option;
            switch (option = args[n++].toLowerCase()) {
                case "column": {
                    columnName = args[n++];
                    continue block12;
                }
                case "filter": {
                    filter = args[n++];
                    continue block12;
                }
                case "order": {
                    orderFields = args[n++];
                    continue block12;
                }
            }
            throw new IllegalArgumentException("Option '" + option + "' not supported.");
        }
        if (StringUtils.isBlank(columnName)) {
            this.getServer().log(1, "Column '" + columnName + "' can't be null.");
            return this.getImageNotAvailable();
        }
        Feature f = null;
        try {
            FeatureType featureType;
            FeatureAttributeDescriptor attrdesc;
            FeatureStore store = null;
            ReportDataSet dataset = this.getConfig().getDataset(datasetName);
            if (dataset == null) {
                DataManager dataManager = DALLocator.getManager();
                store = (FeatureStore)dataManager.getStoresRepository().getStore(datasetName);
                if (store == null) {
                    this.getServer().log(1, "Dataset '" + datasetName + "' not exists.");
                    return this.getImageNotAvailable();
                }
            } else {
                store = dataset.getStore();
            }
            if ((attrdesc = (featureType = store.getDefaultFeatureTypeQuietly()).getAttributeDescriptor(columnName)) == null) {
                this.getServer().log(1, "Column '" + columnName + "' don't exists in '" + store.getName() + "'.");
                return this.getImageNotAvailable();
            }
            DataProfile dataProfile = attrdesc.getDataProfile();
            if (dataProfile == null || !dataProfile.getID().equalsIgnoreCase("image")) {
                this.getServer().log(1, "Column '" + columnName + "' is not configured as an image.");
                return this.getImageNotAvailable();
            }
            FeatureQuery query = store.createFeatureQuery();
            if (!StringUtils.isBlank((String)filter)) {
                query.setFilter(filter);
            }
            if (!StringUtils.isBlank((String)orderFields)) {
                query.getOrder().add(orderFields);
            }
            query.setLimit(1L);
            query.retrievesAllAttributes();
            f = store.findFirst(query);
        }
        catch (Exception store) {
            // empty catch block
        }
        if (f == null) {
            this.getServer().log(1, "Image not found. ( " + filter + " ) ");
            return this.getImageNotAvailable();
        }
        SimpleImage simpleImage = (SimpleImage)f.getFromProfile(columnName);
        if (simpleImage == null) {
            return this.getImageNotAvailable();
        }
        return simpleImage.toBytearray();
    }

    private byte[] getImageNotAvailable() {
        String fullName = "org/gvsig/report/lib/impl/commands/image-not-available.png";
        URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(fullName);
        SimpleImage simpleImage = ToolsSwingLocator.getToolsSwingManager().createSimpleImage((Object)url);
        return simpleImage.toBytearray();
    }
}

