/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl.reportbuilder;

import ar.com.fdvs.dj.domain.CustomExpression;
import ar.com.fdvs.dj.domain.builders.ColumnBuilder;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import java.util.Map;
import net.sf.jasperreports.engine.fill.JRFillField;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.expressionevaluator.Expression;
import org.gvsig.expressionevaluator.spi.AbstractSymbolTable;
import org.gvsig.report.lib.api.ReportBuilder;
import org.gvsig.report.lib.impl.reportbuilder.DefaultStyleBuilder;
import org.gvsig.report.lib.impl.reportbuilder.GvsigCustomExpression;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dataTypes.DataType;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class DefaultColumnBuilder
implements ReportBuilder.ColumnBuilder {
    private String title;
    private ReportBuilder.StyleBuilder titleStyle;
    private String field;
    private ReportBuilder.StyleBuilder fieldStyle;
    private Expression expression = null;
    private ReportBuilder.StyleBuilder expressionStyle = new DefaultStyleBuilder();
    private DataType dataType;
    private int width = 10;
    private boolean fixedWidth;
    private String pattern = null;
    private String truncateSuffix = "...";
    private boolean groupByField = false;
    private int groupByOperation = 7;
    private String columnName = "";

    public DefaultColumnBuilder() {
        this.fieldStyle = new DefaultStyleBuilder();
        this.titleStyle = new DefaultStyleBuilder();
        this.dataType = ToolsLocator.getDataTypesManager().get(8);
    }

    public ReportBuilder.ColumnBuilder clone() throws CloneNotSupportedException {
        DefaultColumnBuilder other = (DefaultColumnBuilder)super.clone();
        other.expressionStyle = this.expressionStyle.clone();
        other.fieldStyle = this.fieldStyle.clone();
        other.titleStyle = this.titleStyle.clone();
        if (this.expression != null) {
            other.expression = this.expression.clone();
        }
        other.dataType = ToolsLocator.getDataTypesManager().get(this.dataType.getType());
        return other;
    }

    public void copyFrom(ReportBuilder.ColumnBuilder other) {
        try {
            this.columnName = other.getColumnName();
            this.title = other.getTitle();
            this.width = other.getWidth();
            this.fixedWidth = other.getFixedWidth();
            this.pattern = other.getPattern();
            this.truncateSuffix = other.getTruncateSuffix();
            this.titleStyle = other.titleStyle().clone();
            if (other.getExpression() != null) {
                this.expression = other.getExpression().clone();
                this.field = "";
                this.expressionStyle = other.expressionStyle().clone();
            } else {
                this.expression = null;
                this.field = other.getField();
                this.fieldStyle = other.fieldStyle().clone();
            }
            this.dataType = other.getDataType().clone();
            this.groupByField = other.showGroupByField();
            this.groupByOperation = other.getGroupByOperation();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Can't copy ColumnBuilder", ex);
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public ReportBuilder.ColumnBuilder columnName(String columnName) {
        this.columnName = columnName;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public ReportBuilder.StyleBuilder titleStyle() {
        return this.titleStyle;
    }

    public ReportBuilder.ColumnBuilder title(String title) {
        this.title = title;
        return this;
    }

    public String getField() {
        return this.field;
    }

    public ReportBuilder.StyleBuilder fieldStyle() {
        return this.fieldStyle;
    }

    public ReportBuilder.ColumnBuilder field(String field) {
        this.field = field;
        return this;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public ReportBuilder.StyleBuilder expressionStyle() {
        return this.expressionStyle;
    }

    public ReportBuilder.ColumnBuilder expression(Expression expression) {
        this.expression = expression;
        return this;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public ReportBuilder.ColumnBuilder dataType(DataType dataType) {
        this.dataType = dataType;
        return this;
    }

    public int getWidth() {
        return this.width;
    }

    public ReportBuilder.ColumnBuilder width(int width) {
        this.width = width;
        return this;
    }

    public boolean getFixedWidth() {
        return this.fixedWidth;
    }

    public ReportBuilder.ColumnBuilder fixedWidth(boolean fixedWidth) {
        this.fixedWidth = fixedWidth;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public ReportBuilder.ColumnBuilder pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public String getTruncateSuffix() {
        return this.truncateSuffix;
    }

    public ReportBuilder.ColumnBuilder truncateSuffix(String truncateSuffix) {
        this.truncateSuffix = truncateSuffix;
        return this;
    }

    public void saveToState(PersistentState ps) throws PersistenceException {
    }

    public void loadFromState(PersistentState ps) throws PersistenceException {
    }

    public static void registerPersistence() {
    }

    public boolean showGroupByField() {
        return this.groupByField;
    }

    public void groupByField(boolean groupByField) {
        this.groupByField = groupByField;
    }

    public int getGroupByOperation() {
        return this.groupByOperation;
    }

    public void groupByOperation(int groupByOperation) {
        this.groupByOperation = groupByOperation;
    }

    public AbstractColumn build() {
        ColumnBuilder colBuilder = ColumnBuilder.getNew();
        if (this.expression == null || this.expression.isPhraseEmpty()) {
            colBuilder.setColumnProperty(this.field, this.dataType.getDefaultClass().getName());
            if (this.fieldStyle != null) {
                colBuilder.setStyle(((DefaultStyleBuilder)this.fieldStyle).build());
            }
        } else {
            GvsigCustomExpression expGvsig;
            try {
                Expression exp = this.expression.clone();
                expGvsig = new GvsigCustomExpression(exp, this.dataType);
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException("Can't clone expression.", ex);
            }
            colBuilder.setCustomExpression((CustomExpression)expGvsig);
            if (this.expressionStyle != null) {
                colBuilder.setStyle(((DefaultStyleBuilder)this.expressionStyle).build());
            }
        }
        if (!StringUtils.isBlank((CharSequence)this.title)) {
            colBuilder.setTitle(this.title);
            if (this.titleStyle != null) {
                colBuilder.setHeaderStyle(((DefaultStyleBuilder)this.titleStyle).build());
            }
        }
        colBuilder.setWidth(this.width);
        colBuilder.setFixedWidth(this.fixedWidth);
        if (!StringUtils.isBlank((CharSequence)this.pattern)) {
            colBuilder.setPattern(this.pattern);
        }
        if (!StringUtils.isBlank((CharSequence)this.truncateSuffix)) {
            colBuilder.setTruncateSuffix(this.truncateSuffix);
        }
        AbstractColumn columnBuild = colBuilder.build();
        return columnBuild;
    }

    private static class MapSymbolTable
    extends AbstractSymbolTable {
        public void setVars(Map<String, Object> vars) {
            Map map1 = this.getVars();
            for (Map.Entry<String, Object> var : vars.entrySet()) {
                JRFillField value = (JRFillField)var.getValue();
                map1.put(var.getKey(), value.getValue());
            }
        }
    }
}

