/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.report.lib.impl.reportbuilder;

import ar.com.fdvs.dj.core.DynamicJasperHelper;
import ar.com.fdvs.dj.core.layout.ClassicLayoutManager;
import ar.com.fdvs.dj.core.layout.ExtendedListLayoutManager;
import ar.com.fdvs.dj.core.layout.LayoutManager;
import ar.com.fdvs.dj.core.layout.ListLayoutManager;
import ar.com.fdvs.dj.domain.DynamicReport;
import ar.com.fdvs.dj.domain.Style;
import ar.com.fdvs.dj.domain.builders.DynamicReportBuilder;
import ar.com.fdvs.dj.domain.builders.StyleBuilder;
import ar.com.fdvs.dj.domain.constants.Page;
import ar.com.fdvs.dj.domain.constants.Transparency;
import ar.com.fdvs.dj.domain.entities.DJGroup;
import ar.com.fdvs.dj.domain.entities.columns.AbstractColumn;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sf.jasperreports.engine.JasperReport;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.report.lib.api.Report;
import org.gvsig.report.lib.api.ReportBuilder;
import org.gvsig.report.lib.api.ReportDataSet;
import org.gvsig.report.lib.api.ReportLocator;
import org.gvsig.report.lib.api.ReportManager;
import org.gvsig.report.lib.impl.DefaultReport;
import org.gvsig.report.lib.impl.DefaultReportConfig;
import org.gvsig.report.lib.impl.reportbuilder.DefaultBorderBuilder;
import org.gvsig.report.lib.impl.reportbuilder.DefaultColumnBuilder;
import org.gvsig.report.lib.impl.reportbuilder.DefaultGroupBuilder;
import org.gvsig.report.lib.impl.reportbuilder.DefaultMargins;
import org.gvsig.report.lib.impl.reportbuilder.DefaultStyleBuilder;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReportBuilder
implements ReportBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultReportBuilder.class);
    private String title;
    private String subtitle;
    private boolean printBackgroundOnOddRows;
    private boolean useFullPageWith;
    private int detailHeight;
    private int columnsPerPage;
    private ReportBuilder.Margins margins;
    private List<ReportBuilder.ColumnBuilder> columns;
    private List<ReportBuilder.GroupBuilder> groups;
    private ReportBuilder.StyleBuilder titleStyle;
    private ReportBuilder.StyleBuilder subtitleStyle;
    private boolean printColumnNames;
    private int layout;
    private int pageFormat;
    private boolean showDetailBand;
    private Style oddRowBackgroundStyle;

    public DefaultReportBuilder() {
        this.initValues();
    }

    private void initValues() {
        this.columns = new ArrayList<ReportBuilder.ColumnBuilder>();
        this.groups = new ArrayList<ReportBuilder.GroupBuilder>();
        this.titleStyle = null;
        this.subtitleStyle = null;
        this.layout = 0;
        this.detailHeight = 15;
        this.margins = null;
        this.useFullPageWith = true;
        this.columnsPerPage = 1;
        this.printBackgroundOnOddRows = true;
        this.printColumnNames = true;
        this.showDetailBand = true;
        this.oddRowBackgroundStyle = new StyleBuilder(false, "defaultOddRowStyle").setBackgroundColor(new Color(200, 200, 200, 80)).setTransparency(Transparency.TRANSPARENT).setTransparent(true).build();
    }

    public void clean() {
        this.initValues();
    }

    public ReportBuilder.Margins createMargins() {
        return new DefaultMargins();
    }

    public ReportBuilder.ColumnBuilder createColumn() {
        return new DefaultColumnBuilder();
    }

    public ReportBuilder.StyleBuilder createStyle() {
        return new DefaultStyleBuilder();
    }

    public ReportBuilder.BorderBuilder createBorder() {
        return new DefaultBorderBuilder();
    }

    public ReportBuilder.GroupBuilder createGroup(ReportBuilder.ColumnBuilder columnBuilder) {
        return new DefaultGroupBuilder(columnBuilder);
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public boolean getPrintBackgroundOnOddRows() {
        return this.printBackgroundOnOddRows;
    }

    public boolean getUseFullPageWith() {
        return this.useFullPageWith;
    }

    public boolean getShowDetailBand() {
        return this.showDetailBand;
    }

    public int getDetailHeight() {
        return this.detailHeight;
    }

    public int getColumnsPerPage() {
        return this.columnsPerPage;
    }

    public ReportBuilder.Margins getMargins() {
        return this.margins;
    }

    public List<ReportBuilder.ColumnBuilder> getColumns() {
        return this.columns;
    }

    public List<ReportBuilder.GroupBuilder> getGroups() {
        return this.groups;
    }

    public ReportBuilder.StyleBuilder titleStyle() {
        if (this.titleStyle == null) {
            this.titleStyle = this.createStyle();
            this.titleStyle.fontSize(16);
        }
        return this.titleStyle;
    }

    public ReportBuilder.StyleBuilder subtitleStyle() {
        if (this.subtitleStyle == null) {
            this.subtitleStyle = this.createStyle();
            this.subtitleStyle.fontSize(12);
        }
        return this.subtitleStyle;
    }

    public ReportBuilder title(String title) {
        this.title = title;
        return this;
    }

    public ReportBuilder subtitle(String subtitle) {
        this.subtitle = subtitle;
        return this;
    }

    public ReportBuilder printBackgroundOnOddRows(boolean printBackgroundOnOddRows) {
        this.printBackgroundOnOddRows = printBackgroundOnOddRows;
        return this;
    }

    public ReportBuilder useFullPageWith(boolean useFullPageWith) {
        this.useFullPageWith = useFullPageWith;
        return this;
    }

    public ReportBuilder showDetailBand(boolean showDetailBand) {
        this.showDetailBand = showDetailBand;
        return this;
    }

    public ReportBuilder detailHeight(int detailHeight) {
        this.detailHeight = detailHeight;
        return this;
    }

    public ReportBuilder columnsPerPage(int columnsPerPage) {
        this.columnsPerPage = columnsPerPage;
        return this;
    }

    public ReportBuilder.ColumnBuilder add_column() {
        ReportBuilder.ColumnBuilder column = this.createColumn();
        this.columns.add(column);
        return column;
    }

    public ReportBuilder margins(int top, int bottom, int left, int right) {
        if (this.margins == null) {
            this.margins = this.createMargins();
        }
        this.margins.set(top, bottom, left, right);
        return this;
    }

    public int getLayout() {
        return this.layout;
    }

    public boolean getPrintColumnNames() {
        return this.printColumnNames;
    }

    public ReportBuilder printColumnNames(boolean printColumnNames) {
        this.printColumnNames = printColumnNames;
        return this;
    }

    public int getPageFormat() {
        return this.pageFormat;
    }

    public ReportBuilder pageFormat(int pageFormat) {
        this.pageFormat = pageFormat;
        return this;
    }

    public ReportBuilder layout(int layout) {
        this.layout = layout;
        return this;
    }

    private LayoutManager getLayoutManager() {
        switch (this.layout) {
            case 1: {
                return new ListLayoutManager();
            }
            case 2: {
                return new ExtendedListLayoutManager();
            }
        }
        return new ClassicLayoutManager();
    }

    public ReportBuilder clone() throws CloneNotSupportedException {
        DefaultReportBuilder other = (DefaultReportBuilder)super.clone();
        if (this.margins != null) {
            other.margins = this.margins.clone();
        }
        if (this.titleStyle != null) {
            other.titleStyle = this.titleStyle.clone();
        }
        if (this.subtitleStyle != null) {
            other.subtitleStyle = this.subtitleStyle.clone();
        }
        other.columns.retainAll(Collections.EMPTY_LIST);
        for (ReportBuilder.ColumnBuilder column : this.columns) {
            other.columns.add(column.clone());
        }
        return other;
    }

    public void copyFrom(ReportBuilder other) {
        try {
            this.title = other.getTitle();
            this.subtitle = other.getSubtitle();
            this.printBackgroundOnOddRows = other.getPrintBackgroundOnOddRows();
            this.useFullPageWith = other.getUseFullPageWith();
            this.showDetailBand = other.getShowDetailBand();
            this.detailHeight = other.getDetailHeight();
            this.columnsPerPage = other.getColumnsPerPage();
            this.printColumnNames = other.getPrintColumnNames();
            this.layout = other.getLayout();
            this.pageFormat = other.getPageFormat();
            if (other.getMargins() != null) {
                this.margins = other.getMargins().clone();
            }
            if (other.titleStyle() != null) {
                this.titleStyle = other.titleStyle().clone();
            }
            if (other.subtitleStyle() != null) {
                this.subtitleStyle = other.subtitleStyle().clone();
            }
            this.columns.retainAll(Collections.EMPTY_LIST);
            for (ReportBuilder.ColumnBuilder column : other.getColumns()) {
                this.columns.add(column.clone());
            }
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException("Can't copy ReportBuilder", ex);
        }
    }

    public Report toReport(ReportDataSet dataSet) {
        DynamicReportBuilder builder = new DynamicReportBuilder();
        if (!StringUtils.isBlank((CharSequence)this.title)) {
            builder.setTitle(this.title);
            if (this.titleStyle != null) {
                builder.setTitleStyle(((DefaultStyleBuilder)this.titleStyle).build());
            }
        }
        if (!StringUtils.isBlank((CharSequence)this.subtitle)) {
            builder.setSubtitle(this.subtitle);
            if (this.subtitleStyle != null) {
                builder.setSubtitleStyle(((DefaultStyleBuilder)this.subtitleStyle).build());
            }
        }
        builder.setColumnsPerPage(this.columnsPerPage);
        if (this.detailHeight > 0) {
            builder.setDetailHeight(this.detailHeight);
        }
        builder.setUseFullPageWidth(this.useFullPageWith);
        builder.setPrintBackgroundOnOddRows(this.printBackgroundOnOddRows);
        builder.setOddRowBackgroundStyle(this.oddRowBackgroundStyle);
        if (this.margins != null) {
            builder.setMargins(this.margins.getTop(), this.margins.getBottom(), this.margins.getLeft(), this.margins.getRight());
        }
        builder.setPrintColumnNames(this.printColumnNames);
        switch (this.pageFormat) {
            default: {
                builder.setPageSizeAndOrientation(Page.Page_A4_Portrait());
                break;
            }
            case 1: {
                builder.setPageSizeAndOrientation(Page.Page_A4_Landscape());
                break;
            }
            case 2: {
                builder.setPageSizeAndOrientation(Page.Page_Legal_Portrait());
                break;
            }
            case 3: {
                builder.setPageSizeAndOrientation(Page.Page_Legal_Landscape());
                break;
            }
            case 4: {
                builder.setPageSizeAndOrientation(Page.Page_Letter_Portrait());
                break;
            }
            case 5: {
                builder.setPageSizeAndOrientation(Page.Page_Letter_Landscape());
            }
        }
        HashMap<String, AbstractColumn> mapColumns = new HashMap<String, AbstractColumn>();
        for (ReportBuilder.ColumnBuilder column : this.columns) {
            DefaultColumnBuilder columnBuilder = (DefaultColumnBuilder)column;
            AbstractColumn columnState = columnBuilder.build();
            mapColumns.put(column.getColumnName(), columnState);
            builder.addColumn(columnState);
        }
        for (ReportBuilder.GroupBuilder group : this.groups) {
            DJGroup groupBuilder = ((DefaultGroupBuilder)group).build(mapColumns, this.columns);
            builder.addGroup(groupBuilder);
        }
        builder.setShowDetailBand(this.showDetailBand);
        builder.addAutoText((byte)1, (byte)0, (byte)3);
        HashMap params = new HashMap();
        try {
            DynamicReport dynamicReport = builder.build();
            JasperReport jasperReport = DynamicJasperHelper.generateJasperReport((DynamicReport)dynamicReport, (LayoutManager)this.getLayoutManager(), params);
            ReportManager reportManager = ReportLocator.getReportManager();
            DefaultReportConfig config = new DefaultReportConfig();
            config.setDataSet(dataSet);
            config.setName(this.title);
            config.setLayoutManager(this.layout);
            DefaultReport report = new DefaultReport(config, dynamicReport);
            return report;
        }
        catch (Exception ex) {
            LOG.warn("Can't create report.", (Throwable)ex);
            return null;
        }
    }

    public void saveToState(PersistentState ps) throws PersistenceException {
    }

    public void loadFromState(PersistentState ps) throws PersistenceException {
    }

    public static void selfRegister() {
    }

    public ReportBuilder.GroupBuilder add_group(ReportBuilder.ColumnBuilder columnBuilder) {
        ReportBuilder.GroupBuilder group = this.createGroup(columnBuilder);
        this.groups.add(group);
        return group;
    }
}

