/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geometrymeasurement.app.extension.utils;

import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.EditableFeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.EditableFeatureType;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.fmap.dal.feature.exception.NeedEditingModeException;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.operation.GeometryOperationException;
import org.gvsig.fmap.geom.operation.GeometryOperationNotSupportedException;
import org.gvsig.fmap.geom.primitive.Point;
import org.gvsig.tools.dispose.DisposableIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Operations {
    private static final Logger LOG = LoggerFactory.getLogger(Operations.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDoubleFieldFromOperation(FeatureStore featureStore, String fieldName, String operationName) throws DataException, GeometryOperationNotSupportedException, GeometryOperationException {
        boolean isEditing = false;
        if (featureStore.isEditing()) {
            isEditing = true;
        } else {
            featureStore.edit();
        }
        featureStore.beginEditingGroup(operationName);
        FeatureType featureType = featureStore.getDefaultFeatureType();
        EditableFeatureType editableFeatureType = featureType.getEditable();
        String realFieldName = this.getFieldName(featureStore, fieldName, 0);
        EditableFeatureAttributeDescriptor editableFeatureAttributeDescriptor = editableFeatureType.add(realFieldName, 7);
        featureStore.update(editableFeatureType);
        DisposableIterator disposableIterator = null;
        FeatureSet featureSet = null;
        try {
            featureSet = featureStore.getFeatureSet();
            disposableIterator = featureSet.fastIterator();
            while (disposableIterator.hasNext()) {
                Feature feature = (Feature)disposableIterator.next();
                EditableFeature editableFeature = feature.getEditable();
                Geometry geom = feature.getDefaultGeometry();
                if (geom != null) {
                    editableFeature.setDouble(realFieldName, ((Double)geom.invokeOperation(operationName, null)).doubleValue());
                }
                featureSet.update(editableFeature);
            }
        }
        finally {
            if (disposableIterator != null) {
                disposableIterator.dispose();
            }
            if (featureSet != null) {
                featureSet.dispose();
            }
            try {
                featureStore.endEditingGroup();
            }
            catch (NeedEditingModeException e) {
                LOG.error("Exception endEditingGroup", (Throwable)e);
            }
        }
        if (!isEditing) {
            featureStore.finishEditing();
        }
    }

    public String getFieldName(FeatureStore featureStore, String fieldName, int index) throws DataException {
        String fullName = fieldName;
        if (index != 0) {
            fullName = fullName + index;
        }
        for (FeatureAttributeDescriptor featureAttributeDescriptor : featureStore.getDefaultFeatureType()) {
            if (!featureAttributeDescriptor.getName().toUpperCase().equals(fullName.toUpperCase())) continue;
            return this.getFieldName(featureStore, fieldName, index + 1);
        }
        return fullName;
    }

    public void addXYPoints(FeatureStore featureStore, String xFieldName, String yFieldName) throws DataException {
        boolean isEditing = false;
        if (featureStore.isEditing()) {
            isEditing = true;
        } else {
            featureStore.edit();
        }
        FeatureType featureType = featureStore.getDefaultFeatureType();
        EditableFeatureType editableFeatureType = featureType.getEditable();
        String realXFieldName = this.getFieldName(featureStore, xFieldName, 0);
        EditableFeatureAttributeDescriptor editableFeatureAttributeDescriptor = editableFeatureType.add(realXFieldName, 7);
        String realYFieldName = this.getFieldName(featureStore, yFieldName, 0);
        editableFeatureAttributeDescriptor = editableFeatureType.add(realYFieldName, 7);
        featureStore.update(editableFeatureType);
        FeatureSet featureSet = featureStore.getFeatureSet();
        DisposableIterator disposableIterator = featureSet.fastIterator();
        while (disposableIterator.hasNext()) {
            Feature feature = (Feature)disposableIterator.next();
            EditableFeature editableFeature = feature.getEditable();
            Geometry geom = feature.getDefaultGeometry();
            if (geom != null) {
                editableFeature.setDouble(realXFieldName, ((Point)geom).getX());
                editableFeature.setDouble(realYFieldName, ((Point)geom).getY());
            }
            featureSet.update(editableFeature);
        }
        featureSet.dispose();
        if (!isEditing) {
            featureStore.finishEditing();
        }
    }
}

