/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.dissolve;

import es.unex.sextante.core.Sextante;
import es.unex.sextante.dataObjects.IVectorLayer;
import es.unex.sextante.exceptions.GeoAlgorithmExecutionException;
import es.unex.sextante.exceptions.RepeatedParameterNameException;
import es.unex.sextante.exceptions.UnsupportedOutputChannelException;
import es.unex.sextante.gui.algorithm.GeoAlgorithmParametersPanel;
import java.util.ArrayList;
import java.util.HashMap;
import org.gvsig.fmap.dal.exception.DataException;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureSet;
import org.gvsig.fmap.dal.feature.FeatureStore;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.geoprocess.algorithm.dissolve.AdjacencyDissolveRule;
import org.gvsig.geoprocess.algorithm.dissolve.DissolveOperationFast;
import org.gvsig.geoprocess.algorithm.dissolve.DissolveParametersPanel;
import org.gvsig.geoprocess.algorithm.dissolve.DissolveRule;
import org.gvsig.geoprocess.lib.sextante.AbstractSextanteGeoProcess;
import org.gvsig.geoprocess.lib.sextante.dataObjects.FlyrVectIVectorLayer;
import org.gvsig.tools.task.SimpleTaskStatus;

public class DissolveAlgorithm
extends AbstractSextanteGeoProcess {
    public static final String RESULT = "RESULT";
    public static final String LAYER = "LAYER";
    public static final String FIELD = "FIELD";
    public static final String FUNCTIONS = "FUNCTIONS";
    public static final String SELECTED_GEOM = "SELECTED_GEOM";
    public static final String DISSOLV_ADJ = "DISSOLV_ADJ";
    public static final String FUNCTION_LIST = "FUNCTION_LIST";
    public static final String[] Summary = new String[]{"Min", "Max", "Sum", "Avg"};
    private boolean[] funcList = new boolean[Summary.length];
    private HashMap<String, String> funcMap = new HashMap();

    public void defineCharacteristics() {
        this.setName(this.getTranslation("Dissolve"));
        this.setGroup(this.getTranslation("basic_vect_algorithms"));
        try {
            this.m_Parameters.addInputVectorLayer(LAYER, this.getTranslation("Input_layer"), -1, true);
            this.m_Parameters.addBoolean(SELECTED_GEOM, this.getTranslation("Selected_geometries"), false);
            this.m_Parameters.addBoolean(DISSOLV_ADJ, this.getTranslation("Selected_geometries"), false);
            this.m_Parameters.addNumericalValue(FIELD, this.getTranslation("Field"), 0.0, 1);
            this.m_Parameters.addString(FUNCTION_LIST, this.getTranslation("Function_list"));
            this.addOutputVectorLayer(RESULT, this.getTranslation("Dissolve"), -1);
        }
        catch (RepeatedParameterNameException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public boolean processAlgorithm() throws GeoAlgorithmExecutionException {
        if (this.existsOutPutFile(RESULT, 0)) {
            throw new GeoAlgorithmExecutionException(this.getTranslation("file_exists"));
        }
        IVectorLayer layer = this.m_Parameters.getParameterValueAsVectorLayer(LAYER);
        int indexField = this.m_Parameters.getParameterValueAsInt(FIELD);
        boolean selectedGeom = this.m_Parameters.getParameterValueAsBoolean(SELECTED_GEOM);
        boolean dissolvAdj = this.m_Parameters.getParameterValueAsBoolean(DISSOLV_ADJ);
        String functionList = this.m_Parameters.getParameterValueAsString(FUNCTION_LIST);
        this.loadSummary(functionList);
        FeatureStore storeLayer = null;
        if (!(layer instanceof FlyrVectIVectorLayer)) {
            return false;
        }
        storeLayer = ((FlyrVectIVectorLayer)layer).getFeatureStore();
        FeatureSet features = null;
        FeatureType featureType = null;
        try {
            features = storeLayer.getFeatureSet();
            featureType = features.getDefaultFeatureType();
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        int layerType = layer.getShapeType();
        switch (layerType) {
            case 0: {
                layerType = 4;
                break;
            }
            case 1: {
                layerType = 5;
                break;
            }
            case 2: {
                layerType = 6;
                break;
            }
        }
        FeatureStore outFeatStore = this.buildDissolvedOutPutStore(featureType, layer.getFieldName(indexField), layerType, this.getTranslation("Dissolve"), RESULT);
        DissolveRule criteria = null;
        criteria = dissolvAdj ? new AdjacencyDissolveRule(layer.getFieldName(indexField), this.funcMap) : new DissolveRule(layer.getFieldName(indexField), this.funcMap);
        try {
            DissolveOperationFast operation = new DissolveOperationFast(criteria, this);
            operation.setTaskStatus((SimpleTaskStatus)this.getStatus());
            operation.computesGeometryOperation(storeLayer, outFeatStore, this.attrNames, selectedGeom, false, true);
        }
        catch (DataException e) {
            Sextante.addErrorToLog((Throwable)e);
            return false;
        }
        return !this.getTaskMonitor().isCanceled();
    }

    private int isInList(String it) {
        for (int i = 0; i < Summary.length; ++i) {
            if (Summary[i].compareTo(it) != 0) continue;
            return i;
        }
        return -1;
    }

    private void loadSummary(String functionList) {
        String[] attrList = functionList.split(";");
        for (int i = 0; i < attrList.length; ++i) {
            String[] func = attrList[i].split(",");
            for (int j = 1; j < func.length; ++j) {
                int pos = this.isInList(func[j]);
                if (pos == -1) continue;
                this.funcList[pos] = true;
                this.funcMap.put(Summary[pos], func[0]);
            }
        }
    }

    protected FeatureStore buildDissolvedOutPutStore(FeatureType featureType1, String fieldField, int shapeType, String sextanteLayerName, String sextanteLayerLabel) {
        ArrayList<Class<Double>> typesList = new ArrayList<Class<Double>>();
        ArrayList<String> attr = new ArrayList<String>();
        attr.add("FID");
        typesList.add(Integer.class);
        FeatureAttributeDescriptor desc = featureType1.getAttributeDescriptor(fieldField);
        attr.add(desc.getName());
        typesList.add(desc.getObjectClass());
        for (int i = 0; i < this.funcList.length; ++i) {
            if (!this.funcList[i]) continue;
            String fieldName = this.funcMap.get(Summary[i]);
            if (fieldName.length() >= 6) {
                fieldName = fieldName.substring(0, 5);
            }
            attr.add(fieldName + "_" + Summary[i]);
            typesList.add(Double.class);
        }
        this.attrNames = new String[attr.size()];
        attr.toArray(this.attrNames);
        Class[] types = new Class[typesList.size()];
        typesList.toArray(types);
        try {
            IVectorLayer output = this.getNewVectorLayer(sextanteLayerLabel, sextanteLayerName, shapeType, types, this.attrNames);
            return ((FlyrVectIVectorLayer)output).getFeatureStore();
        }
        catch (UnsupportedOutputChannelException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        catch (GeoAlgorithmExecutionException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
        return null;
    }

    public Class<? extends GeoAlgorithmParametersPanel> getCustomParametersPanelClass() {
        return DissolveParametersPanel.class;
    }
}

