/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.geoprocess.algorithm.dissolve;

import es.unex.sextante.core.Sextante;
import org.gvsig.fmap.dal.feature.EditableFeature;
import org.gvsig.fmap.dal.feature.Feature;
import org.gvsig.fmap.dal.feature.FeatureAttributeDescriptor;
import org.gvsig.fmap.dal.feature.FeatureType;
import org.gvsig.geoprocess.algorithm.dissolve.IDissolveRule;

public class Summary {
    private IDissolveRule rule = null;
    private double max = Double.NEGATIVE_INFINITY;
    private double min = Double.POSITIVE_INFINITY;
    private double avg = 0.0;
    private double sum = 0.0;
    private double sumAvg = 0.0;
    private double nfeat = 0.0;
    private FeatureType featType = null;

    public Summary(IDissolveRule criteria, FeatureType featType) {
        this.rule = criteria;
        this.featType = featType;
    }

    public void updateValues(Feature feature) {
        try {
            FeatureAttributeDescriptor[] desc = this.featType.getAttributeDescriptors();
            Object obj = null;
            String fName = null;
            for (int i = 0; i < desc.length; ++i) {
                String fieldName = desc[i].getName();
                if (fieldName.endsWith("_Max") && (fName = this.rule.getFieldName("Max")) != null) {
                    obj = feature.get(fName);
                    this.max = Math.max(this.max, ((Number)obj).doubleValue());
                }
                if (fieldName.endsWith("_Min") && (fName = this.rule.getFieldName("Min")) != null) {
                    obj = feature.get(fName);
                    this.min = Math.min(this.min, ((Number)obj).doubleValue());
                }
                if (fieldName.endsWith("_Sum") && (fName = this.rule.getFieldName("Sum")) != null) {
                    obj = feature.get(fName);
                    this.sum += ((Number)obj).doubleValue();
                }
                if (fieldName.endsWith("_Avg") && (fName = this.rule.getFieldName("Avg")) != null) {
                    obj = feature.get(fName);
                    this.sumAvg += ((Number)obj).doubleValue();
                    this.nfeat += 1.0;
                    this.avg = this.sumAvg / this.nfeat;
                }
                fName = null;
            }
        }
        catch (NumberFormatException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public void loadEditableFeature(EditableFeature feat) {
        FeatureAttributeDescriptor[] desc = this.featType.getAttributeDescriptors();
        for (int i = 0; i < desc.length; ++i) {
            String fieldName = desc[i].getName();
            if (fieldName.endsWith("_Max") && feat.getType().getAttributeDescriptor(fieldName) != null) {
                feat.setDouble(fieldName, this.getMax());
            }
            if (fieldName.endsWith("_Min") && feat.getType().getAttributeDescriptor(fieldName) != null) {
                feat.setDouble(fieldName, this.getMin());
            }
            if (fieldName.endsWith("_Sum") && feat.getType().getAttributeDescriptor(fieldName) != null) {
                feat.setDouble(fieldName, this.getSum());
            }
            if (!fieldName.endsWith("_Avg") || feat.getType().getAttributeDescriptor(fieldName) == null) continue;
            feat.setDouble(fieldName, this.getAvg());
        }
    }

    public void loadDefaultSummarizes(Feature feature) {
        try {
            FeatureAttributeDescriptor[] desc = this.featType.getAttributeDescriptors();
            Object obj = null;
            String fName = null;
            this.nfeat = 0.0;
            this.sumAvg = 0.0;
            this.avg = 0.0;
            this.sum = 0.0;
            for (int i = 0; i < desc.length; ++i) {
                String fieldName = desc[i].getName();
                if (fieldName.endsWith("_Max") && (fName = this.rule.getFieldName("Max")) != null) {
                    obj = feature.get(fName);
                    this.max = ((Number)obj).doubleValue();
                }
                if (fieldName.endsWith("_Min") && (fName = this.rule.getFieldName("Min")) != null) {
                    obj = feature.get(fName);
                    this.min = ((Number)obj).doubleValue();
                }
                fName = null;
            }
        }
        catch (NumberFormatException e) {
            Sextante.addErrorToLog((Throwable)e);
        }
    }

    public double getMax() {
        return this.max;
    }

    public void setMax(double max) {
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public void setMin(double min) {
        this.min = min;
    }

    public double getAvg() {
        return this.avg;
    }

    public void setAvg(double avg) {
        this.avg = avg;
    }

    public double getSum() {
        return this.sum;
    }

    public void setSum(double sum) {
        this.sum = sum;
    }
}

