/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.vcsgis.app;

import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.gvsig.andami.ui.mdiManager.MDIManager;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.Component;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;
import org.gvsig.vcsgis.swing.VCSGisPanel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCSGisDialogsHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(VCSGisDialogsHelper.class);
    private Map<String, VCSGisDialogInfo> dialogsInfo;

    public VCSGisDialogInfo getDialog(String name) {
        if (this.dialogsInfo == null) {
            return null;
        }
        VCSGisDialogInfo info = this.dialogsInfo.get(name);
        return info;
    }

    public VCSGisDialogInfo getOrCreateDialog(String name, VCSGisPanel panel, String title, String header, String okLabel, Runnable action) {
        VCSGisDialogInfo info;
        if (this.dialogsInfo == null) {
            this.dialogsInfo = new HashMap<String, VCSGisDialogInfo>();
        }
        if ((info = this.dialogsInfo.get(name)) == null || info.isClosed()) {
            info = new VCSGisDialogInfo(name, panel, title, header, okLabel);
            info.setAction(action);
            this.dialogsInfo.put(name, info);
        }
        return info;
    }

    public VCSGisDialogInfo getOrCreateDialog(String name, VCSGisPanel panel, String title) {
        VCSGisDialogInfo info;
        if (this.dialogsInfo == null) {
            this.dialogsInfo = new HashMap<String, VCSGisDialogInfo>();
        }
        if ((info = this.dialogsInfo.get(name)) == null || info.isClosed()) {
            info = new VCSGisDialogInfo(name, panel, title);
            this.dialogsInfo.put(name, info);
        }
        return info;
    }

    public static class VCSGisDialogInfo {
        private VCSGisPanel panel;
        private final String name;
        private final String title;
        private String header;
        private String okLabel;
        private boolean closed;
        private Runnable action;
        private Dialog dialog;
        private boolean autoclose;

        public VCSGisDialogInfo(String name, VCSGisPanel thePanel, String title) {
            this.name = name;
            this.panel = thePanel;
            this.title = title;
            this.closed = true;
            this.autoclose = false;
            this.panel.asJComponent().addComponentListener(new ComponentAdapter(){

                @Override
                public void componentHidden(ComponentEvent e) {
                    closed = true;
                }
            });
        }

        public VCSGisDialogInfo(String name, VCSGisPanel thePanel, String title, String header, String okLabel) {
            this(name, thePanel, title);
            this.header = header;
            this.okLabel = okLabel;
        }

        private void performDialogAction() {
            this.action.run();
        }

        public void setAction(Runnable action) {
            this.action = action;
        }

        public Component getPanel() {
            return this.panel;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public String getName() {
            return this.name;
        }

        public void setAutoclose(boolean autoclose) {
            this.autoclose = autoclose;
        }

        private Dialog createDialog() {
            I18nManager i18n = ToolsLocator.getI18nManager();
            WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
            Dialog theDialog = winManager.createDialog(this.panel.asJComponent(), i18n.getTranslation(this.title), i18n.getTranslation(this.header), 3);
            theDialog.setAutoclose(false);
            this.panel.setDialog(theDialog);
            theDialog.setButtonLabel(1, i18n.getTranslation(this.okLabel));
            theDialog.setButtonLabel(2, i18n.getTranslation("_Close"));
            if (this.panel.isProcessing()) {
                theDialog.setButtonEnabled(1, false);
            }
            theDialog.addActionListener(e -> {
                switch (theDialog.getAction()) {
                    case 1: {
                        Thread task = new Thread(() -> {
                            if (this.autoclose) {
                                this.dialog.setButtonEnabled(1, false);
                            }
                            this.performDialogAction();
                            if (this.autoclose) {
                                this.close();
                            }
                        }, "VCSGis" + this.name);
                        task.start();
                        break;
                    }
                    case 2: {
                        this.close();
                    }
                }
            });
            return theDialog;
        }

        public void show() {
            this.show(null);
        }

        public void show(Map<String, Object> props) {
            if (!this.closed) {
                MDIManager manager = ApplicationLocator.getApplicationManager().getUIManager();
                manager.moveToFrom(manager.getWindow((JPanel)this.panel.asJComponent()));
                return;
            }
            this.closed = false;
            if (this.action == null) {
                I18nManager i18n = ToolsLocator.getI18nManager();
                WindowManager_v2 winManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
                winManager.showWindow(this.panel.asJComponent(), i18n.getTranslation(this.title), WindowManager.MODE.WINDOW, props);
            } else {
                this.dialog = this.createDialog();
                this.dialog.show(WindowManager.MODE.WINDOW, props);
            }
        }

        private void close() {
            if (this.closed || this.dialog == null) {
                this.panel = null;
                this.dialog = null;
                return;
            }
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(this::close);
                return;
            }
            this.dialog.asJComponent().setVisible(false);
            this.panel = null;
            this.dialog = null;
        }
    }
}

