/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.project.documents.layout.fframes.FFrameOverView;
import org.gvsig.app.project.documents.layout.fframes.IFFrameUseFMap;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.tools.ToolsLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFrameViewExtension
extends Extension {
    private static Logger logger = LoggerFactory.getLogger(FFrameViewExtension.class);

    public void initialize() {
    }

    public void execute(String command, Object[] args) {
        block6: {
            if (command.endsWith("view-change-scale")) {
                ApplicationManager manager = ApplicationLocator.getManager();
                IWindow window = manager.getActiveWindow();
                if (!(window instanceof LayoutPanel)) {
                    return;
                }
                LayoutPanel layout = (LayoutPanel)window;
                try {
                    if (args.length <= 0) break block6;
                    Long scale = (Long)ToolsLocator.getDataTypesManager().coerce(5, args[0]);
                    if (layout != null && layout.getLayoutControl() != null && layout.getLayoutControl().getLayoutFunctions() != null) {
                        layout.getLayoutControl().getLayoutFunctions().setScale(scale);
                    }
                }
                catch (Throwable ex) {
                    logger.info("Can't change scale of view.", ex);
                    ApplicationLocator.getManager().message("Can't change scale of view.", 0);
                }
            } else {
                this.execute(command);
            }
        }
    }

    public void execute(String s) {
        LayoutPanel layout = (LayoutPanel)PluginServices.getMDIManager().getActiveWindow();
        if (s.compareTo("layout-view-navigation-zoom-in-topoint") == 0) {
            layout.getLayoutControl().setTool("layoutviewzoomin");
        } else if (s.compareTo("layout-view-navigation-zoom-out-topoint") == 0) {
            layout.getLayoutControl().setTool("layoutviewzoomout");
        } else if (s.compareTo("layout-view-navigation-zoom-all") == 0) {
            try {
                layout.getLayoutControl().viewFull();
            }
            catch (ReadException e) {
                NotificationManager.addError((String)"Error de Driver", (Throwable)e);
            }
        } else {
            return;
        }
        layout.getDocument().setModified(true);
    }

    public boolean isEnabled() {
        IWindow window = PluginServices.getMDIManager().getActiveWindow();
        if (window instanceof LayoutPanel) {
            IFFrameUseFMap fframeview;
            LayoutPanel l = (LayoutPanel)PluginServices.getMDIManager().getActiveWindow();
            if (!l.getLayoutContext().isEditable()) {
                return false;
            }
            IFFrameUseFMap[] fframes = l.getLayoutContext().getSelectedFFrames(IFFrameUseFMap.class);
            if (fframes.length == 1 && !(fframes[0] instanceof FFrameOverView) && (fframeview = fframes[0]).getScaleType() == IFFrameUseFMap.SCALE_TYPE.NORMAL) {
                return true;
            }
        }
        return false;
    }

    public boolean isVisible() {
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f == null) {
            return false;
        }
        return f instanceof LayoutPanel;
    }
}

