/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.awt.Component;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.preferences.IPreference;
import org.gvsig.andami.preferences.IPreferenceExtension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.PreferencesNode;
import org.gvsig.app.gui.preferencespage.LayoutPage;
import org.gvsig.app.project.documents.layout.FLayoutZooms;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.layout.report.LayoutReportActionFactory;
import org.gvsig.filedialogchooser.FileDialogChooser;
import org.gvsig.filedialogchooser.FileDialogChooserManager;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.persistence.PersistenceFactory;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.text.JavaTextFactory;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.utils.GenericFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutExtension
extends Extension
implements IPreferenceExtension {
    private static final Logger logger = LoggerFactory.getLogger(LayoutExtension.class);
    private LayoutPanel layout = null;

    public void execute(String s) {
        this.layout = (LayoutPanel)PluginServices.getMDIManager().getActiveWindow();
        FLayoutZooms zooms = new FLayoutZooms(this.layout);
        logger.debug("Comand : " + s);
        switch (s) {
            case "layout-navigation-pan": {
                this.layout.getLayoutControl().setTool("layoutpan");
                break;
            }
            case "layout-navigation-zoom-in-topoint": {
                this.layout.getLayoutControl().setTool("layoutzoomin");
                break;
            }
            case "layout-navigation-zoom-out-topoint": {
                this.layout.getLayoutControl().setTool("layoutzoomout");
                break;
            }
            case "layout-navigation-zoom-all": {
                this.layout.getLayoutControl().fullRect();
                break;
            }
            case "layout-navigation-zoom-real": {
                zooms.realZoom();
                break;
            }
            case "layout-navigation-zoom-out-center": {
                zooms.zoomOut();
                break;
            }
            case "layout-navigation-zoom-in-center": {
                zooms.zoomIn();
                break;
            }
            case "layout-navigation-zoom-selected": {
                zooms.zoomSelect();
                break;
            }
            case "application-layout-template-save": {
                this.saveLayout();
                break;
            }
        }
    }

    private void saveLayout() {
        int resp;
        String path;
        I18nManager i18n = ToolsLocator.getI18nManager();
        this.layout = (LayoutPanel)PluginServices.getMDIManager().getActiveWindow();
        FileDialogChooserManager manager = ToolsUtilLocator.getFileDialogChooserManager();
        FileDialogChooser fc = manager.create("_Last_layout_template_folder");
        GenericFileFilter layoutMainFilter = new GenericFileFilter(".gvslt", i18n.getTranslation("_Layout_template") + " (*" + ".gvslt" + ")");
        fc.addChoosableFileFilter((FileFilter)layoutMainFilter);
        fc.setFileFilter((FileFilter)layoutMainFilter);
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        PreferencesNode prefs = application.getPreferences("gvsig.foldering");
        File projectfile = application.getCurrentProject().getFile();
        AccesoryPanelForTemplates accesory = new AccesoryPanelForTemplates(projectfile, fc);
        fc.setAccessory((JComponent)accesory);
        File folder = manager.getLastPath("_Last_layout_template_folder", new File(""));
        if ((folder == null || StringUtils.isBlank((CharSequence)folder.getPath())) && projectfile != null) {
            folder = projectfile.getParentFile();
        }
        if ((folder == null || StringUtils.isBlank((CharSequence)folder.getPath())) && StringUtils.isNotBlank((CharSequence)(path = prefs.get("TemplatesFolder", null)))) {
            folder = new File(path);
        }
        if (folder == null || StringUtils.isBlank((CharSequence)folder.getPath())) {
            folder = ToolsLocator.getFoldersManager().getHome();
        }
        if (fc.showSaveDialog((Component)PluginServices.getMainFrame(), folder) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        if (!file.getPath().endsWith(".gvslt".toLowerCase()) && !file.getPath().endsWith(".gvslt")) {
            file = new File(file.getPath() + ".gvslt");
        }
        if (file.exists() && (resp = JOptionPane.showConfirmDialog((Component)PluginServices.getMainFrame(), PluginServices.getText((Object)((Object)this), (String)"fichero_ya_existe_seguro_desea_guardarlo"), PluginServices.getText((Object)((Object)this), (String)"guardar"), 0)) != 0) {
            return;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file.getAbsolutePath());
            PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
            PersistentState persistentState = persistenceManager.getState((Object)this.layout);
            persistenceManager.saveState(persistentState, (OutputStream)fos);
        }
        catch (Exception e) {
            NotificationManager.addError((String)PluginServices.getText((Object)((Object)this), (String)"Error_guardando_la_plantilla"), (Throwable)e);
        }
    }

    public boolean isVisible() {
        IWindow f = PluginServices.getMDIManager().getActiveWindow();
        if (f == null) {
            return false;
        }
        return f instanceof LayoutPanel;
    }

    public void initialize() {
        this.registerPersistence();
        this.registerIcons();
    }

    public void postInitialize() {
        LayoutReportActionFactory.selfRegister();
    }

    private void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        JavaTextFactory factory = new JavaTextFactory();
        manager.registerFactory((PersistenceFactory)factory);
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"application-layout-template-save", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"application-project-gotofolder", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"application-layout-gotodefaulttemplatesfolder", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-navigation-zoom-in-center", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-navigation-zoom-out-center", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-navigation-zoom-in-topoint", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-navigation-zoom-out-topoint", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-navigation-zoom-all", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-navigation-zoom-real", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-navigation-zoom-selected", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-navigation-pan", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-view-navigation-zoom-in-topoint", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-view-navigation-zoom-out-topoint", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-view-navigation-zoom-all", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"layout-view-navigation-pan", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-layout-navigation-zoom-in-topoint", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-layout-navigation-zoom-out-topoint", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-selection-by-rectangle", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-selection-simple", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-selection-complex", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-layout-graphic-edit-vertex", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-layout-insert-circle", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-layout-insert-polyline", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-layout-insert-point", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-layout-insert-polygon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-layout-insert-rectangle", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-layout-view-navigation-zoom-in-topoint", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"cursor", (String)"cursor-layout-view-navigation-zoom-out-topoint", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"document", (String)"document-map-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"document", (String)"document-map-icon-sel", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"neresize-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"eresize-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"nresize-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"graphic-move-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"sereresize-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"symboltag-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"numero-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"barra1-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"barra2-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"barra3-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-left-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-center-v-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-right-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"left-rotation-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-up-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-center-h-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-down-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-distup-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-distcenterh-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-distdown-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-distleft-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-distcenterv-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-distright-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-size-width-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-size-height-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-size-other-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-space-right-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-space-down-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"text-inlayout-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"layout-pan-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"view-pan-icon", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"layout", (String)"right-rotation-icon", (Object)((Object)this));
    }

    public boolean isEnabled() {
        return true;
    }

    public LayoutPanel getLayout() {
        return this.layout;
    }

    public IPreference[] getPreferencesPages() {
        return new IPreference[]{new LayoutPage()};
    }

    public static class AccesoryPanelForTemplates
    extends JPanel {
        public AccesoryPanelForTemplates(File projectfile, FileDialogChooser fc) {
            I18nManager i18n = ToolsLocator.getI18nManager();
            ApplicationManager application = ApplicationLocator.getApplicationManager();
            PreferencesNode prefs = application.getPreferences("gvsig.foldering");
            String prefsPath = prefs.get("TemplatesFolder", null);
            BoxLayout l = new BoxLayout(this, 3);
            this.setLayout(l);
            ImageIcon projectIcon = ToolsSwingLocator.getIconThemeManager().getActive().get("application-project-gotofolder");
            JButton goToProjectButton = new JButton(projectIcon);
            goToProjectButton.setToolTipText(i18n.getTranslation("_Go_to_folder_project"));
            this.add(goToProjectButton);
            if (projectfile != null) {
                goToProjectButton.addActionListener(e -> fc.setCurrentDirectory(projectfile.getParentFile()));
                goToProjectButton.setEnabled(true);
            } else {
                goToProjectButton.setEnabled(false);
            }
            ImageIcon templatesIcon = ToolsSwingLocator.getIconThemeManager().getActive().get("application-layout-gotodefaulttemplatesfolder");
            JButton goToTemplatesButton = new JButton(templatesIcon);
            goToTemplatesButton.setToolTipText(i18n.getTranslation("_Go_to_default_templates_folder"));
            this.add(goToTemplatesButton);
            goToTemplatesButton.addActionListener(e -> {
                File prefsFile = new File(prefsPath);
                if (prefsFile.exists()) {
                    fc.setCurrentDirectory(prefsFile);
                }
            });
            goToTemplatesButton.setEnabled(StringUtils.isNotBlank((CharSequence)prefsPath));
        }
    }
}

