/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import java.awt.Component;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.ApplicationManager;
import org.gvsig.app.extension.LayoutExtension;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.Document;
import org.gvsig.app.project.documents.layout.DefaultLayoutManager;
import org.gvsig.app.project.documents.layout.LayoutDocument;
import org.gvsig.app.project.documents.layout.LayoutManager;
import org.gvsig.app.project.documents.layout.contextmenu.gui.BeforeLayoutMenuEntry;
import org.gvsig.app.project.documents.layout.contextmenu.gui.BehindLayoutMenuEntry;
import org.gvsig.app.project.documents.layout.contextmenu.gui.CancelLayoutMenuEntry;
import org.gvsig.app.project.documents.layout.contextmenu.gui.CopyLayoutMenuEntry;
import org.gvsig.app.project.documents.layout.contextmenu.gui.CutLayoutMenuEntry;
import org.gvsig.app.project.documents.layout.contextmenu.gui.PasteLayoutMenuEntry;
import org.gvsig.app.project.documents.layout.contextmenu.gui.PositionLayoutMenuEntry;
import org.gvsig.app.project.documents.layout.contextmenu.gui.PropertyLayoutMenuEntry;
import org.gvsig.app.project.documents.layout.contextmenu.gui.RefreshLayoutMenuEntry;
import org.gvsig.app.project.documents.layout.contextmenu.gui.SelectAllLayoutMenuEntry;
import org.gvsig.app.project.documents.layout.contextmenu.gui.SimplifyLayoutMenuEntry;
import org.gvsig.app.project.documents.layout.contextmenu.gui.TerminateLayoutMenuEntry;
import org.gvsig.app.project.documents.layout.fframes.FFrame;
import org.gvsig.app.project.documents.layout.fframes.FFrameBasicFactory;
import org.gvsig.app.project.documents.layout.fframes.FFrameGraphicsFactory;
import org.gvsig.app.project.documents.layout.fframes.FFrameGridFactory;
import org.gvsig.app.project.documents.layout.fframes.FFrameGroupFactory;
import org.gvsig.app.project.documents.layout.fframes.FFrameLegendFactory;
import org.gvsig.app.project.documents.layout.fframes.FFrameNorthFactory;
import org.gvsig.app.project.documents.layout.fframes.FFrameOverViewFactory;
import org.gvsig.app.project.documents.layout.fframes.FFramePictureFactory;
import org.gvsig.app.project.documents.layout.fframes.FFrameScaleBarFactory;
import org.gvsig.app.project.documents.layout.fframes.FFrameSymbolFactory;
import org.gvsig.app.project.documents.layout.fframes.FFrameTable;
import org.gvsig.app.project.documents.layout.fframes.FFrameTableFactory;
import org.gvsig.app.project.documents.layout.fframes.FFrameTextFactory;
import org.gvsig.app.project.documents.layout.fframes.FFrameView;
import org.gvsig.app.project.documents.layout.fframes.FFrameViewFactory;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameBoxDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameGraphicsDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameGridDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameGroupDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameLegendDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameNorthDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameOverViewDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFramePictureDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameScaleBarDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameTextDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameViewDialog;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.filedialogchooser.FileDialogChooser;
import org.gvsig.filedialogchooser.FileDialogChooserManager;
import org.gvsig.i18n.Messages;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.extensionpoint.ExtensionPointManager;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;
import org.gvsig.tools.util.ToolsUtilLocator;
import org.gvsig.utils.GenericFileFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LayoutMainExtension
extends Extension {
    private static final Logger logger = LoggerFactory.getLogger(FFrameView.class);
    public static final String LAYOUT_TEMPLATE_FILECHOOSER_ID = "LAYOUT_TEMPLATE_FILECHOOSER_ID";

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"application-layout-template-open", (Object)((Object)this));
        IconThemeHelper.registerIcon((String)"action", (String)"application-layout-new", (Object)((Object)this));
    }

    public void initialize() {
        this.registerIcons();
    }

    public void postInitialize() {
        super.postInitialize();
        this.initializeDocumentActionsExtensionPoint();
        this.registerDocuments();
        this.registerFFrames();
        this.registerContextMenuOptions();
    }

    public void execute(String actionCommand) {
        if ("application-layout-template-open".equals(actionCommand)) {
            this.openLayout();
        } else if ("application-layout-new".equals(actionCommand)) {
            this.newLayout();
        }
    }

    private void newLayout() {
        ApplicationManager application = ApplicationLocator.getManager();
        ProjectManager projectManager = ApplicationLocator.getProjectManager();
        I18nManager i18nManager = ToolsLocator.getI18nManager();
        Project project = projectManager.getCurrentProject();
        Iterator documents = projectManager.createDocumentsByUser("project.document.layout");
        while (documents != null && documents.hasNext()) {
            try {
                Document document = (Document)documents.next();
                project.addDocument(document);
                IWindow window = document.getFactory().getMainWindow(document);
                if (window == null) {
                    application.messageDialog(i18nManager.getTranslation("error_opening_the_document"), i18nManager.getTranslation("warning"), 2);
                    continue;
                }
                application.getUIManager().addWindow(window, 1816);
                try {
                    application.getUIManager().setMaximum(window, true);
                }
                catch (PropertyVetoException e) {
                    logger.info("Can't maximize layout.", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.warn("Problems creating a Layout document.", (Throwable)e);
            }
        }
    }

    private void openLayout() {
        LayoutPanel layout = null;
        I18nManager i18n = ToolsLocator.getI18nManager();
        FileDialogChooserManager manager = ToolsUtilLocator.getFileDialogChooserManager();
        FileDialogChooser fc = manager.create("_Last_layout_template_folder");
        GenericFileFilter layoutMainFilter = new GenericFileFilter(".gvslt", i18n.getTranslation("_Layout_template") + " (*" + ".gvslt" + ")");
        fc.addChoosableFileFilter((FileFilter)layoutMainFilter);
        fc.setFileFilter((FileFilter)layoutMainFilter);
        ApplicationManager application = ApplicationLocator.getApplicationManager();
        File projectfile = application.getCurrentProject().getFile();
        LayoutExtension.AccesoryPanelForTemplates accesory = new LayoutExtension.AccesoryPanelForTemplates(projectfile, fc);
        fc.setAccessory((JComponent)accesory);
        if (fc.showOpenDialog((Component)PluginServices.getMainFrame()) == 0) {
            File file = fc.getSelectedFile();
            try {
                if (!file.exists()) {
                    File auxfile = new File(file.getPath() + ".gvslt");
                    if (!auxfile.exists()) {
                        throw new IOException("File does not exist: " + file.getName());
                    }
                    file = auxfile;
                }
                File xmlFile = new File(file.getAbsolutePath());
                FileInputStream is = new FileInputStream(xmlFile);
                PersistenceManager persistenceManager = ToolsLocator.getPersistenceManager();
                PersistentState persistentState = persistenceManager.loadState((InputStream)is);
                layout = (LayoutPanel)persistenceManager.create(persistentState);
            }
            catch (Exception e) {
                String tit = Messages.getText((String)"_Layout_template");
                String msg = e instanceof PersistenceException ? Messages.getText((String)"_Bad_format_in_layout_template") : Messages.getText((String)"_Cant_load_layout_template");
                msg = msg + ": " + file.getPath();
                msg = msg + "\n" + e.getMessage();
                logger.warn(msg, (Throwable)e);
                JOptionPane.showMessageDialog(ApplicationLocator.getManager().getRootComponent(), msg, tit, 0);
            }
            if (layout == null) {
                return;
            }
            LayoutDocument layoutDocument = (LayoutDocument)layout.getDocument();
            Project p = ApplicationLocator.getManager().getProjectManager().getCurrentProject();
            p.addDocument((Document)layoutDocument);
            layout.getLayoutControl().setTool("layoutselect");
            LayoutManager lm = (LayoutManager)layoutDocument.getFactory();
            layout.setLayoutManager(lm);
            PluginServices.getMDIManager().addWindow((IWindow)layout);
        }
    }

    private void registerDocuments() {
        DefaultLayoutManager.register();
    }

    private void registerFFrames() {
        DefaultLayoutManager layoutManager = (DefaultLayoutManager)ProjectManager.getInstance().getDocumentManager("project.document.layout");
        layoutManager.registerFrameFactory(new FFrameBasicFactory());
        layoutManager.registerFrameFactory(new FFrameGraphicsFactory());
        layoutManager.registerFrameFactory(new FFrameGroupFactory());
        layoutManager.registerFrameFactory(new FFrameLegendFactory());
        layoutManager.registerFrameFactory(new FFrameNorthFactory());
        layoutManager.registerFrameFactory(new FFrameOverViewFactory());
        layoutManager.registerFrameFactory(new FFramePictureFactory());
        layoutManager.registerFrameFactory(new FFrameScaleBarFactory());
        layoutManager.registerFrameFactory(new FFrameSymbolFactory());
        layoutManager.registerFrameFactory(new FFrameTableFactory());
        layoutManager.registerFrameFactory(new FFrameTextFactory());
        layoutManager.registerFrameFactory(new FFrameViewFactory());
        layoutManager.registerFrameFactory(new FFrameGridFactory());
        layoutManager.registerFFrameDialog("FFrameGraphics", FFrameGraphicsDialog.class);
        layoutManager.registerFFrameDialog("FFrameSymbol", FFrameGraphicsDialog.class);
        layoutManager.registerFFrameDialog("FFrameGroup", FFrameGroupDialog.class);
        layoutManager.registerFFrameDialog("FFrameTable", FFrameBoxDialog.class);
        layoutManager.registerFFrameDialog("FFrameLegend", FFrameLegendDialog.class);
        layoutManager.registerFFrameDialog("FFramePicture", FFramePictureDialog.class);
        layoutManager.registerFFrameDialog("FFrameNorth", FFrameNorthDialog.class);
        layoutManager.registerFFrameDialog("FFrameScaleBar", FFrameScaleBarDialog.class);
        layoutManager.registerFFrameDialog("FFrameText", FFrameTextDialog.class);
        layoutManager.registerFFrameDialog("FFrameView", FFrameViewDialog.class);
        layoutManager.registerFFrameDialog("FFrameOverView", FFrameOverViewDialog.class);
        layoutManager.registerFFrameDialog("FFrameGrid", FFrameGridDialog.class);
        FFrame.initializeIcons();
        FFrameTable.initializeIcons();
    }

    private void registerContextMenuOptions() {
        LayoutManager layoutManager = (LayoutManager)ProjectManager.getInstance().getDocumentManager("project.document.layout");
        layoutManager.registerLayoutMenuAction("Terminate", TerminateLayoutMenuEntry.class);
        layoutManager.registerLayoutMenuAction("Cancel", CancelLayoutMenuEntry.class);
        layoutManager.registerLayoutMenuAction("Copy", CopyLayoutMenuEntry.class);
        layoutManager.registerLayoutMenuAction("Cut", CutLayoutMenuEntry.class);
        layoutManager.registerLayoutMenuAction("Paste", PasteLayoutMenuEntry.class);
        layoutManager.registerLayoutMenuAction("Simplify", SimplifyLayoutMenuEntry.class);
        layoutManager.registerLayoutMenuAction("Property", PropertyLayoutMenuEntry.class);
        layoutManager.registerLayoutMenuAction("SelectAll", SelectAllLayoutMenuEntry.class);
        layoutManager.registerLayoutMenuAction("Behind", BehindLayoutMenuEntry.class);
        layoutManager.registerLayoutMenuAction("Before", BeforeLayoutMenuEntry.class);
        layoutManager.registerLayoutMenuAction("Position", PositionLayoutMenuEntry.class);
        layoutManager.registerLayoutMenuAction("Refresh", RefreshLayoutMenuEntry.class);
    }

    private void initializeDocumentActionsExtensionPoint() {
        ExtensionPointManager epMan = ToolsLocator.getExtensionPointManager();
        epMan.add("DocumentActions_Map", "Context menu options of the map document list in the project window (register instances of org.gvsig.app.project.AbstractDocumentContextMenuAction)");
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isVisible() {
        return true;
    }
}

