/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension;

import org.gvsig.andami.IconThemeHelper;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.messages.NotificationManager;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.tools.undo.UndoException;

public class LayoutUndoExtension
extends Extension {
    public void initialize() {
        this.registerIcons();
    }

    private void registerIcons() {
        IconThemeHelper.registerIcon((String)"action", (String)"edit-undo", (Object)((Object)this));
    }

    public void execute(String actionCommand) {
        LayoutPanel layout = (LayoutPanel)PluginServices.getMDIManager().getActiveWindow();
        if (actionCommand.equals("edit-undo-layout")) {
            try {
                layout.getLayoutContext().getFrameCommandsRecord().undo();
            }
            catch (UndoException e) {
                NotificationManager.showMessageError((String)"Undo layout", (Exception)((Object)e));
            }
            layout.getLayoutContext().updateFFrames();
            layout.getLayoutControl().refresh();
            layout.getDocument().setModified(true);
        }
    }

    public boolean isEnabled() {
        LayoutPanel layout;
        return PluginServices.getMDIManager().getActiveWindow() instanceof LayoutPanel && (layout = (LayoutPanel)PluginServices.getMDIManager().getActiveWindow()).getLayoutContext().getFrameCommandsRecord().canUndo() && layout.getLayoutContext().isEditable();
    }

    public boolean isVisible() {
        return PluginServices.getMDIManager().getActiveWindow() instanceof LayoutPanel;
    }
}

