/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.extension.reportfromlayout;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.gvsig.andami.plugins.Extension;
import org.gvsig.app.ApplicationLocator;
import org.gvsig.app.extension.reportfromlayout.ConfigureReportFromLayout;
import org.gvsig.app.project.Project;
import org.gvsig.app.project.documents.layout.LayoutDocument;
import org.gvsig.app.project.documents.layout.report.LayoutReportActionParameters;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.i18n.I18nManager;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.windowmanager.Dialog;
import org.gvsig.tools.swing.api.windowmanager.WindowManager;
import org.gvsig.tools.swing.api.windowmanager.WindowManager_v2;

public class ConfigureReportFromLayoutExtension
extends Extension {
    public void initialize() {
    }

    public void execute(String actionCommand) {
        switch (actionCommand.toLowerCase()) {
            case "layout-configurereportfromlayout": {
                this.doConfigureReportFromLayout();
            }
        }
    }

    public boolean isEnabled() {
        Project currentProject = ApplicationLocator.getProjectManager().getCurrentProject();
        if (currentProject == null) {
            return false;
        }
        List layouts = currentProject.getDocuments(LayoutDocument.class);
        return layouts != null && !layouts.isEmpty();
    }

    public boolean isVisible() {
        return true;
    }

    private void doConfigureReportFromLayout() {
        WindowManager_v2 windowManager = (WindowManager_v2)ToolsSwingLocator.getWindowManager();
        final ConfigureReportFromLayout panel = new ConfigureReportFromLayout();
        I18nManager i18n = ToolsLocator.getI18nManager();
        final Dialog dialog = windowManager.createDialog((JComponent)panel, i18n.getTranslation("_Configure_report_from_layout"), i18n.getTranslation("_Configure_a_report_from_a_layout"), 3);
        dialog.setAutoclose(false);
        dialog.setButtonLabel(1, i18n.getTranslation("_Configure_report"));
        dialog.setButtonLabel(2, i18n.getTranslation("_Close"));
        dialog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                switch (dialog.getAction()) {
                    case 1: {
                        dialog.setButtonEnabled(1, false);
                        LayoutReportActionParameters params = LayoutReportActionParameters.create();
                        panel.fetch(params);
                        if (!panel.doConfigureReportFromLayout(params, panel.getLayoutDocument(), panel.getStore())) break;
                        ((JComponent)dialog).setVisible(false);
                        break;
                    }
                    case 2: {
                        ((JComponent)dialog).setVisible(false);
                    }
                }
            }
        });
        panel.setDialog(dialog);
        dialog.show(WindowManager.MODE.WINDOW, Collections.singletonMap("align", 10));
    }
}

