/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.gvsig.app.project.documents.layout.DefaultLayoutNotification;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.commands.FrameCommandsRecord;
import org.gvsig.app.project.documents.layout.fframes.FFrameGroup;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameUseFMap;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.fmap.geom.GeometryLocator;
import org.gvsig.fmap.geom.GeometryManager;
import org.gvsig.fmap.geom.exception.CreateEnvelopeException;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.ObservableHelper;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLayoutFunctions
implements Observable {
    protected static final Logger LOG = LoggerFactory.getLogger(FLayoutFunctions.class);
    private static final GeometryManager geomManager = GeometryLocator.getGeometryManager();
    private static final Logger logger = LoggerFactory.getLogger(FLayoutFunctions.class);
    private LayoutPanel layout = null;
    private final ObservableHelper observers;

    public FLayoutFunctions(LayoutPanel layoutPanel) {
        this.layout = layoutPanel;
        this.observers = new ObservableHelper();
        this.observers.addObserver((Observer)layoutPanel.getLayoutControl());
    }

    public void setSelect() {
        boolean isUpdate = false;
        this.layout.getLayoutContext().updateFFrames();
        IFFrame[] fframes = this.layout.getLayoutContext().getFFrames();
        FrameCommandsRecord efs = this.layout.getLayoutContext().getFrameCommandsRecord();
        efs.startComplex("move");
        IFFrame[] iFFrameArray = fframes;
        int n = iFFrameArray.length;
        for (int i = 0; i < n; ++i) {
            Rectangle rect;
            IFFrame fframe1;
            IFFrame fframe = fframe1 = iFFrameArray[i];
            int difx = this.layout.getLayoutControl().getLastPoint().x - this.layout.getLayoutControl().getFirstPoint().x;
            int dify = this.layout.getLayoutControl().getLastPoint().y - this.layout.getLayoutControl().getFirstPoint().y;
            if ((Math.abs(difx) > 3 || Math.abs(dify) > 3) && fframe.getSelected() != 0) {
                Rectangle2D rectangle = fframe.getLastMoveRect();
                if (rectangle == null) {
                    efs.endComplex();
                    return;
                }
                if (fframe instanceof FFrameGroup) {
                    ((FFrameGroup)fframe).setAt(this.layout.getLayoutControl().getAT());
                }
                try {
                    IFFrame fframeAux = (IFFrame)fframe.clone();
                    fframeAux.setBoundBox(FLayoutUtilities.toSheetRect(rectangle, this.layout.getLayoutControl().getAT()));
                    efs.update(fframe, fframeAux);
                    fframeAux.getBoundingBox(this.layout.getLayoutControl().getAT());
                    isUpdate = true;
                }
                catch (CloneNotSupportedException e) {
                    LOG.error("It is not possible clonate the object", (Throwable)e);
                }
            }
            if (this.layout.getLayoutControl().getReSel() == null) {
                rect = new Rectangle();
                rect.setFrameFromDiagonal(this.layout.getLayoutControl().getFirstPoint(), this.layout.getLayoutControl().getLastPoint());
            } else {
                rect = this.layout.getLayoutControl().getReSel();
            }
            if (this.layout.getLayoutControl().isReSel() && rect.contains(fframe.getBoundingBox(this.layout.getLayoutControl().getAT()))) {
                fframe.setSelected(true);
            }
            if (isUpdate) {
                this.observers.notifyObservers((Observable)this, (Object)new DefaultLayoutNotification("layout_invalidated"));
                continue;
            }
            this.observers.notifyObservers((Observable)this, (Object)new DefaultLayoutNotification("layout_validated"));
        }
        efs.endComplex();
        this.layout.getLayoutContext().updateFFrames();
    }

    public void setViewPan(Point p1, Point p2) {
        IFFrame[] fframes;
        for (IFFrame fframe1 : fframes = this.layout.getLayoutContext().getFFrames()) {
            Envelope envel;
            IFFrameUseFMap fframe;
            if (!(fframe1 instanceof IFFrameUseFMap) || (fframe = (IFFrameUseFMap)fframe1).getSelected() == 0 || fframe.getATMap() == null || (envel = fframe.getMapContext().getViewPort().getEnvelope()) == null) continue;
            double visible_factor = FLayoutFunctions.screenPixelToViewPortPixelRatio(this.layout, fframe.getBoundBox().getHeight(), fframe.getMapContext().getViewPort().getImageHeight());
            Point p1scaled = new Point((int)(visible_factor * p1.getX()), (int)(visible_factor * p1.getY()));
            Point p2scaled = new Point((int)(visible_factor * p2.getX()), (int)(visible_factor * p2.getY()));
            Point2D.Double mp1 = FLayoutFunctions.toMapPoint(p1scaled, fframe.getATMap());
            Point2D.Double mp2 = FLayoutFunctions.toMapPoint(p2scaled, fframe.getATMap());
            double x = envel.getMinimum(0) - (((Point2D)mp2).getX() - ((Point2D)mp1).getX());
            double y = envel.getMinimum(1) - (((Point2D)mp2).getY() - ((Point2D)mp1).getY());
            double width = envel.getLength(0);
            double height = envel.getLength(1);
            try {
                fframe.getMapContext().getViewPort().setEnvelope(geomManager.createEnvelope(x, y, x + width, y + height, 0));
            }
            catch (CreateEnvelopeException e) {
                logger.error("Error creating the envelope", (Throwable)e);
            }
            fframe.refresh();
            if (!fframe.getExtentSynced()) continue;
            fframe.refreshOriginalExtent();
        }
    }

    public void setScale(long scale) {
        IFFrameUseFMap[] selectedFrames = this.layout.getLayoutContext().getSelectedFFrames(IFFrameUseFMap.class);
        if (selectedFrames.length == 1) {
            IFFrameUseFMap fframe = selectedFrames[0];
            fframe.setScale(scale);
        }
    }

    public void addLayer() {
    }

    public static Point2D.Double toMapPoint(Point2D pScreen, AffineTransform at1) {
        Point2D.Double pWorld = new Point2D.Double();
        try {
            AffineTransform at = at1.createInverse();
            at.transform(pScreen, pWorld);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return pWorld;
    }

    public void addObserver(Observer o) {
        this.observers.addObserver(o);
    }

    public void deleteObserver(Observer o) {
        this.observers.deleteObserver(o);
    }

    public void deleteObservers() {
        this.observers.deleteObservers();
    }

    public static double screenPixelToViewPortPixelRatio(LayoutPanel lyt_panel, double frame_height_cm, int frame_vp_img_height) {
        double sheet_height_screen_pix = lyt_panel.getLayoutControl().getRect().getHeight();
        int ori = lyt_panel.getLayoutContext().getAttributes().getPageFormat().getOrientation();
        double paper_h_i72 = ori == 0 || ori == 2 ? lyt_panel.getLayoutContext().getAttributes().getPageFormat().getWidth() : lyt_panel.getLayoutContext().getAttributes().getPageFormat().getHeight();
        double paper_h_cm = 0.035277777777777776 * paper_h_i72;
        double frame_part = frame_height_cm / paper_h_cm;
        double pixels_fview_screen_h = sheet_height_screen_pix * frame_part;
        double pixels_fview_vp_h = 1.0 * (double)frame_vp_img_height;
        return pixels_fview_vp_h / pixels_fview_screen_h;
    }

    public static String getLastMessage(Throwable ex) {
        Throwable p;
        if (ex == null) {
            return "[null]";
        }
        for (p = ex; p.getCause() != null && p.getCause() != p; p = p.getCause()) {
        }
        return p.getMessage();
    }
}

