/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.app.project.ProjectManager;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.LayoutManager;
import org.gvsig.app.project.documents.layout.fframes.FFrameGroup;
import org.gvsig.app.project.documents.layout.fframes.FFrameLegend;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.IFFrameUseFMap;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.FFrameDialogNotification;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.IFFrameDialog;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.layout.gui.dialogs.FAlignDialog;
import org.gvsig.app.project.documents.layout.gui.dialogs.FBorderDialog;
import org.gvsig.app.project.documents.layout.gui.dialogs.FPositionDialog;
import org.gvsig.tools.observer.Observable;
import org.gvsig.tools.observer.Observer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FLayoutGraphics {
    protected static final Logger LOG = LoggerFactory.getLogger(FLayoutGraphics.class);
    private final LayoutPanel layout;
    private FAlignDialog m_alignLayout = null;
    private FBorderDialog borderdialog = null;
    private FPositionDialog positiondialog = null;
    private LayoutManager layoutManager = null;

    public FLayoutGraphics(LayoutPanel layoutPanel) {
        this.layout = layoutPanel;
        this.layoutManager = (LayoutManager)ProjectManager.getInstance().getDocumentManager("project.document.layout");
    }

    public void simplify() {
        this.layout.getLayoutContext().getFrameCommandsRecord().startComplex(PluginServices.getText((Object)this, (String)"simplify"));
        IFFrame[] fframes = this.layout.getLayoutContext().getFFrames();
        for (int i = fframes.length - 1; i >= 0; --i) {
            IFFrame fframe = fframes[i];
            if (!(fframe instanceof FFrameLegend) || fframe.getSelected() == 0) continue;
            ((FFrameLegend)fframe).toFFrames(this.layout.getLayoutContext());
        }
        this.layout.getLayoutContext().getFrameCommandsRecord().endComplex();
        this.layout.getLayoutControl().refresh();
    }

    public void grouping() {
        FFrameGroup fframegroup = (FFrameGroup)this.layoutManager.createFrame("FFrameGroup");
        IFFrame[] fframes = this.layout.getLayoutContext().getFFrames();
        if (fframes.length > 1) {
            int i;
            ArrayList<IFFrame> selecList = new ArrayList<IFFrame>();
            for (i = fframes.length - 1; i >= 0; --i) {
                IFFrame fframe = fframes[i];
                if (fframe.getSelected() == 0) continue;
                selecList.add(fframe);
                this.layout.getLayoutContext().delFFrame(fframe);
            }
            for (i = selecList.size() - 1; i >= 0; --i) {
                fframegroup.addFFrame((IFFrame)selecList.get(i));
            }
            fframegroup.setAt(this.layout.getLayoutControl().getAT());
            Rectangle2D.Double rd = fframegroup.getRectangle(this.layout.getLayoutControl().getAT());
            Rectangle2D.Double rd1 = FLayoutUtilities.toSheetRect(rd, this.layout.getLayoutControl().getAT());
            fframegroup.setBoundBox(rd1);
            fframegroup.setSelected(true);
            this.layout.getLayoutContext().addFFrame(fframegroup, true, true);
            this.layout.getLayoutControl().refresh();
        }
    }

    public void ungrouping() {
        this.layout.getLayoutContext().getFrameCommandsRecord().startComplex(PluginServices.getText((Object)this, (String)"ungroup"));
        IFFrame[] fframes = this.layout.getLayoutContext().getFFrames();
        for (int i = fframes.length - 1; i >= 0; --i) {
            int j;
            IFFrame fframe = fframes[i];
            if (fframe.getSelected() == 0 || !(fframe instanceof FFrameGroup)) continue;
            FFrameGroup fframegroup = (FFrameGroup)fframe;
            ArrayList<IFFrame> selecList = new ArrayList<IFFrame>();
            for (j = fframegroup.getFFrames().length - 1; j >= 0; --j) {
                selecList.add(fframegroup.getFFrames()[j]);
            }
            for (j = selecList.size() - 1; j >= 0; --j) {
                IFFrame frame = (IFFrame)selecList.get(j);
                frame.setRotation(frame.getRotation() + fframe.getRotation());
                this.layout.getLayoutContext().addFFrameSameProperties(frame);
            }
            this.layout.getLayoutContext().delFFrame(fframegroup);
        }
        this.layout.getLayoutContext().getFrameCommandsRecord().endComplex();
        this.layout.getLayoutControl().refresh();
    }

    public void aligning() {
        this.m_alignLayout = new FAlignDialog(this.layout);
        PluginServices.getMDIManager().addWindow((IWindow)this.m_alignLayout);
    }

    public void before() {
        this.layout.getLayoutContext().getFrameCommandsRecord().startComplex(PluginServices.getText((Object)this, (String)"change_before"));
        IFFrame[] fframes = this.layout.getLayoutContext().getFFrames();
        for (int i = fframes.length - 1; i >= 0; --i) {
            IFFrame fframe = fframes[i];
            if (fframe.getSelected() == 0) continue;
            if (fframe instanceof FFrameGroup) {
                ((FFrameGroup)fframe).setAt(this.layout.getLayoutControl().getAT());
            }
            try {
                IFFrame fframeAux = (IFFrame)fframe.clone();
                fframeAux.setLevel(this.layout.getLayoutContext().getNumBefore());
                this.layout.getLayoutContext().getFrameCommandsRecord().update(fframe, fframeAux);
                fframeAux.getBoundingBox(this.layout.getLayoutControl().getAT());
                continue;
            }
            catch (CloneNotSupportedException e) {
                LOG.error("It is not possible clonate the object", (Throwable)e);
            }
        }
        this.layout.getLayoutContext().getFrameCommandsRecord().endComplex();
        this.layout.getLayoutContext().updateFFrames();
        this.layout.getLayoutControl().refresh();
    }

    public void behind() {
        this.layout.getLayoutContext().getFrameCommandsRecord().startComplex(PluginServices.getText((Object)this, (String)"change_behind"));
        IFFrame[] fframes = this.layout.getLayoutContext().getFFrames();
        for (int i = fframes.length - 1; i >= 0; --i) {
            IFFrame fframe = fframes[i];
            if (fframe.getSelected() == 0) continue;
            if (fframe instanceof FFrameGroup) {
                ((FFrameGroup)fframe).setAt(this.layout.getLayoutControl().getAT());
            }
            try {
                IFFrame fframeAux = (IFFrame)fframe.clone();
                fframeAux.setLevel(this.layout.getLayoutContext().getNumBehind());
                this.layout.getLayoutContext().getFrameCommandsRecord().update(fframe, fframeAux);
                fframeAux.getBoundingBox(this.layout.getLayoutControl().getAT());
                continue;
            }
            catch (CloneNotSupportedException e) {
                LOG.error("It is not possible clonate the object", (Throwable)e);
            }
        }
        this.layout.getLayoutContext().getFrameCommandsRecord().endComplex();
        this.layout.getLayoutContext().updateFFrames();
        this.layout.getLayoutControl().refresh();
    }

    public void openFrameDialog(Observer observer) {
        IFFrame frame;
        IFFrameDialog fframeDialog;
        IFFrame[] selecList = this.layout.getLayoutContext().getSelectedFFrames();
        if (selecList.length == 1 && (fframeDialog = (IFFrameDialog)this.layout.createFFrameDialog(frame = selecList[0])) != null) {
            Observer onPanelClosedObserver = (observable, notification) -> {
                if (notification instanceof FFrameDialogNotification && ((FFrameDialogNotification)((Object)((Object)notification))).getType() == "DialogClosed") {
                    this.onDialogClosed(fframeDialog, frame, observer);
                }
            };
            fframeDialog.addObserver(onPanelClosedObserver);
            if (observer != null) {
                fframeDialog.addObserver(observer);
            }
            PluginServices.getMDIManager().addWindow((IWindow)fframeDialog);
        }
    }

    public void openFrameDialog() {
        this.openFrameDialog(null);
    }

    @Deprecated
    public boolean openFFrameDialog() {
        this.openFrameDialog(null);
        return true;
    }

    protected void onDialogClosed(IFFrameDialog dialog, IFFrame oldFrame, Observer observer) {
        IFFrame fframeAux = dialog.getFFrame();
        if (fframeAux != null) {
            if (fframeAux instanceof IFFrameUseFMap) {
                ((IFFrameUseFMap)fframeAux).refresh();
            }
            this.layout.getLayoutContext().getFrameCommandsRecord().update(oldFrame, fframeAux);
            fframeAux.getBoundingBox(this.layout.getLayoutControl().getAT());
            this.layout.getLayoutContext().updateFFrames();
            this.layout.getLayoutControl().setIsReSel(true);
            this.layout.getLayoutControl().refresh();
            if (observer != null) {
                observer.update((Observable)dialog, (Object)new FFrameDialogNotification("FrameCreated"));
            }
        }
    }

    public void selecAll() {
        IFFrame[] fframes = this.layout.getLayoutContext().getFFrames();
        for (int i = fframes.length - 1; i >= 0; --i) {
            IFFrame fframe = fframes[i];
            fframe.setSelected(true);
        }
        this.layout.getLayoutControl().refresh();
    }

    public boolean border() {
        this.borderdialog = new FBorderDialog(this.layout);
        PluginServices.getMDIManager().addWindow((IWindow)this.borderdialog);
        return this.borderdialog.isAccepted();
    }

    public void position() {
        IFFrame[] fframes = this.layout.getLayoutContext().getSelectedFFrames();
        if (fframes.length != 0) {
            for (IFFrame fframe : fframes) {
                this.positiondialog = new FPositionDialog(this.layout, fframe);
                PluginServices.getMDIManager().addWindow((IWindow)this.positiondialog);
            }
        }
    }
}

