/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.fmap.geom.GeometryUtils;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FFrameGridCoordinateFormat
implements Persistent {
    public static final int FORMAT_DD = 0;
    public static final int FORMAT_DMS = 1;
    private static final String TYPE_FIELD = "Type";
    private static final String DMSFORMAT_FIELD = "DMSFormat";
    private static final String PATTERN_FIELD = "pattern";
    private static final String DECIMAL_SEP_FIELD = "decimalSep";
    private static final String GROUPING_SEP_FIELD = "groupingSep";
    public static final String PERSISTENCE_DEFINITION_NAME = "FFrameGridCoordinateFormat";
    public static final String PERSISTENCE_DEFINITION_DESCRIPTION = "FFrameGridCoordinateFormat persistence definition";
    private DecimalFormat dd_format = new DecimalFormat("#0.00", DecimalFormatSymbols.getInstance());
    private String dms_format = "%-%d\u00b0 %m' %.0s''";
    private int type = 0;

    public FFrameGridCoordinateFormat() {
    }

    public FFrameGridCoordinateFormat(String pattern, DecimalFormatSymbols sym) {
        this.dd_format = new DecimalFormat(pattern, sym);
    }

    public void setType(int type) {
        this.type = type;
    }

    public String format(double value) {
        switch (this.type) {
            case 1: {
                return GeometryUtils.formatCoordinate((String)this.dms_format, (double)value);
            }
        }
        return this.dd_format.format(value);
    }

    public String format(String NS, double value) {
        switch (this.type) {
            case 1: {
                return GeometryUtils.formatCoordinate((String)this.dms_format, (String)NS, (double)value);
            }
        }
        return this.dd_format.format(value);
    }

    public boolean isGroupingUsed() {
        return this.dd_format.isGroupingUsed();
    }

    public int getMinimumFractionDigits() {
        return this.dd_format.getMinimumFractionDigits();
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        return this.dd_format.getDecimalFormatSymbols();
    }

    public void setDMSFormat(String format) {
        this.dms_format = format;
    }

    public void setDecimalFormat(DecimalFormat dd_format) {
        this.dd_format = dd_format;
    }

    public DecimalFormat getDecimalFormat() {
        return this.dd_format;
    }

    public void saveToState(PersistentState state) throws PersistenceException {
        state.set(TYPE_FIELD, this.type);
        state.set(DMSFORMAT_FIELD, this.dms_format);
        state.set(PATTERN_FIELD, this.dd_format.toPattern());
        state.set(DECIMAL_SEP_FIELD, String.valueOf(this.dd_format.getDecimalFormatSymbols().getDecimalSeparator()));
        state.set(GROUPING_SEP_FIELD, String.valueOf(this.dd_format.getDecimalFormatSymbols().getGroupingSeparator()));
    }

    public void loadFromState(PersistentState state) throws PersistenceException {
        this.type = state.getInt(TYPE_FIELD);
        this.dms_format = state.getString(DMSFORMAT_FIELD);
        String pattern = state.getString(PATTERN_FIELD);
        String decimalSep = state.getString(DECIMAL_SEP_FIELD);
        String groupingSep = state.getString(GROUPING_SEP_FIELD);
        DecimalFormatSymbols sym = DecimalFormatSymbols.getInstance();
        if (StringUtils.isNotEmpty((CharSequence)decimalSep)) {
            sym.setDecimalSeparator(decimalSep.charAt(0));
        }
        if (StringUtils.isNotEmpty((CharSequence)groupingSep)) {
            sym.setGroupingSeparator(groupingSep.charAt(0));
        }
        this.dd_format = new DecimalFormat(pattern, sym);
    }

    public static void registerPersistence() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(FFrameGridCoordinateFormat.class, PERSISTENCE_DEFINITION_NAME, PERSISTENCE_DEFINITION_DESCRIPTION, null, null);
            definition.addDynFieldInt(TYPE_FIELD).setMandatory(true);
            definition.addDynFieldString(DMSFORMAT_FIELD).setMandatory(false);
            definition.addDynFieldString(PATTERN_FIELD).setMandatory(false);
            definition.addDynFieldString(DECIMAL_SEP_FIELD).setMandatory(false);
            definition.addDynFieldString(GROUPING_SEP_FIELD).setMandatory(false);
        }
    }
}

