/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.FLayoutUtilities;
import org.gvsig.app.project.documents.layout.LayoutContext;
import org.gvsig.app.project.documents.layout.fframes.AbstractFFrameViewDependence;
import org.gvsig.app.project.documents.layout.fframes.FFramePicture;
import org.gvsig.app.project.documents.layout.fframes.FFrameSymbol;
import org.gvsig.app.project.documents.layout.fframes.FFrameText;
import org.gvsig.app.project.documents.layout.fframes.IFFrameViewDependence;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.dal.exception.ReadException;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.layers.FLayer;
import org.gvsig.fmap.mapcontext.layers.FLayers;
import org.gvsig.fmap.mapcontext.layers.operations.Classifiable;
import org.gvsig.fmap.mapcontext.layers.operations.IHasImageLegend;
import org.gvsig.fmap.mapcontext.layers.vectorial.FLyrVect;
import org.gvsig.fmap.mapcontext.rendering.legend.IClassifiedLegend;
import org.gvsig.fmap.mapcontext.rendering.legend.ILegend;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.ITextSymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FFrameLegend
extends AbstractFFrameViewDependence
implements IFFrameViewDependence {
    public static final String PERSISTENCE_DEFINITION_NAME = "FFrameLegend";
    private static final String NUMLAYERS_FIELD = "numLayers";
    private static final String MAX_FIELD = "max";
    private static final String QUALITY_FIELD = "quality";
    private static final String VIEWING_FIELD = "viewing";
    private static final String FONT_FIELD = "font";
    private static final String NAMELAYERS_FIELD = "nameLayers";
    private static final String AREVISIBLE_FIELD = "areVisible";
    private static final int PRESENTACION = 0;
    private static final int BORRADOR = 1;
    private int m_quality = 0;
    private int m_viewing = 0;
    private Font m_font = new Font("SansSerif", 0, 9);
    private int m_max;
    private int m_numLayers;
    private FLayers layers = null;
    private List<String> nameLayers = new ArrayList<String>();
    private List<Boolean> areVisible = new ArrayList<Boolean>();
    private PrintAttributes properties;
    private final MapContextManager mapContextManager = MapContextLocator.getMapContextManager();

    public void setQuality(int q) {
        this.m_quality = q;
    }

    public int getQuality() {
        return this.m_quality;
    }

    public int getViewing() {
        return this.m_viewing;
    }

    public void setViewing(int v) {
        this.m_viewing = v;
    }

    @Override
    public void draw(Graphics2D g, AffineTransform at, Rectangle2D rv, BufferedImage imgBase) {
        Rectangle2D.Double re = this.getBoundingBox(at);
        g.rotate(Math.toRadians(this.getRotation()), re.x + re.width / 2.0, re.y + re.height / 2.0);
        if (this.fframeViewDependence != null && this.fframeViewDependence.getMapContext() != null) {
            this.layers = this.fframeViewDependence.getMapContext().getLayers();
        }
        this.m_max = 0;
        this.m_numLayers = 0;
        if (this.intersects(rv, re)) {
            if (this.layers == null) {
                this.drawEmpty(g);
            } else if (rv == null || this.getQuality() == 0) {
                this.m_numLayers = this.getSizeNum(this.layers);
                double h = re.getHeight() / (double)this.m_numLayers;
                int[] n = new int[]{0};
                this.drawLegendOrToFFrame(g, re, h, this.layers, n, null);
            } else if (this.getQuality() == 1) {
                this.drawDraft(g);
            }
        }
        g.rotate(Math.toRadians(-this.getRotation()), re.x + re.width / 2.0, re.y + re.height / 2.0);
    }

    private void drawLegendOrToFFrame(Graphics2D g, Rectangle2D re, double h, FLayers layers, int[] n, LayoutContext layoutContext) {
        float sizefont = re.getHeight() / (double)this.m_numLayers < re.getWidth() / ((double)this.m_max * 0.7) ? (float)(re.getHeight() / (double)this.m_numLayers) : (float)(re.getWidth() / ((double)this.m_max * 0.7));
        ViewPort viewPort = layers.getMapContext().getViewPort();
        int l = 0;
        for (int i = layers.getLayersCount() - 1; i >= 0; --i) {
            double yl;
            double xl;
            double dY;
            double dX;
            FLayer layer = layers.getLayer(i);
            boolean b = this.nameLayers.size() > l && this.nameLayers.get(l).equals(layer.getName()) ? this.areVisible.get(l).booleanValue() : layer.isVisible();
            ++l;
            if (!b) continue;
            if (layer instanceof FLayers) {
                n[0] = n[0] + 1;
                dX = 0.0;
                dY = (double)n[0] * h;
                xl = re.getX() + dX;
                yl = re.getY() + dY;
                if (layoutContext != null) {
                    this.toFFrameText(layoutContext, layer.getName(), re, sizefont, xl - re.getWidth() / 5.0, yl, h);
                } else {
                    this.drawNameLegend(g, layer.getName(), re, sizefont, xl - re.getWidth() / 5.0, yl, h);
                }
                n[0] = n[0] + 1;
                this.drawLegendOrToFFrame(g, re, h, (FLayers)layer, n, layoutContext);
                n[0] = n[0] + 1;
                continue;
            }
            if (layer instanceof Classifiable) {
                Classifiable cla_layer = (Classifiable)layer;
                ILegend cla_legend = cla_layer.getLegend();
                if (cla_legend instanceof IHasImageLegend) {
                    Image image = ((IHasImageLegend)cla_legend).getImageLegend();
                    String path = ((IHasImageLegend)cla_legend).getPathImage();
                    if (image != null) {
                        FFramePicture picture = (FFramePicture)this.layoutManager.createFrame("FFramePicture");
                        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
                        Graphics2D biContext = bi.createGraphics();
                        biContext.drawImage(image, 0, 0, null);
                        picture.setImage(bi);
                        double dY2 = (double)n[0] * h;
                        Rectangle2D.Double rectImage = new Rectangle2D.Double(re.getX(), re.getY() + dY2, re.getWidth(), h);
                        if (path != null && layoutContext != null) {
                            picture.setBoundBox(FLayoutUtilities.toSheetRect(rectImage, layoutContext.getAT()));
                            picture.setPath(path);
                            layoutContext.addFFrame(picture, false, true);
                        } else {
                            picture.setBoundBox(FLayoutUtilities.toSheetRect(rectImage, new AffineTransform()));
                            picture.draw(g, new AffineTransform(), re, bi);
                        }
                    } else {
                        double dX2 = 0.0;
                        double dY3 = (double)n[0] * h;
                        double xl2 = re.getX() + dX2;
                        double yl2 = re.getY() + dY3;
                        if (layoutContext != null) {
                            this.toFFrameText(layoutContext, layer.getName(), re, sizefont, xl2, yl2, h);
                        } else {
                            this.drawNameLegend(g, layer.getName(), re, sizefont, xl2, yl2, h);
                        }
                    }
                    n[0] = n[0] + 1;
                    continue;
                }
                if (cla_legend instanceof IClassifiedLegend) {
                    IClassifiedLegend cli = (IClassifiedLegend)cla_legend;
                    double dX3 = 0.0;
                    double dY4 = (double)n[0] * h;
                    double xl3 = re.getX() + dX3;
                    double yl3 = re.getY() + dY4;
                    if (layoutContext != null) {
                        this.toFFrameText(layoutContext, layer.getName(), re, sizefont, xl3 - re.getWidth() / 5.0, yl3, h);
                    } else {
                        this.drawNameLegend(g, layer.getName(), re, sizefont, xl3 - re.getWidth() / 5.0, yl3, h);
                    }
                    n[0] = n[0] + 1;
                    String[] descriptions = cli.getDescriptions();
                    ISymbol[] symbols = cli.getSymbols();
                    for (int j = 0; j < descriptions.length; ++j) {
                        dY4 = (double)n[0] * h;
                        xl3 = re.getX() + dX3;
                        yl3 = re.getY() + dY4;
                        String desc = descriptions[j];
                        if (layoutContext != null) {
                            this.toFFrameText(layoutContext, desc, re, sizefont, xl3, yl3, h);
                        } else {
                            this.drawNameLegend(g, desc, re, sizefont, xl3, yl3, h);
                        }
                        ISymbol fs2d = symbols[j];
                        if (layoutContext != null) {
                            try {
                                this.toFFrameSymbol(layoutContext, re, xl3, yl3, fs2d, sizefont, h, cla_layer.getShapeType(), viewPort);
                            }
                            catch (ReadException ex) {
                                ex.printStackTrace();
                            }
                        } else {
                            if (fs2d instanceof CartographicSupport) {
                                Geometry geom = null;
                                if (layer instanceof FLyrVect) {
                                    geom = ((FLyrVect)layer).getFeatureStore().getSampleFeature().getDefaultGeometry();
                                }
                                ((CartographicSupport)fs2d).setCartographicContext(viewPort, this.properties, geom);
                            }
                            this.drawSymbolLegend(g, re, xl3, yl3, fs2d, sizefont, h);
                        }
                        n[0] = n[0] + 1;
                    }
                    continue;
                }
                double dX4 = 0.0;
                double dY5 = (double)n[0] * h;
                double xl4 = re.getX() + dX4;
                double yl4 = re.getY() + dY5;
                if (layoutContext != null) {
                    this.toFFrameText(layoutContext, layer.getName(), re, sizefont, xl4, yl4, h);
                } else {
                    this.drawNameLegend(g, layer.getName(), re, sizefont, xl4, yl4, h);
                }
                if (cla_legend != null) {
                    ISymbol fs2d = cla_legend.getDefaultSymbol();
                    if (layoutContext != null) {
                        try {
                            this.toFFrameSymbol(layoutContext, re, xl4, yl4, fs2d, sizefont, h, cla_layer.getShapeType(), viewPort);
                        }
                        catch (ReadException e) {
                            e.printStackTrace();
                        }
                    } else {
                        if (fs2d instanceof CartographicSupport) {
                            Geometry geom = null;
                            if (layer instanceof FLyrVect) {
                                geom = ((FLyrVect)layer).getFeatureStore().getSampleFeature().getDefaultGeometry();
                            }
                            ((CartographicSupport)fs2d).setCartographicContext(viewPort, this.properties, geom);
                        }
                        this.drawSymbolLegend(g, re, xl4, yl4, fs2d, sizefont, h);
                    }
                }
                n[0] = n[0] + 1;
                continue;
            }
            dX = 0.0;
            dY = (double)n[0] * h;
            xl = re.getX() + dX;
            yl = re.getY() + dY;
            if (layoutContext != null) {
                this.toFFrameText(layoutContext, layer.getName(), re, sizefont, xl, yl, h);
            } else {
                this.drawNameLegend(g, layer.getName(), re, sizefont, xl, yl, h);
            }
            n[0] = n[0] + 1;
        }
    }

    private void drawNameLegend(Graphics2D g, String name, Rectangle2D re, float sizefont, double x, double y, double h) {
        Font f = this.getFont(sizefont);
        g.setFont(f);
        g.setColor(Color.black);
        if (name != null) {
            g.drawString(name, (float)(x + re.getWidth() / 4.0), (float)(y + h / 2.0));
        }
    }

    private Font getFont(float sizefont) {
        Font f = this.getFont();
        return new Font(f.getName(), f.getStyle(), (int)sizefont);
    }

    private void toFFrameText(LayoutContext layoutContext, String name, Rectangle2D re, float sizefont, double x, double y, double h) {
        Rectangle2D.Double rAux = new Rectangle2D.Double(x + re.getWidth() / 4.0, y + h / 2.0 - h, re.getWidth() - re.getWidth() / 4.0, h);
        FFrameText text = (FFrameText)this.layoutManager.createFrame("FFrameText");
        text.setFixedFontSize(true);
        double myScale = layoutContext.getAT().getScaleX() * 0.0234;
        text.setFontSize((int)((double)sizefont / myScale));
        text.setBoundBox(FLayoutUtilities.toSheetRect(rAux, layoutContext.getAT()));
        text.addText(name);
        layoutContext.addFFrame(text, false, true);
    }

    private void drawSymbolLegend(Graphics2D g, Rectangle2D re, double x, double y, ISymbol symbol2d, float sizefont, double h) {
        double pW = 5.0;
        double wl = re.getWidth() / pW;
        double haux = (double)sizefont * 0.7;
        Font font = null;
        if (symbol2d instanceof ITextSymbol && (font = ((ITextSymbol)symbol2d).getFont()) != null) {
            ((ITextSymbol)symbol2d).setFont(new Font(font.getFontName(), font.getStyle(), (int)(wl / 6.0)));
        }
        Rectangle rectangle = new Rectangle((int)x, (int)(y + h / 2.0 - haux), (int)wl, (int)haux);
        try {
            symbol2d.drawInsideRectangle(g, new AffineTransform(), rectangle);
        }
        catch (SymbolDrawingException ex) {
            if (ex.getType() == 0) {
                try {
                    this.mapContextManager.getSymbolManager().getWarningSymbol(SymbolDrawingException.STR_UNSUPPORTED_SET_OF_SETTINGS, symbol2d.getDescription(), 0).drawInsideRectangle(g, null, rectangle);
                }
                catch (SymbolDrawingException symbolDrawingException) {}
            }
            throw new Error(PluginServices.getText((Object)this, (String)"symbol_shapetype_mismatch"));
        }
    }

    private void toFFrameSymbol(LayoutContext layoutContext, Rectangle2D re, double x, double y, ISymbol fs2d, float sizefont, double h, int shapeType, ViewPort viewPort) {
        double pW = 5.0;
        double wl = re.getWidth() / pW;
        double haux = (double)sizefont * 0.7;
        Font font = null;
        if (fs2d instanceof ITextSymbol && (font = ((ITextSymbol)fs2d).getFont()) != null) {
            ((ITextSymbol)fs2d).setFont(new Font(font.getFontName(), font.getStyle(), (int)(wl / 6.0)));
        }
        Rectangle2D.Double rAux3 = new Rectangle2D.Double(x, y + h / 2.0 - haux, wl, haux);
        FFrameSymbol symbol = (FFrameSymbol)this.layoutManager.createFrame("FFrameSymbol");
        symbol.setBoundBox(FLayoutUtilities.toSheetRect(rAux3, layoutContext.getAT()));
        symbol.setSymbol(fs2d);
        symbol.setShapeType(shapeType);
        symbol.setViewPort(viewPort);
        layoutContext.addFFrame(symbol, false, true);
    }

    private int getSizeNum(FLayers layers) {
        int count = 0;
        int l = 0;
        for (int i = layers.getLayersCount() - 1; i >= 0; --i) {
            FLayer layer = layers.getLayer(i);
            boolean b = this.nameLayers.size() > l && this.nameLayers.get(l).equals(layer.getName()) ? this.areVisible.get(l).booleanValue() : layer.isVisible();
            ++l;
            if (!b) continue;
            if (layer.getName().length() > this.m_max) {
                this.m_max = layer.getName().length();
            }
            if (layer instanceof FLayers) {
                count += 3;
                count += this.getSizeNum((FLayers)layer);
                continue;
            }
            if (layer instanceof Classifiable) {
                Classifiable cO = (Classifiable)layer;
                ++count;
                if (!(cO.getLegend() instanceof IClassifiedLegend)) continue;
                IClassifiedLegend cli = (IClassifiedLegend)cO.getLegend();
                for (int j = 0; j < cli.getValues().length; ++j) {
                    String desc = cli.getDescriptions()[j];
                    if (desc != null && desc.length() > this.m_max) {
                        this.m_max = desc.length();
                    }
                    ++count;
                }
                continue;
            }
            String layerName = layer.getName();
            if (layerName != null && layerName.length() > this.m_max) {
                this.m_max = layerName.length();
            }
            ++count;
        }
        return count;
    }

    public void toFFrames(LayoutContext layout) {
        Rectangle2D.Double rectangle = this.getBoundingBox(null);
        double h = ((RectangularShape)rectangle).getHeight() / (double)this.m_numLayers;
        FLayers lays = this.layers;
        int[] n = new int[]{0};
        this.drawLegendOrToFFrame(null, rectangle, h, lays, n, layout);
        layout.delFFrame(this);
    }

    public void setFont(Font f) {
        this.m_font = f;
    }

    public Font getFont() {
        if (this.m_font != null) {
            return new Font(this.m_font.getName(), this.m_font.getStyle(), 9);
        }
        return new Font("SansSerif", 0, 9);
    }

    @Override
    public String getNameFFrame() {
        return PluginServices.getText((Object)this, (String)"leyenda") + this.num;
    }

    @Override
    public String getName() {
        return PERSISTENCE_DEFINITION_NAME;
    }

    public void print(Graphics2D g, AffineTransform at, Geometry geom, PrintAttributes properties) {
        this.properties = properties;
        this.draw(g, at, null, null);
        this.properties = null;
    }

    public void initialize() {
    }

    public void setNameLayers(List nameLayers) {
        this.nameLayers = nameLayers;
    }

    public void setAreVisible(List areVisible) {
        this.areVisible = areVisible;
    }

    public List getNameLayers() {
        return this.nameLayers;
    }

    public List getAreVisible() {
        return this.areVisible;
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(FFrameLegend.class, PERSISTENCE_DEFINITION_NAME, "FFrameLegend persistence definition", null, null);
            definition.extend(manager.getDefinition("AbstractFFrameViewDependence"));
            definition.addDynFieldInt(NUMLAYERS_FIELD).setMandatory(true);
            definition.addDynFieldInt(MAX_FIELD).setMandatory(true);
            definition.addDynFieldInt(QUALITY_FIELD).setMandatory(true);
            definition.addDynFieldInt(VIEWING_FIELD).setMandatory(true);
            definition.addDynFieldObject(FONT_FIELD).setClassOfValue(Font.class).setMandatory(true);
            definition.addDynFieldList(NAMELAYERS_FIELD).setClassOfItems(String.class).setMandatory(true);
            definition.addDynFieldList(AREVISIBLE_FIELD).setClassOfItems(Boolean.class).setMandatory(true);
        }
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.m_numLayers = state.getInt(NUMLAYERS_FIELD);
        this.m_max = state.getInt(MAX_FIELD);
        this.m_quality = state.getInt(QUALITY_FIELD);
        this.m_viewing = state.getInt(VIEWING_FIELD);
        this.m_font = (Font)state.get(FONT_FIELD);
        this.nameLayers = state.getList(NAMELAYERS_FIELD);
        this.areVisible = state.getList(AREVISIBLE_FIELD);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(NUMLAYERS_FIELD, this.m_numLayers);
        state.set(MAX_FIELD, this.m_max);
        state.set(QUALITY_FIELD, this.m_quality);
        state.set(VIEWING_FIELD, this.m_viewing);
        state.set(FONT_FIELD, (Object)this.getFont());
        state.set(NAMELAYERS_FIELD, this.nameLayers);
        state.set(AREVISIBLE_FIELD, this.areVisible);
    }
}

