/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import org.gvsig.andami.PluginServices;
import org.gvsig.app.project.documents.layout.fframes.FFrameGraphics;
import org.gvsig.app.project.documents.layout.geometryadapters.GeometryAdapter;
import org.gvsig.compat.print.PrintAttributes;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.fmap.mapcontext.ViewPort;
import org.gvsig.fmap.mapcontext.rendering.symbols.CartographicSupport;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.fmap.mapcontext.rendering.symbols.SymbolDrawingException;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.gvsig.tools.persistence.Persistent;
import org.gvsig.tools.persistence.PersistentState;
import org.gvsig.tools.persistence.exception.PersistenceException;

public class FFrameSymbol
extends FFrameGraphics {
    public static final String PERSISTENCE_DEFINITION_NAME = "FFrameSymbol";
    private static final String VIEWPORT_FIELD = "viewport";
    private PrintAttributes properties;
    private ViewPort viewPort;
    private final MapContextManager mapContextManager = MapContextLocator.getMapContextManager();

    @Override
    public void draw(Graphics2D g, AffineTransform at, Rectangle2D rv, BufferedImage imgBase) {
        Rectangle2D.Double re = this.getBoundingBox(at);
        g.rotate(Math.toRadians(this.getRotation()), re.x + re.width / 2.0, re.y + re.height / 2.0);
        if (this.intersects(rv, re)) {
            AffineTransform mT2 = new AffineTransform();
            mT2.setToIdentity();
            Rectangle rec = new Rectangle((int)re.x, (int)re.y, (int)re.width, (int)re.height);
            try {
                ISymbol sym = this.getFSymbol();
                if (sym instanceof CartographicSupport) {
                    ((CartographicSupport)sym).setCartographicContext(this.viewPort, this.properties, null);
                }
                sym.drawInsideRectangle(g, mT2, rec);
            }
            catch (SymbolDrawingException ex) {
                if (ex.getType() == 0) {
                    try {
                        this.mapContextManager.getSymbolManager().getWarningSymbol(SymbolDrawingException.STR_UNSUPPORTED_SET_OF_SETTINGS, this.getFSymbol().getDescription(), 0).drawInsideRectangle(g, null, rec);
                    }
                    catch (SymbolDrawingException symbolDrawingException) {}
                }
                throw new Error(PluginServices.getText((Object)this, (String)"symbol_shapetype_mismatch"));
            }
        }
        g.rotate(Math.toRadians(-this.getRotation()), re.x + re.width / 2.0, re.y + re.height / 2.0);
    }

    @Override
    public String getNameFFrame() {
        return PluginServices.getText((Object)this, (String)"simbolo") + this.num;
    }

    @Override
    public String getName() {
        return PERSISTENCE_DEFINITION_NAME;
    }

    @Override
    public void print(Graphics2D g, AffineTransform at, Geometry geom, PrintAttributes printingProperties) {
        this.properties = printingProperties;
        this.draw(g, at, null, null);
        this.properties = null;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void setBoundBox(Rectangle2D r) {
        this.m_BoundBox.setRect(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public void setShapeType(int shapeType) {
        this.setType(shapeType);
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(FFrameSymbol.class, PERSISTENCE_DEFINITION_NAME, "FFrameSymbol persistence definition", null, null);
            definition.extend(manager.getDefinition("FFrameGraphics"));
        }
        GeometryAdapter.registerPersistent();
    }

    @Override
    public void loadFromState(PersistentState state) throws PersistenceException {
        super.loadFromState(state);
        this.viewPort = (ViewPort)state.get(VIEWPORT_FIELD);
    }

    @Override
    public void saveToState(PersistentState state) throws PersistenceException {
        super.saveToState(state);
        state.set(VIEWPORT_FIELD, (Persistent)this.viewPort);
    }

    public void setViewPort(ViewPort viewPort) {
        this.viewPort = viewPort;
    }
}

