/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.gvsig.andami.PluginServices;
import org.gvsig.andami.ui.mdiManager.IWindow;
import org.gvsig.andami.ui.mdiManager.WindowInfo;
import org.gvsig.app.gui.panels.ColorChooserPanel;
import org.gvsig.app.gui.utils.FontChooser;
import org.gvsig.app.project.documents.layout.fframes.FFrameGrid;
import org.gvsig.app.project.documents.layout.fframes.FFrameGridCoordinateFormat;
import org.gvsig.app.project.documents.layout.fframes.IFFrame;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.AbstractFFrameDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.dialogs.IFFrameDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.numberFormat.DecimalFormatDialog;
import org.gvsig.app.project.documents.layout.fframes.gui.numberFormat.DecimalFormatPanel;
import org.gvsig.app.project.documents.layout.gui.LayoutPanel;
import org.gvsig.app.project.documents.view.legend.gui.PanelEditSymbol;
import org.gvsig.fmap.geom.primitive.Envelope;
import org.gvsig.fmap.mapcontext.MapContext;
import org.gvsig.fmap.mapcontext.rendering.symbols.ISymbol;
import org.gvsig.gui.beans.AcceptCancelPanel;
import org.gvsig.gui.beans.numberTextField.NumberTextField;
import org.gvsig.gui.beans.simplecombobox.SimpleComboBox;
import org.gvsig.gui.beans.swing.JNumberSpinner;
import org.gvsig.i18n.Messages;
import org.gvsig.math.intervals.IntervalUtils;

public class FFrameGridDialog
extends AbstractFFrameDialog
implements IFFrameDialog {
    private static final long serialVersionUID = 1L;
    private JPanel pnlMain = null;
    private JTextField txtIntervalX = null;
    private JPanel pnlIntervalGroup = null;
    private JTextField txtIntervalY = null;
    private JLabel lblUnitsX = null;
    private JLabel lblUnitsY = null;
    private JPanel jPanel8 = null;
    private JPanel jPanel9 = null;
    private JRadioButton rbPoints = null;
    private JRadioButton rbLines = null;
    private JButton bSymbol = null;
    private JPanel pnlLabelGroup = null;
    private JPanel pnlFont = null;
    private JButton jButton = null;
    private ColorChooserPanel colorChooserPanel = null;
    private FFrameGrid fframegrid;
    private AcceptCancelPanel accept;
    private FFrameGrid newFFrameGrid;
    private ISymbol symbol;
    private Font m_font;
    private ButtonGroup bg = new ButtonGroup();
    private NumberTextField tfNumDivHoriz = null;
    private NumberTextField tfNumDivVert = null;
    private JRadioButton rbHorizDiv = null;
    private JRadioButton rbVertDiv = null;
    private JPanel pnlDistance = null;
    private JRadioButton rbDistance = null;
    private JButton btnNumberFormat = null;
    private JNumberSpinner nfRotationHoriz = null;
    private JNumberSpinner nfRotationVert = null;
    private ButtonGroup btGrpInterval = null;
    private static final Insets defaultInsets = new Insets(4, 4, 4, 4);
    private FFrameGridCoordinateFormat format = new FFrameGridCoordinateFormat();
    private SimpleComboBox cbLblAnchor = null;
    private MapContext mapContext;
    private double frameRotation;

    public FFrameGridDialog(LayoutPanel layout, FFrameGrid fframe) {
        super(layout, fframe);
        this.fframegrid = fframe;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getPnlMain(), "Center");
        this.add((Component)this.getAcceptCancelPanel(), "South");
    }

    private JPanel getPnlMain() {
        if (this.pnlMain == null) {
            this.pnlMain = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.insets = defaultInsets;
            c.fill = 2;
            c.anchor = 23;
            c.gridx = 0;
            int row = 0;
            c.gridy = row++;
            c.gridwidth = 1;
            this.pnlMain.add((Component)this.getPnlIntervalGroup(), c);
            c.gridx = 1;
            c.fill = 0;
            this.pnlMain.add((Component)this.getPnlSymbologyGroup(), c);
            c.gridy = row++;
            c.gridx = 0;
            c.gridwidth = 2;
            c.fill = 2;
            this.pnlMain.add((Component)this.getPnlLabelGroup(), c);
        }
        return this.pnlMain;
    }

    private JTextField getTxtIntervalX() {
        if (this.txtIntervalX == null) {
            this.txtIntervalX = new JTextField(10);
            this.txtIntervalX.setText(String.valueOf(this.fframegrid.getIntervalX()));
            this.txtIntervalX.setName("txtIntervalX");
        }
        return this.txtIntervalX;
    }

    private JPanel getPnlIntervalGroup() {
        if (this.pnlIntervalGroup == null) {
            this.pnlIntervalGroup = new JPanel(new GridBagLayout());
            this.pnlIntervalGroup.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"Interval")));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.gridx = 0;
            c.insets = defaultInsets;
            int row = 0;
            c.gridy = row++;
            c.gridwidth = 2;
            this.pnlIntervalGroup.add((Component)this.getRbDistance(), c);
            c.gridx = 0;
            c.gridwidth = 2;
            c.gridy = row++;
            c.insets = new Insets(FFrameGridDialog.defaultInsets.top, 25, FFrameGridDialog.defaultInsets.bottom, FFrameGridDialog.defaultInsets.right);
            this.pnlIntervalGroup.add((Component)this.getPnlDistance(), c);
            c.gridx = 0;
            c.gridy = row++;
            c.insets = defaultInsets;
            c.gridwidth = 1;
            this.pnlIntervalGroup.add((Component)this.getRbHorizDiv(), c);
            c.gridx = 1;
            this.pnlIntervalGroup.add((Component)this.getTfNumDivHoriz(), c);
            c.gridy = row++;
            c.gridx = 0;
            this.pnlIntervalGroup.add((Component)this.getRbVertDiv(), c);
            c.gridx = 1;
            this.pnlIntervalGroup.add((Component)this.getTfNumDivVert(), c);
            this.getBtnGrpInterval().add(this.getRbDistance());
            this.getBtnGrpInterval().add(this.getRbVertDiv());
            this.getBtnGrpInterval().add(this.getRbHorizDiv());
        }
        return this.pnlIntervalGroup;
    }

    private JRadioButton getRbHorizDiv() {
        if (this.rbHorizDiv == null) {
            this.rbHorizDiv = new JRadioButton(Messages.getText((String)"Number_of_horizontal_divisions"));
            this.rbHorizDiv.setSelected(this.fframegrid.getUseNumDivisions() == 1);
        }
        return this.rbHorizDiv;
    }

    private JRadioButton getRbVertDiv() {
        if (this.rbVertDiv == null) {
            this.rbVertDiv = new JRadioButton(Messages.getText((String)"Number_of_vertical_divisions"));
            this.rbVertDiv.setSelected(this.fframegrid.getUseNumDivisions() == 2);
        }
        return this.rbVertDiv;
    }

    private JRadioButton getRbDistance() {
        if (this.rbDistance == null) {
            this.rbDistance = new JRadioButton(Messages.getText((String)"Distance"));
            this.rbDistance.setSelected(this.fframegrid.getUseNumDivisions() == 0);
        }
        return this.rbDistance;
    }

    private JPanel getPnlDistance() {
        if (this.pnlDistance == null) {
            this.pnlDistance = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            int row = 0;
            c.insets = new Insets(0, 0, 4, 4);
            c.gridy = row++;
            c.gridx = 0;
            c.anchor = 21;
            JLabel labelX = new JLabel("x");
            this.pnlDistance.add((Component)labelX, c);
            c.gridx = 1;
            c.insets = defaultInsets;
            this.pnlDistance.add((Component)this.getTxtIntervalX(), c);
            this.lblUnitsX = new JLabel();
            c.insets = new Insets(0, 4, 4, 0);
            c.gridx = 2;
            this.pnlDistance.add((Component)this.lblUnitsX, c);
            c.insets = new Insets(4, 0, 0, 4);
            c.gridy = row++;
            c.gridx = 0;
            JLabel labelY = new JLabel("y");
            this.pnlDistance.add((Component)labelY, c);
            c.insets = defaultInsets;
            c.gridx = 1;
            this.pnlDistance.add((Component)this.getTxtIntervalY(), c);
            this.lblUnitsY = new JLabel();
            c.gridx = 2;
            c.insets = new Insets(4, 4, 0, 0);
            this.pnlDistance.add((Component)this.lblUnitsY, c);
        }
        return this.pnlDistance;
    }

    private ButtonGroup getBtnGrpInterval() {
        if (this.btGrpInterval == null) {
            this.btGrpInterval = new ButtonGroup();
        }
        return this.btGrpInterval;
    }

    private NumberTextField getTfNumDivHoriz() {
        if (this.tfNumDivHoriz == null) {
            this.tfNumDivHoriz = new NumberTextField(3);
            this.tfNumDivHoriz.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (FFrameGridDialog.this.getRbHorizDiv().isSelected()) {
                        FFrameGridDialog.this.calculateDistance(1, FFrameGridDialog.this.tfNumDivHoriz.getIntValue());
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.tfNumDivHoriz.setValue((Object)new Integer(this.fframegrid.getNumDivisionsHoriz()));
        }
        return this.tfNumDivHoriz;
    }

    protected void calculateDistance(int axis, int numDivisions) {
        if (this.mapContext.getViewPort().getAdjustedEnvelope() != null) {
            Envelope env = this.mapContext.getViewPort().getAdjustedEnvelope();
            double interval = IntervalUtils.roundIntervalDivision(env.getLength(axis), numDivisions);
            this.getTxtIntervalX().setText(String.valueOf(interval));
            this.getTxtIntervalY().setText(String.valueOf(interval));
        }
    }

    private NumberTextField getTfNumDivVert() {
        if (this.tfNumDivVert == null) {
            this.tfNumDivVert = new NumberTextField(3);
            this.tfNumDivVert.addFocusListener(new FocusListener(){

                @Override
                public void focusLost(FocusEvent e) {
                    if (FFrameGridDialog.this.getRbVertDiv().isSelected()) {
                        FFrameGridDialog.this.calculateDistance(0, FFrameGridDialog.this.tfNumDivVert.getIntValue());
                    }
                }

                @Override
                public void focusGained(FocusEvent e) {
                }
            });
            this.tfNumDivVert.setValue((Object)new Integer(this.fframegrid.getNumDivisionsVert()));
        }
        return this.tfNumDivVert;
    }

    private JTextField getTxtIntervalY() {
        if (this.txtIntervalY == null) {
            this.txtIntervalY = new JTextField(10);
            this.txtIntervalY.setText(String.valueOf(this.fframegrid.getIntervalY()));
        }
        return this.txtIntervalY;
    }

    private JPanel getPnlSymbologyGroup() {
        if (this.jPanel8 == null) {
            this.jPanel8 = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            this.jPanel8.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"Simbologia")));
            c.anchor = 23;
            c.gridy = 0;
            c.gridx = 0;
            this.jPanel8.add((Component)this.getJPanel9(), c);
            c.anchor = 24;
            c.gridy = 1;
            this.jPanel8.add((Component)this.getBSymbol(), c);
        }
        return this.jPanel8;
    }

    private JPanel getJPanel9() {
        if (this.jPanel9 == null) {
            this.jPanel9 = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.anchor = 23;
            c.insets = new Insets(0, 0, 0, 8);
            this.jPanel9.add((Component)this.getRbPoints(), c);
            c.insets = new Insets(0, 0, 0, 0);
            c.gridx = 1;
            this.jPanel9.add((Component)this.getRbLines(), c);
        }
        return this.jPanel9;
    }

    private JRadioButton getRbPoints() {
        if (this.rbPoints == null) {
            this.rbPoints = new JRadioButton();
            this.bg.add(this.rbPoints);
            this.rbPoints.setSelected(!this.fframegrid.isLine());
            this.rbPoints.setText(PluginServices.getText((Object)this, (String)"points"));
        }
        return this.rbPoints;
    }

    private JRadioButton getRbLines() {
        if (this.rbLines == null) {
            this.rbLines = new JRadioButton();
            this.bg.add(this.rbLines);
            this.rbLines.setSelected(this.fframegrid.isLine());
            this.rbLines.setText(PluginServices.getText((Object)this, (String)"lines"));
        }
        return this.rbLines;
    }

    private JButton getBSymbol() {
        if (this.bSymbol == null) {
            this.bSymbol = new JButton();
            this.bSymbol.setText(PluginServices.getText((Object)this, (String)"symbol"));
            this.bSymbol.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanelEditSymbol pes = new PanelEditSymbol();
                    if (FFrameGridDialog.this.getRbLines().isSelected()) {
                        pes.setSymbol(FFrameGridDialog.this.fframegrid.getSymbolLine());
                        pes.setShapeType(2);
                    } else {
                        pes.setSymbol(FFrameGridDialog.this.fframegrid.getSymbolPoint());
                        pes.setShapeType(1);
                    }
                    PluginServices.getMDIManager().addWindow((IWindow)pes);
                    FFrameGridDialog.this.symbol = pes.getSymbol();
                }
            });
        }
        return this.bSymbol;
    }

    private JPanel getPnlLabelGroup() {
        if (this.pnlLabelGroup == null) {
            this.pnlLabelGroup = new JPanel(new GridBagLayout());
            this.pnlLabelGroup.setBorder(BorderFactory.createTitledBorder(Messages.getText((String)"Label")));
            GridBagConstraints c = new GridBagConstraints();
            int row = 0;
            c.insets = defaultInsets;
            c.gridx = 0;
            c.gridy = row++;
            c.gridwidth = 1;
            c.anchor = 21;
            this.pnlLabelGroup.add((Component)new JLabel(Messages.getText((String)"Number_format")), c);
            c.gridx = 1;
            this.pnlLabelGroup.add((Component)this.getBtnNumberFormat(), c);
            c.gridx = 0;
            c.gridy = row++;
            c.gridwidth = 1;
            this.pnlLabelGroup.add((Component)new JLabel(Messages.getText((String)"Horizontal_label_rotation")), c);
            c.gridx = 1;
            this.pnlLabelGroup.add((Component)this.getNfRotationHoriz(), c);
            c.gridy = row++;
            c.gridx = 0;
            this.pnlLabelGroup.add((Component)new JLabel(Messages.getText((String)"Vertical_label_rotation")), c);
            c.gridx = 1;
            this.pnlLabelGroup.add((Component)this.getNfRotationVert(), c);
            c.gridy = row++;
            c.gridx = 0;
            c.fill = 0;
            this.pnlLabelGroup.add((Component)new JLabel(Messages.getText((String)"Anchor")), c);
            c.gridx = 1;
            c.fill = 2;
            this.pnlLabelGroup.add((Component)this.getCbLblAnchor(), c);
            c.gridx = 0;
            c.gridy = row++;
            c.gridwidth = 2;
            this.pnlLabelGroup.add((Component)this.getPnlFont(), c);
        }
        return this.pnlLabelGroup;
    }

    private SimpleComboBox getCbLblAnchor() {
        if (this.cbLblAnchor == null) {
            this.cbLblAnchor = new SimpleComboBox();
            this.cbLblAnchor.addItem((Object)Messages.getText((String)"Corner"), 0);
            this.cbLblAnchor.addItem((Object)Messages.getText((String)"Center"), 1);
            this.cbLblAnchor.setSelectedCode(this.fframegrid.getLabelAnchor());
        }
        return this.cbLblAnchor;
    }

    private JButton getBtnNumberFormat() {
        if (this.btnNumberFormat == null) {
            this.btnNumberFormat = new JButton(Messages.getText((String)"Format"));
            this.format = this.fframegrid.getLabelFormat();
            this.btnNumberFormat.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FFrameGridDialog.this.openDecimalFormatDialog();
                }
            });
        }
        return this.btnNumberFormat;
    }

    protected void openDecimalFormatDialog() {
        final DecimalFormatDialog dialog = new DecimalFormatDialog(null, null);
        dialog.addOkButtonActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FFrameGridDialog.this.applyDecimalFormatSettings(dialog.getPanel());
            }
        });
        dialog.getPanel().setFormat(this.fframegrid.getLabelFormat());
        PluginServices.getMDIManager().addWindow((IWindow)dialog);
    }

    protected void applyDecimalFormatSettings(DecimalFormatPanel p) {
        this.format = p.getFormat();
    }

    private JNumberSpinner getNfRotationHoriz() {
        if (this.nfRotationHoriz == null) {
            this.nfRotationHoriz = new JNumberSpinner(0, 3, 0, 360, 1);
            this.nfRotationHoriz.setInteger((int)this.fframegrid.getHorizLabelRotation());
        }
        return this.nfRotationHoriz;
    }

    private JNumberSpinner getNfRotationVert() {
        if (this.nfRotationVert == null) {
            this.nfRotationVert = new JNumberSpinner(0, 3, 0, 360, 1);
            this.nfRotationVert.setInteger((int)this.fframegrid.getVertLabelRotation());
        }
        return this.nfRotationVert;
    }

    private JPanel getPnlFont() {
        if (this.pnlFont == null) {
            this.pnlFont = new JPanel(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.insets = new Insets(0, 0, 0, 4);
            c.gridy = 0;
            c.gridx = 0;
            this.pnlFont.add((Component)new JLabel(Messages.getText((String)"Font_type")), c);
            c.gridx = 1;
            c.insets = new Insets(0, 4, 0, 4);
            this.pnlFont.add((Component)this.getJButton(), c);
            c.gridx = 2;
            c.insets = new Insets(0, 4, 0, 0);
            this.pnlFont.add((Component)this.getColorChooserPanel(), c);
        }
        return this.pnlFont;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText(PluginServices.getText((Object)this, (String)"Font"));
            this.m_font = this.fframegrid.getFont();
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Font font = FontChooser.showDialog((String)PluginServices.getText((Object)this, (String)"__seleccion_de_fuente"), (Font)FFrameGridDialog.this.m_font);
                    if (font != null) {
                        FFrameGridDialog.this.m_font = font;
                    }
                }
            });
        }
        return this.jButton;
    }

    private ColorChooserPanel getColorChooserPanel() {
        if (this.colorChooserPanel == null) {
            this.colorChooserPanel = new ColorChooserPanel();
            this.colorChooserPanel.setAlpha(255);
            this.colorChooserPanel.setColor(this.fframegrid.getFontColor());
        }
        return this.colorChooserPanel;
    }

    @Override
    public IFFrame getFFrame() {
        return this.newFFrameGrid;
    }

    private AcceptCancelPanel getAcceptCancelPanel() {
        if (this.accept == null) {
            ActionListener okAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        FFrameGridDialog.this.newFFrameGrid = (FFrameGrid)FFrameGridDialog.this.fframegrid.clone();
                        FFrameGridDialog.this.newFFrameGrid.setIntervalX(Double.parseDouble(FFrameGridDialog.this.getTxtIntervalX().getText().toString()));
                        FFrameGridDialog.this.newFFrameGrid.setIntervalY(Double.parseDouble(FFrameGridDialog.this.getTxtIntervalY().getText().toString()));
                        if (FFrameGridDialog.this.getRbLines().isSelected()) {
                            if (FFrameGridDialog.this.symbol != null) {
                                FFrameGridDialog.this.newFFrameGrid.setSymbolLine(FFrameGridDialog.this.symbol);
                            }
                        } else if (FFrameGridDialog.this.symbol != null) {
                            FFrameGridDialog.this.newFFrameGrid.setSymbolPoint(FFrameGridDialog.this.symbol);
                        }
                        FFrameGridDialog.this.newFFrameGrid.setTextColor(FFrameGridDialog.this.getColorChooserPanel().getColor());
                        FFrameGridDialog.this.newFFrameGrid.setSizeFont(FFrameGridDialog.this.m_font.getSize());
                        FFrameGridDialog.this.newFFrameGrid.setIsLine(FFrameGridDialog.this.getRbLines().isSelected());
                        FFrameGridDialog.this.newFFrameGrid.setFont(FFrameGridDialog.this.m_font);
                        FFrameGridDialog.this.newFFrameGrid.setHorizLabelRotation(FFrameGridDialog.this.getNfRotationHoriz().getInteger());
                        FFrameGridDialog.this.newFFrameGrid.setVertLabelRotation(FFrameGridDialog.this.getNfRotationVert().getInteger());
                        FFrameGridDialog.this.newFFrameGrid.setLabelAnchor(FFrameGridDialog.this.getCbLblAnchor().getSelectedCode());
                        FFrameGridDialog.this.newFFrameGrid.setLabelFormat(FFrameGridDialog.this.format);
                        if (FFrameGridDialog.this.getRbDistance().isSelected()) {
                            FFrameGridDialog.this.newFFrameGrid.setUseNumDivisions(0);
                        } else if (FFrameGridDialog.this.getRbHorizDiv().isSelected()) {
                            FFrameGridDialog.this.newFFrameGrid.setUseNumDivisions(1);
                            FFrameGridDialog.this.newFFrameGrid.setNumDivisionsHoriz(FFrameGridDialog.this.getTfNumDivHoriz().getIntValue());
                        } else if (FFrameGridDialog.this.getRbVertDiv().isSelected()) {
                            FFrameGridDialog.this.newFFrameGrid.setUseNumDivisions(2);
                            FFrameGridDialog.this.newFFrameGrid.setNumDivisionsVert(FFrameGridDialog.this.getTfNumDivVert().getIntValue());
                        }
                    }
                    catch (CloneNotSupportedException e1) {
                        AbstractFFrameDialog.LOG.error("It is not possible clonate the object", (Object)e);
                    }
                    PluginServices.getMDIManager().closeWindow((IWindow)FFrameGridDialog.this);
                    FFrameGridDialog.this.notifyDialogClosed();
                    FFrameGridDialog.this.fireActionEvent(new ActionEvent(FFrameGridDialog.this, 1, "accept"));
                }
            };
            ActionListener cancelAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FFrameGridDialog.this.newFFrameGrid = null;
                    PluginServices.getMDIManager().closeWindow((IWindow)FFrameGridDialog.this);
                    FFrameGridDialog.this.notifyDialogClosed();
                }
            };
            this.accept = new AcceptCancelPanel(okAction, cancelAction);
            this.accept.setEnabled(true);
            this.accept.setVisible(true);
        }
        return this.accept;
    }

    @Override
    public WindowInfo getWindowInfo() {
        WindowInfo m_viewinfo = new WindowInfo(9);
        m_viewinfo.setTitle(PluginServices.getText((Object)this, (String)"Grid_settings"));
        m_viewinfo.setWidth(620);
        m_viewinfo.setHeight(440);
        return m_viewinfo;
    }

    @Override
    public boolean getIsAcepted() {
        return false;
    }

    public void setMapContext(MapContext mapContext) {
        this.mapContext = mapContext;
        if (mapContext != null) {
            String mapUnitsText = Messages.getText((String)MapContext.getDistanceNames()[mapContext.getViewPort().getMapUnits()]);
            this.lblUnitsX.setText(mapUnitsText);
            this.lblUnitsY.setText(mapUnitsText);
        }
    }

    public void setFrameRotation(double frameRotation) {
        this.frameRotation = frameRotation;
    }

    public Object getWindowProfile() {
        return WindowInfo.DIALOG_PROFILE;
    }

    @Override
    public void setRectangle(Rectangle2D r) {
    }
}

