/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.fframes.gui.numberFormat;

import java.text.DecimalFormatSymbols;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.apache.commons.lang3.StringUtils;
import org.gvsig.app.project.documents.layout.fframes.FFrameGridCoordinateFormat;
import org.gvsig.app.project.documents.layout.fframes.gui.numberFormat.DecimalFormatPanelView;
import org.gvsig.tools.swing.api.ToolsSwingLocator;
import org.gvsig.tools.swing.api.ToolsSwingManager;
import org.gvsig.tools.swing.api.ToolsSwingUtils;
import org.gvsig.tools.util.LabeledValue;
import org.gvsig.tools.util.LabeledValueImpl;

public class DecimalFormatPanel
extends DecimalFormatPanelView {
    private static final long serialVersionUID = 1L;
    public static final String INTEGER_BASE_PATTERN = "0";
    public static final String INTEGER_GROUPED_BASE_PATTERN = "#,###,###,###,###,###,##0";
    public static final String DECIMAL_BASE_PATTERN = "#0.";
    public static final String DECIMAL_GROUPED_BASE_PATTERN = "#,###,###,###,###,###,##0.";
    private FFrameGridCoordinateFormat format;
    private final double testNumberDD = 1.23456789E8;
    private final double testNumberDMS = 39.8912;
    private static final DecimalFormatSymbols defaultLocaleSymbols = DecimalFormatSymbols.getInstance();

    public DecimalFormatPanel() {
        this(new FFrameGridCoordinateFormat());
    }

    public DecimalFormatPanel(FFrameGridCoordinateFormat format) {
        this.initComponents();
        this.setFormat(format);
    }

    public DecimalFormatPanel(char decimalSeparator, char thousandsSeparator, int decimalDigits, String basePattern) {
        this.initComponents();
        DecimalFormatSymbols sym = new DecimalFormatSymbols();
        sym.setDecimalSeparator(decimalSeparator);
        sym.setGroupingSeparator(thousandsSeparator);
        String pattern = this.getPattern(basePattern, decimalDigits);
        FFrameGridCoordinateFormat f = new FFrameGridCoordinateFormat(pattern, sym);
        this.setFormat(f);
    }

    protected final void initComponents() {
        ToolsSwingManager toolsSwingManager = ToolsSwingLocator.getToolsSwingManager();
        toolsSwingManager.translate(this.lblDecimalDigits);
        toolsSwingManager.translate(this.lblDecimalSep);
        toolsSwingManager.translate(this.lblLabelResult);
        toolsSwingManager.translate(this.lblThousandsSep);
        toolsSwingManager.translate((AbstractButton)this.rdbUseDD);
        toolsSwingManager.translate((AbstractButton)this.rdbUseDMS);
        toolsSwingManager.translate(this.lblDMSFormat);
        this.cbDecimalSep.setModel(new DefaultComboBoxModel<LabeledValue>(new LabeledValue[]{new LabeledValueImpl(".", (Object)"."), new LabeledValueImpl(",", (Object)",")}));
        this.cbThousandsSep.setModel(new DefaultComboBoxModel<LabeledValue>(new LabeledValue[]{new LabeledValueImpl("None", null), new LabeledValueImpl(".", (Object)"."), new LabeledValueImpl(",", (Object)","), new LabeledValueImpl(" ", (Object)" ")}));
        this.tfDecimalDigits.setModel(new SpinnerNumberModel(0, 0, 100, 1));
        this.tfDecimalDigits.addChangeListener(e -> this.updateFormat(e.getSource()));
        this.rdbUseDD.setSelected(true);
        this.rdbUseDMS.setSelected(false);
        this.rdbUseDD.addActionListener(e -> this.updateFormat(e.getSource()));
        this.rdbUseDMS.addActionListener(e -> this.updateFormat(e.getSource()));
        this.cboDMSFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"%d\u00b0 %m' %.0s'' %N", "%-%d\u00b0 %m' %.0s''", "%d\u00b0 %m' %N", "%-%d\u00b0 %m'", "%d\u00b0 %N", "%-%d\u00b0", "%D\u00b0 %N", "%-%D\u00b0"}));
        this.cboDMSFormat.setSelectedIndex(0);
        this.cboDMSFormat.addActionListener(e -> this.updateFormat(e.getSource()));
        ToolsSwingUtils.ensureRowsCols((JComponent)this, (int)8, (int)50);
    }

    private void doTypeChanged() {
    }

    private String getPattern(String basePattern, int decimalDigits) {
        int pos = basePattern.indexOf(46);
        if (pos >= 0) {
            basePattern = basePattern.substring(0, pos + 1);
        }
        if (decimalDigits > 0) {
            return basePattern + String.format("%1$0" + decimalDigits + "d", 0);
        }
        return basePattern;
    }

    private JComboBox<LabeledValue<String>> getCbDecimalSep() {
        return this.cbDecimalSep;
    }

    private JComboBox<LabeledValue<String>> getCbThousandsSep() {
        return this.cbThousandsSep;
    }

    protected void updateFormat(Object source) {
        boolean b_thousandsSep;
        boolean b_decimalSep;
        String thousandsSeparator = (String)((LabeledValue)this.getCbThousandsSep().getSelectedItem()).getValue();
        String decimalSeparator = (String)((LabeledValue)this.getCbDecimalSep().getSelectedItem()).getValue();
        int decimalDigits = (Integer)this.getTfDecimalDigits().getValue();
        DecimalFormatSymbols sym = this.format.getDecimalFormatSymbols();
        if (decimalSeparator != null && decimalSeparator.length() > 0) {
            sym.setDecimalSeparator(decimalSeparator.charAt(0));
            b_decimalSep = true;
        } else {
            b_decimalSep = false;
        }
        if (thousandsSeparator != null && StringUtils.isNotEmpty((CharSequence)thousandsSeparator)) {
            sym.setGroupingSeparator(thousandsSeparator.charAt(0));
            b_thousandsSep = true;
        } else {
            b_thousandsSep = false;
        }
        String pattern = b_decimalSep && decimalDigits > 0 ? (b_thousandsSep ? this.getPattern(DECIMAL_GROUPED_BASE_PATTERN, decimalDigits) : this.getPattern(DECIMAL_BASE_PATTERN, decimalDigits)) : (b_thousandsSep ? INTEGER_GROUPED_BASE_PATTERN : INTEGER_BASE_PATTERN);
        this.format = new FFrameGridCoordinateFormat(pattern, sym);
        this.format.setDMSFormat((String)this.cboDMSFormat.getSelectedItem());
        if (this.rdbUseDD.isSelected()) {
            this.format.setType(0);
            this.getLbTestResult().setText(this.format.format(1.23456789E8));
        } else {
            this.format.setType(1);
            this.getLbTestResult().setText(this.format.format("NS", 39.8912));
        }
        if (source == this.getCbDecimalSep()) {
            if (!b_decimalSep) {
                this.getTfDecimalDigits().setValue(0);
            }
        } else if (decimalDigits > 0 && !b_decimalSep) {
            this.selectItem(this.getCbDecimalSep(), String.valueOf(defaultLocaleSymbols.getDecimalSeparator()));
        }
    }

    private JSpinner getTfDecimalDigits() {
        return this.tfDecimalDigits;
    }

    private JLabel getLbTestResult() {
        return this.lbResult;
    }

    public FFrameGridCoordinateFormat getFormat() {
        return this.format;
    }

    public final void setFormat(FFrameGridCoordinateFormat format) {
        this.format = format;
        boolean groupingUsed = format.isGroupingUsed();
        this.getTfDecimalDigits().setValue(format.getMinimumFractionDigits());
        String decSep = String.valueOf(format.getDecimalFormatSymbols().getDecimalSeparator());
        this.selectItem(this.getCbDecimalSep(), decSep);
        if (groupingUsed) {
            String thousandsSep = String.valueOf(format.getDecimalFormatSymbols().getGroupingSeparator());
            this.selectItem(this.getCbThousandsSep(), thousandsSep);
        }
    }

    private void selectItem(JComboBox cb, String item) {
        ComboBoxModel model = cb.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            if (!((String)((LabeledValue)model.getElementAt(i)).getValue()).equals(item)) continue;
            cb.setSelectedIndex(i);
            return;
        }
        cb.addItem(new LabeledValueImpl(item, (Object)item));
        cb.setSelectedItem(model.getSize());
    }
}

