/*
 * Decompiled with CFR 0.152.
 */
package org.gvsig.app.project.documents.layout.geometryadapters;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.gvsig.app.project.documents.layout.geometryadapters.GeometryAdapter;
import org.gvsig.fmap.geom.Geometry;
import org.gvsig.fmap.geom.exception.CreateGeometryException;
import org.gvsig.fmap.geom.primitive.Circle;
import org.gvsig.fmap.mapcontext.MapContextLocator;
import org.gvsig.fmap.mapcontext.MapContextManager;
import org.gvsig.symbology.fmap.mapcontext.rendering.symbol.line.ILineSymbol;
import org.gvsig.tools.ToolsLocator;
import org.gvsig.tools.dynobject.DynStruct;
import org.gvsig.tools.persistence.PersistenceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CircleAdapter
extends GeometryAdapter {
    public static final String PERSISTENCE_DEFINITION_NAME = "CircleAdapter";
    private static final Logger logger = LoggerFactory.getLogger(CircleAdapter.class);
    private Point2D pointPosition = new Point2D.Double();
    private AffineTransform identity = new AffineTransform();
    private MapContextManager mapContextManager = MapContextLocator.getMapContextManager();

    @Override
    public void paint(Graphics2D g, AffineTransform at, boolean andLastPoint) {
        if (this.getPoints().length > 0) {
            if (andLastPoint) {
                this.obtainShape(this.pointPosition);
            }
            Geometry shapeAux = this.getGeometry(at);
            ILineSymbol symbol = (ILineSymbol)this.mapContextManager.getSymbolManager().createSymbol("line");
            ILineSymbol redOutline = (ILineSymbol)MapContextLocator.getSymbolManager().createSymbol("line");
            redOutline.setLineColor(Color.red);
            symbol.draw(g, this.identity, shapeAux, null, null);
        }
    }

    @Override
    public void pointPosition(Point2D p) {
        this.pointPosition = p;
    }

    @Override
    public void obtainShape(Point2D p) {
        Point2D[] points = this.getPoints();
        double x = points[0].getX();
        double y = points[0].getY();
        double r = p.distance(points[0]);
        try {
            Circle circle = (Circle)geomManager.create(11, 0);
            double flatness = geomManager.getFlatness();
            geomManager.setFlatness(0.01);
            circle.setPoints(geomManager.createPoint(x, y, 0), r);
            geomManager.setFlatness(flatness);
            this.setGeometry((Geometry)circle);
        }
        catch (CreateGeometryException e) {
            logger.error("Error creating the circle", (Throwable)e);
        }
    }

    public static void registerPersistent() {
        PersistenceManager manager = ToolsLocator.getPersistenceManager();
        if (manager.getDefinition(PERSISTENCE_DEFINITION_NAME) == null) {
            DynStruct definition = manager.addDefinition(CircleAdapter.class, PERSISTENCE_DEFINITION_NAME, "Circle Adapter persistence definition", null, null);
            definition.extend(manager.getDefinition("GeometryAdapter"));
        }
    }
}

